rule bitcoin_ethereum : FILE MEMORY
{	
	meta:
		description = "Bitcoin/Ethereum detection, including base64 encoded addresses"
		author = "GetData"
		date = "2024-03-22"
		tags = "crypto"
		os = "windows"
		
	strings:		
		$key = /(L|K)[1-9A-HJ-NP-Za-km-z]{51}/ nocase
		$addr = /[13][a-km-zA-HJ-NP-Z1-9]{25,34}/ nocase

    // This is a simplistic pattern that might match base64-encoded Bitcoin/Ethereum addresses
    // The length and character set are approximate and will likely produce false positives
    $btc_eth_base64 = /[A-Za-z0-9+\/]{30,50}=*/ nocase
		
	condition:	
		any of them	
}
