rule ByteCode_MSIL_Ransomware_Eternity : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "ETERNITY"
        description         = "Yara rule that detects Eternity ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Eternity"
        tc_detection_factor = 5

    strings:

        $find_files = {
            02 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 7E ?? ?? ?? ?? 25 2D ?? 26 7E ?? ?? ?? ?? FE 06 ?? ??
            ?? ?? 73 ?? ?? ?? ?? 25 80 ?? ?? ?? ?? 28 ?? ?? ?? ?? 0A 06 6F ?? ?? ?? ?? 0C 2B ?? 08
            6F ?? ?? ?? ?? 0D 09 03 04 28 ?? ?? ?? ?? 08 6F ?? ?? ?? ?? 2D ?? DE ?? 08 2C ?? 08 6F
            ?? ?? ?? ?? DC 02 28 ?? ?? ?? ?? 0B 07 13 ?? 16 13 ?? 38 ?? ?? ?? ?? 11 ?? 11 ?? 9A 13
            ?? 11 ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 2D ?? 11 ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 2D ??
            11 ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 2D ?? 11 ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 2D ?? 11
            ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 2D ?? 11 ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 2D ?? 11 ??
            72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 2D ?? 11 ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 2D ?? 11 ?? 72
            ?? ?? ?? ?? 6F ?? ?? ?? ?? 2D ?? 11 ?? 03 04 28 ?? ?? ?? ?? DE ?? 26 DE ?? 11 ?? 17 58
            13 ?? 11 ?? 11 ?? 8E 69 3F ?? ?? ?? ?? 2A
        }

        $encrypt_files = {
            28 ?? ?? ?? ?? 7E ?? ?? ?? ?? 6F ?? ?? ?? ?? 0A 28 ?? ?? ?? ?? 06 6F ?? ?? ?? ?? 0A 02
            28 ?? ?? ?? ?? 0B 07 06 28 ?? ?? ?? ?? 0C 02 19 28 ?? ?? ?? ?? 0D 09 16 6A 6F ?? ?? ??
            ?? 09 6F ?? ?? ?? ?? 02 1C 73 ?? ?? ?? ?? 13 ?? 11 ?? 6F ?? ?? ?? ?? 2C ?? 28 ?? ?? ??
            ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 13 ?? 11 ?? 11 ?? 16 11 ?? 8E 69 6F ?? ?? ?? ?? 11 ??
            08 16 08 8E 69 6F ?? ?? ?? ?? 7E ?? ?? ?? ?? 17 58 80 ?? ?? ?? ?? 7E ?? ?? ?? ?? 02 6F
            ?? ?? ?? ?? DE ?? 11 ?? 2C ?? 11 ?? 6F ?? ?? ?? ?? DC 2A
        }

        $aes_encrypt = {
            14 0A 1E 8D ?? ?? ?? ?? 25 D0 ?? ?? ?? ?? 28 ?? ?? ?? ?? 0B 73 ?? ?? ?? ?? 0C 73 ?? ??
            ?? ?? 0D 09 20 ?? ?? ?? ?? 6F ?? ?? ?? ?? 09 20 ?? ?? ?? ?? 6F ?? ?? ?? ?? 03 07 20 ??
            ?? ?? ?? 73 ?? ?? ?? ?? 13 ?? 09 11 ?? 09 6F ?? ?? ?? ?? 1E 5B 6F ?? ?? ?? ?? 6F ?? ??
            ?? ?? 09 11 ?? 09 6F ?? ?? ?? ?? 1E 5B 6F ?? ?? ?? ?? 6F ?? ?? ?? ?? 09 17 6F ?? ?? ??
            ?? 08 09 6F ?? ?? ?? ?? 17 73 ?? ?? ?? ?? 13 ?? 11 ?? 02 16 02 8E 69 6F ?? ?? ?? ?? 11
            ?? 6F ?? ?? ?? ?? DE ?? 11 ?? 2C ?? 11 ?? 6F ?? ?? ?? ?? DC 08 6F ?? ?? ?? ?? 0A DE ??
            09 2C ?? 09 6F ?? ?? ?? ?? DC 08 2C ?? 08 6F ?? ?? ?? ?? DC 06 2A
        }

        $encrypt_pass = {
            72 ?? ?? ?? ?? 0A 06 73 ?? ?? ?? ?? 0B D0 ?? ?? ?? ?? 28 ?? ?? ?? ?? 73 ?? ?? ?? ?? 0C
            08 07 6F ?? ?? ?? ?? A5 ?? ?? ?? ?? 0D 73 ?? ?? ?? ?? 13 ?? 11 ?? 09 6F ?? ?? ?? ?? 7E
            ?? ?? ?? ?? 73 ?? ?? ?? ?? 13 ?? 28 ?? ?? ?? ?? 11 ?? 6F ?? ?? ?? ?? 13 ?? 11 ?? 11 ??
            16 6F ?? ?? ?? ?? 13 ?? 11 ?? 28 ?? ?? ?? ?? 13 ?? 16 28 ?? ?? ?? ?? 72 ?? ?? ?? ?? 28
            ?? ?? ?? ?? 11 ?? 28 ?? ?? ?? ?? 2A
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            $find_files
        ) and
        (
            $encrypt_files
        ) and
        (
            $aes_encrypt
        ) and
        (
            $encrypt_pass
        )
}