rule ByteCode_MSIL_Ransomware_TimeCrypt : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "TIMECRYPT"
        description         = "Yara rule that detects TimeCrypt ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "TimeCrypt"
        tc_detection_factor = 5

    strings:

        $find_files = {
            7E ?? ?? ?? ?? 0A 16 0B 38 ?? ?? ?? ?? 73 ?? ?? ?? ?? 0C 08 06 07 9A 7D ?? ?? ?? ?? 73
            ?? ?? ?? ?? 0D 09 08 7D ?? ?? ?? ?? 09 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 7D ?? ?? ?? ?? 09
            28 ?? ?? ?? ?? 7D ?? ?? ?? ?? 09 7B ?? ?? ?? ?? 72 ?? ?? ?? ?? 09 7B ?? ?? ?? ?? 28 ??
            ?? ?? ?? 09 7B ?? ?? ?? ?? 72 ?? ?? ?? ?? 09 7B ?? ?? ?? ?? 28 ?? ?? ?? ?? 09 7B ?? ??
            ?? ?? 72 ?? ?? ?? ?? 09 7B ?? ?? ?? ?? 28 ?? ?? ?? ?? 09 7B ?? ?? ?? ?? 7B ?? ?? ?? ??
            72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 2C ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 72 ?? ?? ?? ?? 28 ??
            ?? ?? ?? 73 ?? ?? ?? ?? 13 ?? 2B ?? 09 7B ?? ?? ?? ?? 7B ?? ?? ?? ?? 72 ?? ?? ?? ?? 28
            ?? ?? ?? ?? 2C ?? 1B 28 ?? ?? ?? ?? 73 ?? ?? ?? ?? 13 ?? 2B ?? 1F ?? 28 ?? ?? ?? ?? 73
            ?? ?? ?? ?? 13 ?? 11 ?? 2D ?? 2A 11 ?? 6F ?? ?? ?? ?? 09 FE 06 ?? ?? ?? ?? 73 ?? ?? ??
            ?? 28 ?? ?? ?? ?? 26 11 ?? 6F ?? ?? ?? ?? 09 FE 06 ?? ?? ?? ?? 73 ?? ?? ?? ?? 28 ?? ??
            ?? ?? 26 07 17 58 0B 07 06 8E 69 3F ?? ?? ?? ?? 2A
        }

        $encrypt_files = {
            02 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 2D ?? 73 ?? ?? ?? ?? 0A 06 03 6F ?? ?? ?? ?? 06 02 6F
            ?? ?? ?? ?? 26 06 02 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? DE ?? 06 2C ?? 06 6F
            ?? ?? ?? ?? DC 02 17 28 ?? ?? ?? ?? DE ?? 26 DE ?? 2A
        }

        $send_http_request = {
            1C 8D ?? ?? ?? ?? 25 16 72 ?? ?? ?? ?? A2 25 17 02 72 ?? ?? ?? ?? 72 ?? ?? ?? ?? 6F ??
            ?? ?? ?? 72 ?? ?? ?? ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? A2 25 18 72 ?? ?? ?? ?? A2 25 19
            03 A2 25 1A 72 ?? ?? ?? ?? A2 25 1B 04 28 ?? ?? ?? ?? A2 28 ?? ?? ?? ?? 0A 73 ?? ?? ??
            ?? 25 6F ?? ?? ?? ?? 6F ?? ?? ?? ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 06 6F ?? ?? ?? ?? 6F
            ?? ?? ?? ?? 26 DE ?? 26 DE ?? 2A
        }

        $send_dns_request = {
            1C 8D ?? ?? ?? ?? 25 16 04 28 ?? ?? ?? ?? A2 25 17 72 ?? ?? ?? ?? A2 25 18 03 A2 25 19
            72 ?? ?? ?? ?? A2 25 1A 02 72 ?? ?? ?? ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 72 ?? ?? ?? ??
            72 ?? ?? ?? ?? 6F ?? ?? ?? ?? A2 25 1B 72 ?? ?? ?? ?? A2 28 ?? ?? ?? ?? 28 ?? ?? ?? ??
            26 DE ?? 26 DE ?? 2A
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            $find_files
        ) and
        (
            $encrypt_files
        ) and
        (
            $send_http_request
        ) and
        (
            $send_dns_request
        )
}