rule ByteCode_MSIL_Ransomware_TimeTime : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "TIMETIME"
        description         = "Yara rule that detects TimeTime ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "TimeTime"
        tc_detection_factor = 5

    strings:

        $rename_files = {
            00 00 7E ?? ?? ?? ?? 6F ?? ?? ?? ?? 0A 2B ?? 12 ?? 28 ?? ?? ?? ?? 0B 00 07 28 ?? ?? ??
            ?? 16 FE 01 0C 08 2C ?? 2B ?? 00 00 07 07 7E ?? ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ??
            00 00 DE ?? 26 00 00 DE ?? 00 12 ?? 28 ?? ?? ?? ?? 2D ?? DE ?? 12 ?? FE 16 ?? ?? ?? ??
            6F ?? ?? ?? ?? 00 DC 2A
        }

        $find_files = {
            00 73 ?? ?? ?? ?? 0A 00 02 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 0B 07 2C ?? 06 0C DD ?? ?? ??
            ?? 02 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 0D 09 2C ?? 06 0C DD ?? ?? ?? ?? 02 72 ?? ?? ?? ??
            6F ?? ?? ?? ?? 13 ?? 11 ?? 2C ?? 06 0C DD ?? ?? ?? ?? 02 72 ?? ?? ?? ?? 6F ?? ?? ?? ??
            13 ?? 11 ?? 2C ?? 06 0C DD ?? ?? ?? ?? 02 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 13 ?? 11 ?? 2C
            ?? 06 0C DD ?? ?? ?? ?? 02 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 13 ?? 11 ?? 2C ?? 06 0C DD ??
            ?? ?? ?? 02 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 13 ?? 11 ?? 2C ?? 06 0C DD ?? ?? ?? ?? 02 72
            ?? ?? ?? ?? 6F ?? ?? ?? ?? 13 ?? 11 ?? 2C ?? 06 0C DD ?? ?? ?? ?? 02 72 ?? ?? ?? ?? 6F
            ?? ?? ?? ?? 13 ?? 11 ?? 2C ?? 06 0C DE ?? 00 02 28 ?? ?? ?? ?? 13 ?? 16 13 ?? 2B ?? 11
            ?? 11 ?? 9A 13 ?? 00 06 11 ?? 6F ?? ?? ?? ?? 00 00 11 ?? 17 58 13 ?? 11 ?? 11 ?? 8E 69
            32 ?? 00 02 28 ?? ?? ?? ?? 13 ?? 16 13 ?? 2B ?? 11 ?? 11 ?? 9A 13 ?? 00 06 11 ?? 28 ??
            ?? ?? ?? 6F ?? ?? ?? ?? 00 00 11 ?? 17 58 13 ?? 11 ?? 11 ?? 8E 69 32 ?? 00 DE ?? 13 ??
            00 00 DE ?? 06 0C 2B ?? 08 2A
        }

        $encrypt_folder = {
            00 02 28 ?? ?? ?? ?? 0A 00 06 6F ?? ?? ?? ?? 0B 38 ?? ?? ?? ?? 12 ?? 28 ?? ?? ?? ?? 0C
            00 00 08 7E ?? ?? ?? ?? 6F ?? ?? ?? ?? 16 FE 01 0D 09 2C ?? 00 16 13 ?? 16 13 ?? 08 73
            ?? ?? ?? ?? 28 ?? ?? ?? ?? 8C ?? ?? ?? ?? 17 8C ?? ?? ?? ?? 28 ?? ?? ?? ?? 13 ?? 08 19
            73 ?? ?? ?? ?? 13 ?? 00 11 ?? 6F ?? ?? ?? ?? 13 ?? 11 ?? 6F ?? ?? ?? ?? 13 ?? 00 DE ??
            11 ?? 2C ?? 11 ?? 6F ?? ?? ?? ?? 00 DC 11 ?? 16 FE 01 11 ?? 5F 11 ?? 5F 13 ?? 11 ?? 2C
            ?? 00 08 28 ?? ?? ?? ?? 00 00 00 00 DE ?? 26 00 00 DE ?? 00 12 ?? 28 ?? ?? ?? ?? 3A ??
            ?? ?? ?? DE ?? 12 ?? FE 16 ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 DC 2A
        }

        $encrypt_files = {
            00 02 7E ?? ?? ?? ?? 6F ?? ?? ?? ?? 0C 08 2C ?? 38 ?? ?? ?? ?? 02 7E ?? ?? ?? ?? 6F ??
            ?? ?? ?? 0D 09 2C ?? 2B ?? 02 28 ?? ?? ?? ?? 0A 06 8E 69 8D ?? ?? ?? ?? 0B 16 13 ?? 2B
            ?? 00 06 11 ?? 91 13 ?? 11 ?? 17 58 D1 13 ?? 11 ?? D2 13 ?? 07 11 ?? 11 ?? 9C 00 11 ??
            17 58 13 ?? 11 ?? 07 8E 69 FE 04 13 ?? 11 ?? 2D ?? 02 07 28 ?? ?? ?? ?? 00 02 02 7E ??
            ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 00 02 28 ?? ?? ?? ?? 00 02 28 ?? ?? ?? ?? 00 7E
            ?? ?? ?? ?? 02 6F ?? ?? ?? ?? 00 2A
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            $find_files
        ) and
        (
            $encrypt_files
        ) and
        (
            $encrypt_folder
        ) and
        (
            $rename_files
        )
}