rule Win32_Ransomware_Cincoo : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "CINCOO"
        description         = "Yara rule that detects Cincoo ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Cincoo"
        tc_detection_factor = 5

    strings:

        $find_files = {
            55 8B EC 6A ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 83 EC ?? 53 56 57 A1 ?? ?? ?? ??
            33 C5 50 8D 45 ?? 64 A3 ?? ?? ?? ?? 89 55 ?? 8B D9 83 7B ?? ?? 8B F3 8B 45 ?? 8B 7D
            ?? 89 45 ?? 72 ?? 8B 33 8D 4E ?? 66 8B 06 83 C6 ?? 66 85 C0 75 ?? 2B F1 D1 FE 0F 84
            ?? ?? ?? ?? 3B 73 ?? 0F 85 ?? ?? ?? ?? 88 45 ?? 8D 55 ?? FF 75 ?? 8D 4D ?? C7 45 ??
            ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 8D 45 ?? C7 45 ?? ?? ?? ??
            ?? 50 8B CB E8 ?? ?? ?? ?? 8B 55 ?? 83 FA ?? 72 ?? 8B 4D ?? 8D 14 55 ?? ?? ?? ?? 8B
            C1 81 FA ?? ?? ?? ?? 72 ?? 8B 49 ?? 83 C2 ?? 2B C1 83 C0 ?? 83 F8 ?? 0F 87 ?? ?? ??
            ?? 52 51 E8 ?? ?? ?? ?? 83 C4 ?? 83 7B ?? ?? 72 ?? 8B 1B 8B 75 ?? 57 56 53 E8 ?? ??
            ?? ?? 85 C0 75 ?? 8B 36 8B CF E8 ?? ?? ?? ?? 84 C0 74 ?? 57 56 E8 ?? ?? ?? ?? 85 C0
            75 ?? 8B CF E8 ?? ?? ?? ?? 84 C0 75 ?? 33 C0 8B 4D ?? 64 89 0D ?? ?? ?? ?? 59 5F 5E
            5B 8B E5 5D C3
        }

        $encrypt_files = {
            55 8B EC 83 EC ?? 8B 45 ?? 53 8B D9 89 45 ?? B9 ?? ?? ?? ?? 8B C1 56 8B 53 ?? 2B C2
            8B 75 ?? 89 55 ?? 57 3B C6 0F 82 ?? ?? ?? ?? 8B 7B ?? 8D 04 32 8B F0 89 45 ?? 83 CE
            ?? 89 7D ?? 3B F1 76 ?? 8B F1 EB ?? 8B C7 D1 E8 2B C8 3B F9 76 ?? BE ?? ?? ?? ?? EB
            ?? 03 C7 3B F0 0F 42 F0 33 C9 8B C6 83 C0 ?? 0F 92 C1 F7 D9 0B C8 81 F9 ?? ?? ?? ??
            72 ?? 8D 41 ?? 3B C1 0F 86 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 0F 84 ?? ??
            ?? ?? 8B 55 ?? 8D 78 ?? 83 E7 ?? 89 47 ?? EB ?? 85 C9 74 ?? 51 E8 ?? ?? ?? ?? 8B 55
            ?? 83 C4 ?? 8B F8 EB ?? 33 FF 8B 45 ?? 89 43 ?? 8B 45 ?? 89 73 ?? 8D 34 3A 03 C6 83
            7D ?? ?? 89 45 ?? 52 72 ?? 8B 33 56 57 E8 ?? ?? ?? ?? FF 75 ?? 8B 45 ?? FF 75 ?? 03
            C7 50 E8 ?? ?? ?? ?? 8B 45 ?? 83 C4 ?? 8B 4D ?? 41 C6 00 ?? 81 F9 ?? ?? ?? ?? 72 ??
            8B 56 ?? 83 C1 ?? 2B F2 8D 46 ?? 83 F8 ?? 77 ?? 8B F2 51 56 E8 ?? ?? ?? ?? 83 C4 ??
            89 3B 8B C3 5F 5E 5B 8B E5 5D C2 ?? ?? 53 57 E8 ?? ?? ?? ?? FF 75 ?? FF 75 ?? 56 E8
            ?? ?? ?? ?? 8B 45 ?? 83 C4 ?? C6 00 ?? 8B C3 89 3B 5F 5E 5B 8B E5 5D C2 ?? ?? E8 ??
            ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? CC CC CC 56 8B F1 FF 76 ?? E8 ?? ?? ?? ?? 8B
            4E ?? 83 F9 ?? 72 ?? 8B 06 8D 0C 4D ?? ?? ?? ?? 81 F9 ?? ?? ?? ?? 72 ?? 8B 50 ?? 83
            C1 ?? 2B C2 83 C0 ?? 83 F8 ?? 77 ?? 8B C2 51 50 E8 ?? ?? ?? ?? 83 C4 ?? C7 46 ?? ??
            ?? ?? ?? 33 C0 C7 46 ?? ?? ?? ?? ?? 66 89 06 5E C3 E8 ?? ?? ?? ?? CC CC CC CC CC CC
            8B 09 85 C9 74 ?? 8B 01 6A ?? FF 10 C3
        }

        $drop_ransom_note = {
            52 51 E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 83 C4 ?? 83 F8 ?? 74 ?? 8D 4D ?? C6 46 ?? ??
            E8 ?? ?? ?? ?? 8B 45 ?? E9 ?? ?? ?? ?? 8B CE C6 45 ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 84
            ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D ?? C7 45 ?? ??
            ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C6 45 ?? ?? C6 45 ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ??
            8D 85 ?? ?? ?? ?? C6 45 ?? ?? 6A ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8D 85 ?? ?? ?? ?? 8D
            4E ?? 50 E8 ?? ?? ?? ?? 81 CF ?? ?? ?? ?? 89 BD ?? ?? ?? ?? C6 45 ?? ?? 8B 95 ?? ??
            ?? ?? 8B C2 8B 8D ?? ?? ?? ?? 2B C1 89 8D ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 83 F8 ??
            72 ?? 83 FA ?? 8D B5 ?? ?? ?? ?? 8D 41 ?? 0F 43 B5 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 8D
            04 0E 50 E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 83 C4 ?? C6 44 30 ?? ?? 8D 85 ?? ?? ?? ??
            EB
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            $find_files
        ) and
        (
            $encrypt_files
        ) and
        (
            $drop_ransom_note
        )
}