import "pe"

rule Win32_Ransomware_CryptoLocker : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "CRYPTOLOCKER"
        description         = "Yara rule that detects CryptoLocker ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "CryptoLocker"
        tc_detection_factor = 5

    strings:

        $file_loop_1 = {
            55 8B EC 83 EC ?? 53 56 8B D9 57 89 5D ?? E8 ?? ?? ?? ?? 84 C0 0F 84 ?? ?? ?? ?? 32 C9 83 7D ?? ?? 88 4D ?? 0F 86 45 01 
            00 00 8B 5D ?? 0F 57 C0 66 0F 13 45 ?? 84 C9 74 08 6A ?? FF 15 ?? ?? ?? ?? 6A ?? 6A ?? FF 75 ?? FF 75 ?? FF 33 FF 15 ?? 
            ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 8D 45 ?? 50 FF 33 FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 8B 4D ?? 8B 55 ?? 8B 75 ?? 
            6A ?? 8B 49 ?? 6A ?? 52 56 8B 01 6A ?? 89 55 ?? 8B 00 FF D0 84 C0 0F 84 E6 00 00 00 FF 15 ?? ?? ?? ?? 8B 7D ?? 33 D2 89 
            45 ?? 8B D8 85 FF 72 18 77 08 81 FE ?? ?? ?? ?? 76 0E B8 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? EB 05 8B C6 89 7D ?? 3B D0 73 
            0F 8B 45 ?? 8D 0C 13 8B 40 ?? 88 0C 02 42 EB CC 8B 5D ?? 85 FF 8B FE 75 04 85 F6 74 6B 85 DB 77 0E 72 08 81 FF ?? ?? ?? 
            ?? 73 04 8B F7 EB 05 BE ?? ?? ?? ?? 6A ?? 8D 45 ?? 50 8B 45 ?? 56 FF 70 ?? 8B 45 ?? FF 30 FF 15 ?? ?? ?? ?? 85 C0 74 ?? 
            39 75 ?? 75 ?? 8B 45 ?? 2B FE 8B 55 ?? 83 DB ?? 2B D7 8B 48 ?? 8B 45 ?? 1B C3 50 8B 31 52 FF 75 ?? FF 75 ?? 8B 06 6A ?? 
            FF D0 84 C0 74 34 85 DB 77 AD 72 04 85 FF 75 95 8B 5D ?? FF 33 FF 15 ?? ?? ?? ?? 8A 4D ?? FE C1 0F B6 C1 88 4D ?? 3B 45 
            ?? 0F 82 C6 FE FF FF B0 ?? 5F 5E 5B 8B E5 5D C2
        }

        $file_loop_2 = {
            55 8B EC 83 EC ?? 53 56 8B D9 57 89 5D ?? E8 ?? ?? ?? ?? 84 C0 0F 84 ?? ?? ?? ?? 32 C9 83 7D ?? ?? 88 4D ?? 0F 86 50 01 
            00 00 8B 5D ?? 0F 57 C0 66 0F 13 45 ?? 84 C9 74 08 6A ?? FF 15 ?? ?? ?? ?? 6A ?? 6A ?? FF 75 ?? FF 75 ?? FF 33 FF 15 ?? 
            ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 8D 45 ?? 50 FF 33 FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 8B 4D ?? 8B 55 ?? 8B 49 ?? 
            8B 75 ?? 8B 01 6A ?? 8B 00 6A ?? 52 56 6A ?? 89 55 ?? FF D0 84 C0 0F 84 F1 00 00 00 FF 15 ?? ?? ?? ?? 8B 7D ?? 89 45 ?? 
            33 D2 8B D8 85 FF 72 18 77 08 81 FE ?? ?? ?? ?? 76 0E B8 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? EB 05 8B C6 89 7D ?? 3B D0 73 
            10 8B 45 ?? 8D 0C 13 8B 40 ?? 42 88 4C 02 ?? EB CB 8B 5D ?? 85 FF 8B FE 75 04 85 F6 74 75 85 DB 77 11 72 08 81 FF ?? ?? 
            ?? ?? 73 07 8B F7 89 5D ?? EB 0C BE ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 6A ?? 8D 45 ?? 50 8B 45 ?? 56 FF 70 ?? 8B 45 ?? FF 
            30 FF 15 ?? ?? ?? ?? 85 C0 74 ?? 39 75 ?? 75 ?? 8B 45 ?? 8B 55 ?? 8B 48 ?? 8B 45 ?? 2B FE 8B 31 83 DB ?? 2B D7 1B C3 50 
            8B 06 52 FF 75 ?? FF 75 ?? 6A ?? FF D0 84 C0 74 34 85 DB 77 A6 72 04 85 FF 75 8B 8B 5D ?? FF 33 FF 15 ?? ?? ?? ?? 8A 4D 
            ?? FE C1 0F B6 C1 88 4D ?? 3B 45 ?? 0F 82 BB FE FF FF B0 ?? 5F 5E 5B 8B E5 5D C2
        }

        $file_loop_3 = {
            55 8B EC 83 EC ?? 53 56 8B C1 57 89 45 ?? E8 ?? ?? ?? ?? 84 C0 0F 84 62 01 00 00 8B 5D ?? 32 C0 0F 57 C0 88 45 ?? 66 0F 
            13 45 ?? EB 03 8D 49 ?? 84 C0 74 08 6A ?? FF 15 ?? ?? ?? ?? 6A ?? 6A ?? FF 75 ?? FF 75 ?? FF 33 FF 15 ?? ?? ?? ?? 85 C0 
            0F 84 27 01 00 00 8D 45 ?? 50 FF 33 FF 15 ?? ?? ?? ?? 85 C0 0F 84 13 01 00 00 8B 4D ?? 8B 55 ?? 8B 49 ?? 8B 75 ?? 8B 01 
            6A ?? 8B 00 6A ?? 52 56 6A ?? 89 55 ?? FF D0 84 C0 0F 84 EE 00 00 00 FF 15 ?? ?? ?? ?? 8B 7D ?? 89 45 ?? 33 D2 8B D8 90 
            85 FF 72 18 77 08 81 FE ?? ?? ?? ?? 76 0E B8 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? EB 05 8B C6 89 7D ?? 3B D0 73 10 8B 45 ?? 
            8D 0C 13 8B 40 ?? 42 88 4C 02 ?? EB CB 8B 5D ?? 85 FF 8B FE 75 04 85 F6 74 75 85 DB 77 11 72 08 81 FF ?? ?? ?? ?? 73 07 
            8B F7 89 5D ?? EB 0C BE ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 6A ?? 8D 45 ?? 50 8B 45 ?? 56 FF 70 ?? 8B 45 ?? FF 30 FF 15 ?? 
            ?? ?? ?? 85 C0 74 5E 39 75 ?? 75 59 8B 45 ?? 8B 55 ?? 8B 48 ?? 8B 45 ?? 2B FE 8B 31 83 DB ?? 2B D7 1B C3 50 8B 06 52 FF 
            75 ?? FF 75 ?? 6A ?? FF D0 84 C0 74 30 85 DB 77 A6 72 04 85 FF 75 8B 8B 5D ?? FF 33 FF 15 ?? ?? ?? ?? 8A 45 ?? FE C0 88 
            45 ?? 3C ?? 0F 82 BE FE FF FF B0 ?? 5F 5E 5B 8B E5 5D C2
        }

        $encrypt_data_1 = {
            55 8B EC 56 8B 75 ?? 57 8B F9 39 75 ?? 73 09 5F 83 C8 ?? 5E 5D C2 ?? ?? 8B 07 53 85 C0 74 58 48 83 F8 ?? 77 48 8B 5D ?? 
            8B 45 ?? 3B D8 74 0B 56 50 53 E8 ?? ?? ?? ?? 83 C4 ?? FF 75 ?? 8D 45 ?? 89 75 ?? 50 8B 45 ?? 53 6A ?? 0F B6 C0 50 6A ?? 
            FF 77 ?? FF 15 ?? ?? ?? ?? 8B 4D ?? 83 CA ?? 85 C0 5B 0F 44 CA 5F 8B C1 5E 5D C2 ?? ?? 5B 5F 83 C8 ?? 5E 5D C2 ?? ?? 8B 
            47 ?? 33 D2 89 45 ?? 8B 47 ?? 85 F6 74 26 8B 7D ?? 8B DE 8B 4D ?? 8B F0 2B F9 8A 04 0F 8D 49 ?? 32 04 32 88 41 ?? 8D 42 
            ?? 33 D2 F7 75 ?? 4B 75 E9 8B 75 ?? 5B 5F 8B C6 5E 5D C2
        }

        $encrypt_data_2 = {
            55 8B EC 56 8B 75 ?? 57 8B F9 39 75 ?? 73 09 5F 83 C8 ?? 5E 5D C2 ?? ?? 8B 07 53 85 C0 74 56 48 83 F8 ?? 77 46 8B 5D ?? 
            8B 45 ?? 3B D8 74 0B 56 50 53 E8 ?? ?? ?? ?? 83 C4 ?? FF 75 ?? 8D 45 ?? 50 0F B6 45 ?? 53 6A ?? 50 6A ?? FF 77 ?? 89 75 
            ?? FF 15 ?? ?? ?? ?? 8B 4D ?? 83 CA ?? 85 C0 5B 0F 44 CA 5F 8B C1 5E 5D C2 ?? ?? 5B 5F 83 C8 ?? 5E 5D C2 ?? ?? 8B 47 ?? 
            33 D2 89 45 ?? 8B 47 ?? 85 F6 74 26 8B 4D ?? 8B 7D ?? 8B DE 2B F9 8B F0 8A 04 0F 32 04 32 8D 49 ?? 88 41 ?? 8D 42 ?? 33 
            D2 F7 75 ?? 4B 75 E9 8B 75 ?? 5B 5F 8B C6 5E 5D C2
        }

        $encrypt_data_3 = {
            55 8B EC 53 56 8B 75 ?? 8B D9 39 75 ?? 72 4C 83 3B ?? 77 47 8B 45 ?? 57 8B 7D ?? 3B F8 74 0B 56 50 57 E8 ?? ?? ?? ?? 83 
            C4 ?? FF 75 ?? 8D 45 ?? 50 0F B6 45 ?? 57 6A ?? 50 6A ?? FF 73 ?? 89 75 ?? FF 15 ?? ?? ?? ?? 8B 4D ?? 83 CA ?? 85 C0 5F 
            0F 44 CA 5E 8B C1 5B 5D C2 ?? ?? 5E 83 C8 ?? 5B 5D C2
        }

        $decrypt_data_1 = {
            55 8B EC 53 56 57 8B F9 8B 07 85 C0 74 53 48 83 F8 ?? 77 55 8B 75 ?? 39 75 ?? 72 4D 8B 5D ?? 8B 45 ?? 3B D8 74 0B 56 50 
            53 E8 ?? ?? ?? ?? 83 C4 ?? 8D 45 ?? 89 75 ?? 50 8B 45 ?? 53 6A ?? 0F B6 C0 50 6A ?? FF 77 ?? FF 15 ?? ?? ?? ?? 8B 4D ?? 
            83 CA ?? 85 C0 5F 0F 44 CA 5E 8B C1 5B 5D C2 ?? ?? 8B 75 ?? 39 75 ?? 73 0A 5F 5E 83 C8 ?? 5B 5D C2 ?? ?? 8B 47 ?? 33 D2 
            89 45 ?? 8B 47 ?? 85 F6 74 28 8B 7D ?? 8B DE 8B 4D ?? 8B F0 2B F9 8B FF 8A 04 0F 8D 49 ?? 32 04 32 88 41 ?? 8D 42 ?? 33 
            D2 F7 75 ?? 4B 75 E9 8B 75 ?? 5F 8B C6 5E 5B 5D C2
        }

        $decrypt_data_2 = {
            55 8B EC 53 56 57 8B F9 8B 07 85 C0 74 51 48 83 F8 ?? 77 53 8B 75 ?? 39 75 ?? 72 4B 8B 5D ?? 8B 45 ?? 3B D8 74 0B 56 50 
            53 E8 ?? ?? ?? ?? 83 C4 ?? 8D 45 ?? 50 0F B6 45 ?? 53 6A ?? 50 6A ?? FF 77 ?? 89 75 ?? FF 15 ?? ?? ?? ?? 8B 4D ?? 83 CA 
            ?? 85 C0 5F 0F 44 CA 5E 8B C1 5B 5D C2 ?? ?? 8B 75 ?? 39 75 ?? 73 0A 5F 5E 83 C8 ?? 5B 5D C2 ?? ?? 8B 47 ?? 33 D2 89 45 
            ?? 8B 47 ?? 85 F6 74 2A 8B 4D ?? 8B 7D ?? 8B DE 2B F9 8B F0 8D 64 24 ?? 8A 04 0F 32 04 32 8D 49 ?? 88 41 ?? 8D 42 ?? 33 
            D2 F7 75 ?? 4B 75 E9 8B 75 ?? 5F 8B C6 5E 5B 5D C2 
        }

        $decrypt_data_3 = {
            55 8B EC 53 8B D9 83 3B ?? 77 56 56 8B 75 ?? 39 75 ?? 73 09 5E 83 C8 ?? 5B 5D C2 ?? ?? 8B 45 ?? 57 8B 7D ?? 3B F8 74 0B 
            56 50 57 E8 ?? ?? ?? ?? 83 C4 ?? 8D 45 ?? 50 0F B6 45 ?? 57 6A ?? 50 6A ?? FF 73 ?? 89 75 ?? FF 15 ?? ?? ?? ?? 8B 4D ?? 
            83 CA ?? 85 C0 5F 0F 44 CA 5E 8B C1 5B 5D C2 ?? ?? 83 C8 ?? 5B 5D C2
        }

        $decrypt_strings_1 = {
            55 8B EC 53 56 8B D9 8B F2 57 33 C9 33 FF 2B DE 8B 45 ?? 8D 14 31 8A 04 07 02 C1 32 04 13 88 02 8D 47 ?? 33 D2 F7 75 ?? 
            8B FA F6 C1 ?? 75 0B 8B C1 D1 E8 66 83 3C 46 ?? 74 03 41 EB D3 D1 E9 5F 5E 5B 8D 41 ?? 5D C3 
        }

        $decrypt_strings_2 = {
            55 8B EC 53 56 8B D9 57 8B F2 33 C9 33 FF 2B DE 8B 45 ?? 8D 14 31 8A 04 07 02 C1 32 04 13 88 02 8D 47 ?? 33 D2 F7 75 ?? 
            8B FA F6 C1 ?? 75 0B 8B C1 D1 E8 66 83 3C 46 ?? 74 03 41 EB D3 5F D1 E9 5E 8D 41 ?? 5B 5D C3
        }

        $decrypt_1 = {
            A1 ?? ?? ?? ?? 3D ?? ?? ?? ?? 0F 8C B7 00 00 00 33 D2 8B 0C 95 ?? ?? ?? ?? 33 0C 95 ?? ?? ?? ?? 81 E1 ?? ?? ?? ?? 33 0C 
            95 ?? ?? ?? ?? 8B C1 D1 E9 83 E0 ?? 33 0C 85 ?? ?? ?? ?? 33 0C 95 ?? ?? ?? ?? 89 0C 95 ?? ?? ?? ?? 42 81 FA ?? ?? ?? ?? 
            7C C0 81 FA ?? ?? ?? ?? 7D 39 56 8D 34 95 ?? ?? ?? ?? 8B 0E 33 4E ?? 81 E1 ?? ?? ?? ?? 33 0E 8B C1 D1 E9 83 E0 ?? 8B 04 
            85 ?? ?? ?? ?? 33 86 ?? ?? ?? ?? 33 C1 89 06 83 C6 ?? 81 FE ?? ?? ?? ?? 7C D0 5E 8B 0D ?? ?? ?? ?? 33 0D ?? ?? ?? ?? 81 
            E1 ?? ?? ?? ?? 33 0D ?? ?? ?? ?? 8B C1 D1 E9 83 E0 ?? 33 0C 85 ?? ?? ?? ?? 33 0D ?? ?? ?? ?? 33 C0 89 0D ?? ?? ?? ?? 8B 
            0C 85 ?? ?? ?? ?? 40 A3 ?? ?? ?? ?? 8B C1 C1 E8 ?? 33 C8 8B C1 25 ?? ?? ?? ?? C1 E0 ?? 33 C8 8B C1 25 ?? ?? ?? ?? C1 E0 
            ?? 33 C8 8B C1 C1 E8 ?? 33 C1 C3
        }

        $decrypt_2 = {
            A1 ?? ?? ?? ?? 3D ?? ?? ?? ?? 0F 8C C7 00 00 00 33 D2 EB 0C 8D A4 24 ?? ?? ?? ?? EB 03 8D 49 ?? 8B 0C 95 ?? ?? ?? ?? 33 
            0C 95 ?? ?? ?? ?? 42 81 E1 ?? ?? ?? ?? 33 0C 95 ?? ?? ?? ?? 8B C1 83 E0 ?? D1 E9 33 0C 85 ?? ?? ?? ?? 33 0C 95 ?? ?? ?? 
            ?? 89 0C 95 ?? ?? ?? ?? 81 FA ?? ?? ?? ?? 7C C0 81 FA ?? ?? ?? ?? 7D 3B 56 8D 34 95 ?? ?? ?? ?? 8B 0E 33 4E ?? 83 C6 ?? 
            81 E1 ?? ?? ?? ?? 33 4E ?? 8B C1 83 E0 ?? D1 E9 8B 04 85 ?? ?? ?? ?? 33 86 ?? ?? ?? ?? 33 C1 89 46 ?? 81 FE ?? ?? ?? ?? 
            7C CE 5E 8B 0D ?? ?? ?? ?? 33 0D ?? ?? ?? ?? 81 E1 ?? ?? ?? ?? 33 0D ?? ?? ?? ?? 8B C1 83 E0 ?? D1 E9 33 0C 85 ?? ?? ?? 
            ?? 33 0D ?? ?? ?? ?? 33 C0 89 0D ?? ?? ?? ?? 8B 0C 85 ?? ?? ?? ?? 40 A3 ?? ?? ?? ?? 8B C1 C1 E8 ?? 33 C8 8B C1 25 ?? ?? 
            ?? ?? C1 E0 ?? 33 C8 8B C1 25 ?? ?? ?? ?? C1 E0 ?? 33 C8 8B C1 C1 E8 ?? 33 C1 C3
        }

        $decrypt_3 = {
            A1 ?? ?? ?? ?? 3D ?? ?? ?? ?? 0F 8C C7 00 00 00 33 D2 EB 0C 8D A4 24 ?? ?? ?? ?? EB 03 8D 49 ?? 8B 0C 95 ?? ?? ?? ?? 33 
            0C 95 ?? ?? ?? ?? 42 81 E1 ?? ?? ?? ?? 33 0C 95 ?? ?? ?? ?? 8B C1 83 E0 ?? D1 E9 33 0C 85 ?? ?? ?? ?? 33 0C 95 ?? ?? ?? 
            ?? 89 0C 95 ?? ?? ?? ?? 81 FA ?? ?? ?? ?? 7C C0 81 FA ?? ?? ?? ?? 7D 3B 56 8D 34 95 ?? ?? ?? ?? 8B 0E 33 4E ?? 83 C6 ?? 
            81 E1 ?? ?? ?? ?? 33 4E ?? 8B C1 83 E0 ?? D1 E9 8B 04 85 ?? ?? ?? ?? 33 86 ?? ?? ?? ?? 33 C1 89 46 ?? 81 FE ?? ?? ?? ?? 
            7C CE 5E 8B 0D ?? ?? ?? ?? 33 0D ?? ?? ?? ?? 81 E1 ?? ?? ?? ?? 33 0D ?? ?? ?? ?? 8B C1 83 E0 ?? D1 E9 33 0C 85 ?? ?? ?? 
            ?? 33 0D ?? ?? ?? ?? 33 C0 89 0D ?? ?? ?? ?? 8B 0C 85 ?? ?? ?? ?? 40 A3 ?? ?? ?? ?? 8B C1 C1 E8 ?? 33 C8 8B C1 25 ?? ?? 
            ?? ?? C1 E0 ?? 33 C8 8B C1 25 ?? ?? ?? ?? C1 E0 ?? 33 C8 8B C1 C1 E8 ?? 33 C1 C3
        }

        $entrypoint_all = {
            83 EC ?? E8 ?? ?? ?? ?? 50 FF 15
        }

    condition:
        uint16(0) == 0x5A4D and ((($file_loop_1 and $encrypt_data_1 and $decrypt_data_1 and $decrypt_strings_1 and $decrypt_1) or
        ($file_loop_2 and $encrypt_data_2 and $decrypt_data_2 and $decrypt_strings_2 and $decrypt_2) or
        ($file_loop_3 and $encrypt_data_3 and $decrypt_data_3 and $decrypt_3)) and
        ($entrypoint_all at pe.entry_point))
}