rule Win32_Ransomware_Cuba : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "CUBA"
        description         = "Yara rule that detects Cuba ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Cuba"
        tc_detection_factor = 5

    strings:

        $find_files_p1 = {
            51 50 8D 4D ?? E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? C6 45 ?? ?? 50 8B D7 8D 4D ?? E8 ?? 
            ?? ?? ?? 83 C4 ?? C6 45 ?? ?? F6 85 ?? ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? 8D 4D ?? E8 ?? 
            ?? ?? ?? 84 C0 0F 85 ?? ?? ?? ?? 83 7D ?? ?? 72 ?? 83 7D ?? ?? 8D 45 ?? 0F 43 45 ?? 
            0F B7 00 50 E8 ?? ?? ?? ?? 83 C4 ?? 83 F8 ?? 75 ?? 83 7D ?? ?? 8D 45 ?? 0F 43 45 ?? 
            0F B7 40 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 83 F8 ?? 75 ?? 83 7D ?? ?? 8D 45 ?? 0F 43 45 
            ?? 0F B7 40 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 83 F8 ?? 75 ?? 83 7D ?? ?? 8D 45 ?? 0F 43 
            45 ?? 0F B7 40 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 83 F8 ?? 75 ?? B0 ?? EB ?? 32 C0 84 C0 
            0F 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 ?? 8D 4D ?? E8 ?? ?? ?? ?? 83 C4 ?? 8B D3 C6 
            45 ?? ?? 8B C8 E8 ?? ?? ?? ?? C6 45 ?? ?? 8B 55 ?? 83 FA ?? 0F 82 ?? ?? ?? ?? 8B 4D 
            ?? 8D 14 55 ?? ?? ?? ?? 8B C1 81 FA ?? ?? ?? ?? 72 ?? 8B 49 ?? 83 C2 ?? 2B C1 83 C0 
            ?? 83 F8 ?? 0F 87 ?? ?? ?? ?? 52 51 E8 ?? ?? ?? ?? 83 C4 ?? E9 ?? ?? ?? ?? 8D 55 ?? 
            8D 4D ?? E8 ?? ?? ?? ?? C6 45 ?? ?? 8D 75 ?? 8B 5D ?? 83 FB ?? 8B 7D ?? 8B 45 ?? 0F 
            43 F7 83 F8 ?? 75 ?? B9 ?? ?? ?? ?? 8B D0 2B F1 66 8B 04 0E 66 3B 01 75 ?? 83 C1 ?? 
            83 EA ?? 75 ?? E9 ?? ?? ?? ?? 8B 45 ?? 83 FB ?? 8D 75 ?? 0F 43 F7 83 F8 ?? 75 ?? B9 
            ?? ?? ?? ?? 8B D0 2B F1 66 8B 04 0E 66 3B 01 75 ?? 83 C1 ?? 83 EA ?? 75 ?? E9 ?? ?? 
            ?? ?? 8B 45 ?? 83 FB ?? 8D 75 ?? 0F 43 F7 83 F8 ?? 75 ?? B9 ?? ?? ?? ?? 8B D0 2B F1
        }

        $find_files_p2 = {
            66 8B 04 0E 66 3B 01 75 ?? 83 C1 ?? 83 EA ?? 75 ?? E9 ?? ?? ?? ?? 8B 45 ?? 83 FB ?? 
            8D 75 ?? 0F 43 F7 83 F8 ?? 75 ?? B9 ?? ?? ?? ?? 8B D0 2B F1 66 8B 04 0E 66 3B 01 75 
            ?? 83 C1 ?? 83 EA ?? 75 ?? E9 ?? ?? ?? ?? 8B 45 ?? 83 FB ?? 8D 75 ?? 0F 43 F7 83 F8 
            ?? 75 ?? B9 ?? ?? ?? ?? 8B D0 2B F1 66 8B 04 0E 66 3B 01 75 ?? 83 C1 ?? 83 EA ?? 75 
            ?? EB ?? 83 7D ?? ?? 75 ?? 8B 55 ?? 8D 45 ?? 8B 4D ?? 83 FA ?? 0F 43 C1 66 83 38 ?? 
            75 ?? 83 FA ?? 8D 45 ?? 0F 43 C1 66 83 78 ?? ?? 75 ?? 83 FA ?? 8D 45 ?? 0F 43 C1 66 
            83 78 ?? ?? 75 ?? 83 FA ?? 8D 45 ?? 0F 43 C1 66 83 78 ?? ?? 74 ?? 8B 8D ?? ?? ?? ?? 
            8D 45 ?? 50 E8 ?? ?? ?? ?? 8B 5D ?? 8B 7D ?? C6 45 ?? ?? 83 FB ?? 72 ?? 8D 0C 5D ?? 
            ?? ?? ?? 8B C7 81 F9 ?? ?? ?? ?? 72 ?? 8B 7F ?? 83 C1 ?? 2B C7 83 C0 ?? 83 F8 ?? 0F 
            87 ?? ?? ?? ?? 51 57 E8 ?? ?? ?? ?? 83 C4 ?? 8B BD ?? ?? ?? ?? 8B B5 ?? ?? ?? ?? 8B 
            9D ?? ?? ?? ?? C6 45 ?? ?? 8B 55 ?? 83 FA ?? 72 ?? 8B 4D ?? 8D 14 55 ?? ?? ?? ?? 8B 
            C1 81 FA ?? ?? ?? ?? 72 ?? 8B 49 ?? 83 C2 ?? 2B C1 83 C0 ?? 83 F8 ?? 0F 87 ?? ?? ?? 
            ?? 52 51 E8 ?? ?? ?? ?? 83 C4 ?? 33 C0 C7 45 ?? ?? ?? ?? ?? 88 45 ?? 8B 55 ?? C7 45 
            ?? ?? ?? ?? ?? 66 89 45 ?? 83 FA ?? 72 ?? 8B 4D ?? 8D 14 55 ?? ?? ?? ?? 8B C1 81 FA 
            ?? ?? ?? ?? 72 ?? 8B 49 ?? 83 C2 ?? 2B C1 83 C0 ?? 83 F8 ?? 77 ?? 52 51 E8 ?? ?? ?? 
            ?? 83 C4 ?? 8D 85 ?? ?? ?? ?? 50 56 FF 15
        }

        $enum_resources = {
            55 8B EC 6A ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 83 EC ?? A1 ?? ?? ?? ?? 33 C5 89 
            45 ?? 53 56 57 50 8D 45 ?? 64 A3 ?? ?? ?? ?? 8B DA 89 5D ?? 8D 45 ?? C7 45 ?? ?? ?? 
            ?? ?? 50 51 6A ?? 6A ?? 6A ?? C7 45 ?? ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 74 ?? 32 
            C0 E9 ?? ?? ?? ?? FF 75 ?? 6A ?? FF 15 ?? ?? ?? ?? 8B F0 89 75 ?? 85 F6 74 ?? 66 90 
            FF 75 ?? 6A ?? 56 E8 ?? ?? ?? ?? 83 C4 ?? 8D 45 ?? 50 56 8D 45 ?? 50 FF 75 ?? FF 15 
            ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 33 FF 39 7D ?? 76 ?? 83 C6 ?? 83 7E ?? ?? 0F 85 
            ?? ?? ?? ?? 83 3E ?? 0F 85 ?? ?? ?? ?? 8B 56 ?? 33 C0 66 89 45 ?? 8B C2 C7 45 ?? ?? 
            ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 8D 58 ?? 66 8B 08 83 C0 ?? 66 85 C9 75 ?? 2B C3 8D 4D 
            ?? D1 F8 50 52 E8 ?? ?? ?? ?? 8B 5D ?? 8D 45 ?? 50 8B CB C7 45 ?? ?? ?? ?? ?? E8 ?? 
            ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 8B 55 ?? 83 FA ?? 72 ?? 8B 4D ?? 8D 14 55 ?? ?? ?? ?? 
            8B C1 81 FA ?? ?? ?? ?? 72 ?? 8B 49 ?? 83 C2 ?? 2B C1 83 C0 ?? 83 F8 ?? 77 ?? 52 51 
            E8 ?? ?? ?? ?? 83 C4 ?? F7 46 ?? ?? ?? ?? ?? 74 ?? 8D 4E ?? 8B D3 E8 ?? ?? ?? ?? 47 
            83 C6 ?? 3B 7D ?? 0F 82 ?? ?? ?? ?? 8B 75 ?? E9 ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? FF 
            75 ?? FF 15 ?? ?? ?? ?? 85 C0 0F 94 C0 8B 4D ?? 64 89 0D ?? ?? ?? ?? 59 5F 5E 5B 8B 
            4D ?? 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 
        }

        $encrypt_files_p1 = {
            55 8B EC 6A ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 83 EC ?? A1 ?? ?? ?? ?? 33 C5 89 
            45 ?? 53 56 57 50 8D 45 ?? 64 A3 ?? ?? ?? ?? 8B F1 8B 7D ?? 0F 57 C0 66 0F 13 45 ?? 
            C7 45 ?? ?? ?? ?? ?? 8B C7 83 7F ?? ?? 72 ?? 8B 07 6A ?? 68 ?? ?? ?? ?? 6A ?? 6A ?? 
            6A ?? 68 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 8B D8 89 5D ?? 83 FB ?? 75 ?? FF 15 ?? ?? 
            ?? ?? 32 DB E9 ?? ?? ?? ?? 8D 8E ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 
            ?? 8D 8E ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A ?? 8D 8E ?? ?? ?? ?? 6A ?? 8D 
            41 ?? 50 6A ?? 8D 56 ?? 51 52 89 55 ?? E8 ?? ?? ?? ?? 83 C4 ?? 8D 45 ?? 50 53 FF 15 
            ?? ?? ?? ?? 8B 4D ?? 8B 45 ?? 85 C9 7F ?? 7C ?? 3D ?? ?? ?? ?? 77 ?? 8D 45 ?? 8B CE 
            50 E8 ?? ?? ?? ?? EB ?? 85 C9 7F ?? 7C ?? 3D ?? ?? ?? ?? 77 ?? 6A ?? EB ?? 6A ?? 8D 
            45 ?? 8B CE 50 E8 ?? ?? ?? ?? 8B 75 ?? 8A D8 83 FE ?? 74 ?? 56 FF 15 ?? ?? ?? ?? 83 
            CE ?? 89 75 ?? FF 75 ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B D7 8D 4D ?? E8 ?? ?? ?? ?? 
            83 C4 ?? 8D 45 ?? 83 7D ?? ?? 0F 43 45 ?? 83 7F ?? ?? 72 ?? 8B 3F 50 57 FF 15 ?? ?? 
            ?? ?? 8B 55 ?? 83 FA ?? 72 ?? 8B 4D ?? 8D 14 55 ?? ?? ?? ?? 8B C1 81 FA ?? ?? ?? ?? 
            72 ?? 8B 49 ?? 83 C2 ?? 2B C1 83 C0 ?? 83 F8 ?? 77 ?? 52 51 E8 ?? ?? ?? ?? 83 C4 ?? 
            33 C0 C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 66 89 45 ?? 83 FE ?? 74 ?? 56 FF 15 
            ?? ?? ?? ?? 8A C3 8B 4D ?? 64 89 0D ?? ?? ?? ?? 59 5F 5E 5B 8B 4D ?? 33 CD E8 ?? ?? 
            ?? ?? 8B E5 5D C2 ?? ?? E8 ?? ?? ?? ?? CC CC CC 55 8B EC 83 E4 ?? 81 EC
        }

        $encrypt_files_p2 = {
            A1 ?? ?? ?? ?? 33 C4 89 84 24 ?? ?? ?? ?? 53 8B 5D ?? 56 57 8B F9 89 5C 24 ?? 6A ?? 
            8D 4C 24 ?? C7 44 24 ?? ?? ?? ?? ?? 51 8B 17 8B 47 ?? 2B C2 50 52 FF 33 FF 15 ?? ?? 
            ?? ?? 85 C0 75 ?? FF 15 ?? ?? ?? ?? 89 43 ?? 32 C0 5F 5E 5B 8B 8C 24 ?? ?? ?? ?? 33 
            CC E8 ?? ?? ?? ?? 8B E5 5D C2 ?? ?? 8B 44 24 ?? 8B 57 ?? 8B 0F 89 44 24 ?? 89 54 24 
            ?? 89 4C 24 ?? 85 C0 7E ?? 8B D8 8B 47 ?? 8B F3 2B 47 ?? 3B D8 52 0F 43 F0 8D 47 ?? 
            56 51 50 E8 ?? ?? ?? ?? 56 FF 74 24 ?? FF 74 24 ?? E8 ?? ?? ?? ?? 8B 4C 24 ?? 2B DE 
            8B 54 24 ?? 03 CE 83 C4 ?? 89 4C 24 ?? 85 DB 7F ?? 8B 5C 24 ?? 6A ?? 6A ?? 0F 57 C0 
            66 0F 13 44 24 ?? FF 74 24 ?? FF 74 24 ?? FF 33 FF 15 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 
            85 C0 75 ?? FF D6 89 43 ?? 68 ?? ?? ?? ?? 8D 44 24 ?? 6A ?? 50 E8 ?? ?? ?? ?? A1 ?? 
            ?? ?? ?? 8D 4C 24 ?? 89 44 24 ?? 83 C4 ?? A1 ?? ?? ?? ?? 89 44 24 ?? A1 ?? ?? ?? ?? 
            89 44 24 ?? 8D 87 ?? ?? ?? ?? 50 C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? E8 
            ?? ?? ?? ?? 83 4C 24 ?? ?? 8D 44 24 ?? 6A ?? 50 68 ?? ?? ?? ?? 8D 44 24 ?? C7 44 24 
            ?? ?? ?? ?? ?? 50 FF 33 FF 15 ?? ?? ?? ?? 85 C0 75 ?? FF D6 89 43 ?? 6A ?? 8D 44 24 
            ?? C7 44 24 ?? ?? ?? ?? ?? 50 FF 74 24 ?? FF 37 FF 33 FF 15 ?? ?? ?? ?? 85 C0 75 ?? 
            FF D6 89 43 ?? 32 C0 5F 5E 5B 8B 8C 24 ?? ?? ?? ?? 33 CC E8 ?? ?? ?? ?? 8B E5 5D C2 
            ?? ?? 8B 8C 24 ?? ?? ?? ?? B0 ?? 5F 5E 5B 33 CC E8 ?? ?? ?? ?? 8B E5 5D C2
        }
        
    condition:
        uint16(0) == 0x5A4D and
        (
            $enum_resources
        ) and
        (
            all of ($find_files_p*)
        ) and
        (
            all of ($encrypt_files_p*)
        )
}