rule Win32_Ransomware_Defray : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "DEFRAY"
        description         = "Yara rule that detects Defray ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Defray"
        tc_detection_factor = 5

    strings:

        $find_files = {
            55 8B EC 81 EC ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C5 89 45 ?? 53 56 57 68 ?? ?? ?? ?? 33 
            F6 89 95 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 8B D9 56 50 89 9D ?? ?? ?? ?? E8 ?? ?? ?? ?? 
            83 C4 ?? 8D 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 50 E8 ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? 83 
            C4 ?? 2B D3 8B CB 89 95 ?? ?? ?? ?? 0F B7 01 66 89 04 0A 8D 49 ?? 66 85 C0 75 ?? 8D 
            BD ?? ?? ?? ?? 83 EF ?? 66 8B 47 ?? 83 C7 ?? 66 3B C6 75 ?? BE ?? ?? ?? ?? 68 ?? ?? 
            ?? ?? 53 A5 A5 66 A5 FF 15 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 FF 
            15 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 83 F8 ?? 0F 84 ?? ?? ?? ?? 33 F6 8B 1D ?? ?? ?? ?? 
            83 FB ?? 0F 84 ?? ?? ?? ?? B9 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 66 8B 10 66 3B 11 75 ?? 
            66 85 D2 74 ?? 66 8B 50 ?? 66 3B 51 ?? 75 ?? 83 C0 ?? 83 C1 ?? 66 85 D2 75 ?? 8B C6 
            EB ?? 1B C0 83 C8 ?? 85 C0 0F 84 ?? ?? ?? ?? B9 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 66 8B 
            10 66 3B 11 75 ?? 66 85 D2 74 ?? 66 8B 50 ?? 66 3B 51 ?? 75 ?? 83 C0 ?? 83 C1 ?? 66 
            85 D2 75 ?? 8B C6 EB ?? 1B C0 83 C8 ?? 85 C0 0F 84 ?? ?? ?? ?? 8B 8D ?? ?? ?? ?? 8B 
            95 ?? ?? ?? ?? 0F B7 01 66 89 04 0A 8D 49 ?? 66 85 C0 75 ?? 8D BD ?? ?? ?? ?? 83 EF 
            ?? 33 C9 66 8B 47 ?? 8D 7F ?? 66 3B C1 75 ?? A1 ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? 89 07 
            8B F2 66 8B 02 83 C2 ?? 66 3B C1 75 ?? 8D BD ?? ?? ?? ?? 2B D6 83 EF ?? 66 8B 47 ?? 
            83 C7 ?? 66 3B C1 75 ?? 8B CA C1 E9 ?? F3 A5 8B CA 83 E1 ?? F6 85 ?? ?? ?? ?? ?? F3 
            A4 74 ?? 8B 95 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? EB ?? F7 85 ?? ?? ?? ?? 
            ?? ?? ?? ?? 75 ?? 8B 8D ?? ?? ?? ?? 66 8B 85 ?? ?? ?? ?? 66 89 04 59 43 89 1D ?? ?? 
            ?? ?? 33 F6 8B 9D ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 53 FF 15 ?? ?? ?? ?? 85 C0 0F 85 
            ?? ?? ?? ?? 53 FF 15 ?? ?? ?? ?? 8B 4D ?? 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 
        }

        $find_special_folders = {
            55 8B EC 81 EC ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C5 89 45 ?? 53 56 57 BE ?? ?? ?? ?? 8D 
            85 ?? ?? ?? ?? 56 33 DB 53 50 E8 ?? ?? ?? ?? 83 C4 ?? 8D 85 ?? ?? ?? ?? 56 53 50 E8 
            ?? ?? ?? ?? 83 C4 ?? 8D 85 ?? ?? ?? ?? 56 53 50 E8 ?? ?? ?? ?? 83 C4 ?? 8D 85 ?? ?? 
            ?? ?? BE ?? ?? ?? ?? 8D BD ?? ?? ?? ?? 6A ?? 59 68 ?? ?? ?? ?? 53 F3 A5 50 E8 ?? ?? 
            ?? ?? 83 C4 ?? 8D BD ?? ?? ?? ?? BE ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 6A ?? 59 F3 A5 68 
            ?? ?? ?? ?? 53 50 66 A5 E8 ?? ?? ?? ?? 83 C4 ?? 8D 85 ?? ?? ?? ?? BE ?? ?? ?? ?? 8D 
            BD ?? ?? ?? ?? 6A ?? 59 68 ?? ?? ?? ?? 53 F3 A5 50 E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 
            8D 85 ?? ?? ?? ?? 83 C4 ?? 53 6A ?? 50 53 FF D6 53 6A ?? 8D 85 ?? ?? ?? ?? 50 53 FF 
            D6 53 6A ?? 8D 85 ?? ?? ?? ?? 50 53 FF D6 8D BD ?? ?? ?? ?? 83 EF ?? 66 8B 47 ?? 83 
            C7 ?? 66 3B C3 75 ?? 6A ?? 59 BE ?? ?? ?? ?? F3 A5 8D BD ?? ?? ?? ?? 83 EF ?? 66 8B 
            47 ?? 83 C7 ?? 66 3B C3 75 ?? 6A ?? 59 BE ?? ?? ?? ?? F3 A5 8D BD ?? ?? ?? ?? 83 EF 
            ?? 66 8B 47 ?? 83 C7 ?? 66 3B C3 75 ?? BE ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? A5 A5 A5 A5 
            66 A5 E8 ?? ?? ?? ?? 84 C0 74 ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 ?? 8D 8D 
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D ?? 
            ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 ?? 8D 
            8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D 
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 ?? 
            8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 
            4D ?? 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 
        }

        $remote_connection = {
            55 8B EC 81 EC ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C5 89 45 ?? 8B 45 ?? 53 56 57 89 85 ?? 
            ?? ?? ?? 33 DB 8B 45 ?? 8B FA 68 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 53 
            50 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 C4 ?? 89 45 ?? A0 ?? ?? ?? ?? 88 45 ?? 8D 85 ?? 
            ?? ?? ?? 53 53 53 53 50 FF 15 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 8B D8 89 9D ?? ?? ?? ?? 
            85 DB 74 ?? 33 C0 50 50 6A ?? 50 50 68 ?? ?? ?? ?? 57 53 FF 15 ?? ?? ?? ?? 8B F8 85 
            FF 74 ?? 33 C0 50 68 ?? ?? ?? ?? 50 50 68 ?? ?? ?? ?? FF B5 ?? ?? ?? ?? 8D 45 ?? 50 
            57 FF 15 ?? ?? ?? ?? 8B D8 85 DB 74 ?? 8B 95 ?? ?? ?? ?? 33 C9 85 D2 74 ?? 8B CA 8D 
            41 ?? 89 85 ?? ?? ?? ?? 8A 01 41 84 C0 75 ?? 2B 8D ?? ?? ?? ?? 51 52 6A ?? 6A ?? 53 
            FF 15 ?? ?? ?? ?? 53 FF D6 8B 9D ?? ?? ?? ?? 57 FF D6 53 FF D6 8B 4D ?? 5F 5E 33 CD 
            5B E8 ?? ?? ?? ?? 8B E5 5D C3 
        }

        $encrypt_files_1 = {
            55 8B EC 51 51 83 4D ?? ?? 83 4D ?? ?? 57 6A ?? 68 ?? ?? ?? ?? 6A ?? 6A ?? 6A ?? 68 
            ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 8B F8 83 FF ?? 75 ?? 6A ?? 58 EB ?? 56 8D 45 ?? 50 
            57 FF 15 ?? ?? ?? ?? 89 45 ?? 85 C0 75 ?? 6A ?? EB ?? 8B 75 ?? 3B C6 0F 42 F0 83 7D 
            ?? ?? 74 ?? 6A ?? 8D 45 ?? 50 56 FF 75 ?? 57 FF 15 ?? ?? ?? ?? 85 C0 75 ?? 6A ?? 5E 
            57 FF 15 ?? ?? ?? ?? EB ?? 57 FF 15 ?? ?? ?? ?? 3B 75 ?? 6A ?? 58 0F 45 F0 8B C6 EB 
            ?? 57 FF 15 ?? ?? ?? ?? B8 ?? ?? ?? ?? 5E 5F 8B E5 5D C2
        }

        $encrypt_files_2_p1 = {
            68 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 8D ?? ?? ?? ?? 33 C0 89 85 ?? ?? ?? 
            ?? 89 85 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 89 45 ?? 89 85 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 
            89 85 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 89 85 ?? ?? 
            ?? ?? 89 85 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? C6 45 ?? ?? 50 89 85 ?? ?? 
            ?? ?? 89 85 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 6A ?? 59 33 C0 8D 7D ?? 
            F3 AB 83 C4 ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 85 C0 74 ?? FF 15 ?? ?? ?? ?? 50 
            68 ?? ?? ?? ?? 83 CE ?? EB ?? 6A ?? 8D 55 ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 85 
            C0 74 ?? FF 15 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 6A ?? 5E 6A ?? 8B D6 59 E8 ?? ?? ?? ?? 
            59 59 E9 ?? ?? ?? ?? 8B B5 ?? ?? ?? ?? 85 F6 75 ?? 6A ?? 5E E9 ?? ?? ?? ?? 80 BD ?? 
            ?? ?? ?? ?? B8 ?? ?? ?? ?? 75 ?? B8 ?? ?? ?? ?? 3B F0 0F 47 F0 8D 85 ?? ?? ?? ?? 50 
            56 8B C8 89 B5 ?? ?? ?? ?? E8 ?? ?? ?? ?? 56 FF B5 ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? 
            ?? 8B F8 85 FF 79 ?? FF 15 ?? ?? ?? ?? 50 8D 45 ?? 50 6A ?? 5A 6A ?? 59 E8 ?? ?? ?? 
            ?? 59 59 BE ?? ?? ?? ?? E9 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 ?? 
            FF 15 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 6A ?? 5A 6A ?? 59 E8 ?? ?? ?? ?? 59 59 6A ?? E9 
            ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 8D 55 ?? 8D 8D 
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C7 8B DF 25 ?? ?? ?? ?? 79 ?? 48 83 C8 ?? 40 74 ?? 8B
        }

        $encrypt_files_2_p2 = {
            B5 ?? ?? ?? ?? 43 46 8B C3 25 ?? ?? ?? ?? 79 ?? 48 83 C8 ?? 40 75 ?? 89 B5 ?? ?? ?? 
            ?? 8D 85 ?? ?? ?? ?? 50 53 8B C8 E8 ?? ?? ?? ?? 33 D2 85 FF 7E ?? 8B 85 ?? ?? ?? ?? 
            8A 0C 10 8B 85 ?? ?? ?? ?? 88 0C 10 42 3B D7 7C ?? 3B FB 7D ?? 8B C3 2B C7 50 8B 85 
            ?? ?? ?? ?? FF B5 ?? ?? ?? ?? 03 C7 50 E8 ?? ?? ?? ?? 83 C4 ?? 8D 85 ?? ?? ?? ?? 50 
            53 8B C8 E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 
            95 ?? ?? ?? ?? 8D 45 ?? 51 50 51 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 74 
            ?? 6A ?? E9 ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 53 FF B5 ?? ?? ?? ?? E8 
            ?? ?? ?? ?? 59 59 85 C0 75 ?? 6A ?? 33 FF 5A 8B 85 ?? ?? ?? ?? 8A 4C 3D ?? 88 0C 38 
            47 3B FA 7C ?? 8D 75 ?? 6A ?? 2B F2 5F 8B 85 ?? ?? ?? ?? 8A 0C 32 88 0C 10 42 3B D7 
            7C ?? 51 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 8D 95 ?? ?? ?? ?? E8 
            ?? ?? ?? ?? 59 59 85 C0 74 ?? 6A ?? E9 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 83 EC ?? 8D 
            85 ?? ?? ?? ?? 50 51 8B 8D ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4
        }

        $encrypt_files_2_p3 = {
            85 C0 79 ?? 6A ?? E9 ?? ?? ?? ?? 8D B5 ?? ?? ?? ?? BA ?? ?? ?? ?? 2B F7 8B 85 ?? ?? 
            ?? ?? 8A 0C 37 88 0C 38 47 3B FA 7C ?? 8B B5 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8A 8C 02 ?? 
            ?? ?? ?? 8B 85 ?? ?? ?? ?? 88 0C 10 42 81 FA ?? ?? ?? ?? 7C ?? 83 BD ?? ?? ?? ?? ?? 
            74 ?? 8D 4D ?? E8 ?? ?? ?? ?? 84 C0 75 ?? BE ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? 
            ?? ?? E8 ?? ?? ?? ?? 8B C6 E9 ?? ?? ?? ?? 51 6A ?? 53 FF B5 ?? ?? ?? ?? 8D 4D ?? E8 
            ?? ?? ?? ?? 8B F8 85 FF 79 ?? FF 15 ?? ?? ?? ?? 50 8D 45 ?? 50 6A ?? 5A 6A ?? 59 E8 
            ?? ?? ?? ?? 59 59 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 
            8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 87 ?? ?? ?? ?? 
            E9 ?? ?? ?? ?? 51 6A ?? 68 ?? ?? ?? ?? FF B5 ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 8B 
            F8 85 FF 79 ?? FF 15 ?? ?? ?? ?? 50 8D 45 ?? 50 6A ?? 5A 6A ?? 59 E8 ?? ?? ?? ?? 59 
            59 EB ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D ?? 
            ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 01 34 85 
            ?? ?? ?? ?? FF 04 85 ?? ?? ?? ?? 33 FF 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? 
            ?? ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? 
            ?? 8B C7 E8 ?? ?? ?? ?? C3 
        }

    condition:
        uint16(0) == 0x5A4D and 
        (
            $find_files
        ) and 
        (
            $find_special_folders
        ) and 
        (
            $encrypt_files_1 
        ) and 
        (
            all of ($encrypt_files_2_p*)
        ) and 
        (
            $remote_connection
        )
}