rule Win32_Ransomware_Dragon : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "DRAGON"
        description         = "Yara rule that detects Dragon ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Dragon"
        tc_detection_factor = 5

    strings:

        $remote_connection_p1 = {
            55 8B EC 6A ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 81 EC ?? ?? ?? ?? A1 ?? ?? ?? ?? 
            33 C5 89 45 ?? 56 50 8D 45 ?? 64 A3 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 6A 
            ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8D 85 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 
            85 C0 0F 85 ?? ?? ?? ?? 89 45 ?? C7 45 ?? ?? ?? ?? ?? 88 45 ?? 83 EC ?? 89 45 ?? 8B 
            CC 89 A5 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 EC ?? C6 45 ?? ?? 8B CC E8 ?? 
            ?? ?? ?? 8D 8D ?? ?? ?? ?? C6 45 ?? ?? E8 ?? ?? ?? ?? 8B D0 C6 45 ?? ?? 8D 8D ?? ?? 
            ?? ?? E8 ?? ?? ?? ?? 8B F0 68 ?? ?? ?? ?? BA ?? ?? ?? ?? C6 45 ?? ?? 8D 8D ?? ?? ?? 
            ?? E8 ?? ?? ?? ?? 83 C4 ?? 56 8B D0 C6 45 ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 83 C4 ?? C6 
            45 ?? ?? 8B 95 ?? ?? ?? ?? 83 FA ?? 72 ?? 8B 8D ?? ?? ?? ?? 42 8B C1 81 FA ?? ?? ?? 
            ?? 72 ?? 8B 49 ?? 83 C2 ?? 2B C1 83 C0 ?? 83 F8 ?? 0F 87 ?? ?? ?? ?? 52 51 E8 ?? ?? 
            ?? ?? 83 C4 ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C6 85 ?? 
            ?? ?? ?? ?? C6 45 ?? ?? 8B 95 ?? ?? ?? ?? 83 FA ?? 72 ?? 8B 8D ?? ?? ?? ?? 42 8B C1
        }

        $remote_connection_p2 = {
            81 FA ?? ?? ?? ?? 72 ?? 8B 49 ?? 83 C2 ?? 2B C1 83 C0 ?? 83 F8 ?? 0F 87 ?? ?? ?? ?? 
            52 51 E8 ?? ?? ?? ?? 83 C4 ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? 
            ?? ?? C6 85 ?? ?? ?? ?? ?? C6 45 ?? ?? 8B 95 ?? ?? ?? ?? 83 FA ?? 72 ?? 8B 8D ?? ?? 
            ?? ?? 42 8B C1 81 FA ?? ?? ?? ?? 72 ?? 8B 49 ?? 83 C2 ?? 2B C1 83 C0 ?? 83 F8 ?? 0F 
            87 ?? ?? ?? ?? 52 51 E8 ?? ?? ?? ?? 83 C4 ?? 83 7D ?? ?? 8D 4D ?? 8D 55 ?? C7 85 ?? 
            ?? ?? ?? ?? ?? ?? ?? 0F 43 4D ?? 51 C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C6 85 ?? ?? ?? ?? 
            ?? E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 0F 85 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B 55 ?? 83 FA 
            ?? 72 ?? 8B 4D ?? 42 8B C1 81 FA ?? ?? ?? ?? 72 ?? 8B 49 ?? 83 C2 ?? 2B C1 83 C0 ?? 
            83 F8 ?? 77 ?? 52 51 E8 ?? ?? ?? ?? 83 C4 ?? 8B 55 ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? 
            ?? ?? ?? ?? C6 45 ?? ?? 83 FA ?? 72 ?? 8B 4D ?? 42 8B C1 81 FA ?? ?? ?? ?? 72 ?? 8B 
            49 ?? 83 C2 ?? 2B C1 83 C0 ?? 83 F8 ?? 77 ?? 52 51 E8 ?? ?? ?? ?? 83 C4 ?? 8B 4D ?? 
            64 89 0D ?? ?? ?? ?? 59 5E 8B 4D ?? 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 
        }

        $find_files_1 = {
            55 8B EC 81 EC ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C5 89 45 ?? 53 56 57 83 EC ?? 89 8D ?? 
            ?? ?? ?? 8B D4 8D 71 ?? C7 42 ?? ?? ?? ?? ?? C7 42 ?? ?? ?? ?? ?? C6 02 ?? 8A 01 41 
            84 C0 75 ?? 2B CE 8B B5 ?? ?? ?? ?? 51 56 8B CA E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 56 8D 
            85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8D 85 ?? ?? ?? ?? 50 8D 85 
            ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 8B F8 83 FF ?? 0F 84 ?? ?? ?? ?? 8B 1D 
        }

        $find_files_2 = {
            8A 10 3A 11 75 ?? 84 D2 74 ?? 8A 50 ?? 3A 51 ?? 75 ?? 83 C0 ?? 83 C1 ?? 84 D2 75 ?? 
            33 C0 EB ?? 1B C0 83 C8 ?? 85 C0 0F 84 ?? ?? ?? ?? B8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 
            8A 11 3A 10 75 ?? 84 D2 74 ?? 8A 51 ?? 3A 50 ?? 75 ?? 83 C1 ?? 83 C0 ?? 84 D2 75 ?? 
            33 C0 EB ?? 1B C0 83 C8 ?? 85 C0 0F 84 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 68 ?? ?? ?? 
            ?? 56 8D 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 51 8B D4 8D 8D ?? ?? ?? ?? 
            8D 71 ?? C7 42 ?? ?? ?? ?? ?? C7 42 ?? ?? ?? ?? ?? C6 02 ?? 8A 01 41 84 C0 75 ?? 2B 
            CE 8D 85 ?? ?? ?? ?? 51 50 8B CA E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 84 C0 74 ?? 
            83 EC ?? 8B CC 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 
            ?? F6 85 ?? ?? ?? ?? ?? 74 ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B B5 ?? ?? ?? ?? 8D 
            85 ?? ?? ?? ?? 50 57 FF D3 85 C0 0F 85 ?? ?? ?? ?? 57 FF 15 ?? ?? ?? ?? 8B 4D ?? 5F 
            5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 
        }

        $skip_hk_china_taiwan_p1 = {
            55 8B EC 6A ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 81 EC ?? ?? ?? ?? A1 ?? ?? ?? ?? 
            33 C5 89 45 ?? 50 8D 45 ?? 64 A3 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 6A ?? 
            50 E8 ?? ?? ?? ?? 83 C4 ?? 8D 85 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 
            C0 0F 85 ?? ?? ?? ?? 89 45 ?? C7 45 ?? ?? ?? ?? ?? 88 45 ?? 89 45 ?? 8D 4D ?? 6A ?? 
            68 ?? ?? ?? ?? 89 45 ?? C7 45 ?? ?? ?? ?? ?? 88 45 ?? E8 ?? ?? ?? ?? C6 45 ?? ?? 8D 
            4D ?? 83 7D ?? ?? 8D 55 ?? 0F 43 4D ?? 51 E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 0F 85 ?? ?? 
            ?? ?? FF 15 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 
            C7 45 ?? ?? ?? ?? ?? C6 85 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? C6 45 ?? ?? 8D 4D ?? 6A ?? 
            68 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C6 45 ?? ?? E8 ?? ?? ?? ?? 
            C6 45 ?? ?? 8D 4D ?? 6A ?? 68 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 
            C6 45 ?? ?? E8 ?? ?? ?? ?? 6A ?? 8D 85 ?? ?? ?? ?? 50 8D 4D ?? E8 ?? ?? ?? ?? 83 F8 
            ?? 0F 85 ?? ?? ?? ?? 6A ?? 8D 45 ?? 50 8D 4D ?? E8 ?? ?? ?? ?? 83 F8 ?? 0F 85 ?? ?? 
            ?? ?? 6A ?? 8D 45 ?? 50 8D 4D ?? E8 ?? ?? ?? ?? 83 F8 ?? 0F 85 ?? ?? ?? ?? 8B 55 ?? 
            83 FA ?? 72 ?? 8B 4D ?? 42 8B C1 81 FA ?? ?? ?? ?? 72 ?? 8B 49 ?? 83 C2 ?? 2B C1 83 
            C0 ?? 83 F8 ?? 0F 87 ?? ?? ?? ?? 52 51 E8 ?? ?? ?? ?? 83 C4 ?? 8B 55 ?? 83 FA ?? 72 
            ?? 8B 4D ?? 42 8B C1 81 FA ?? ?? ?? ?? 72 ?? 8B 49 ?? 83 C2 ?? 2B C1 83 C0 ?? 83 F8 
            ?? 0F 87 ?? ?? ?? ?? 52 51 E8 ?? ?? ?? ?? 83 C4 ?? 8B 55 ?? 83 FA ?? 72 ?? 8B 8D ?? 
            ?? ?? ?? 42 8B C1 81 FA ?? ?? ?? ?? 72 ?? 8B 49 ?? 83 C2 ?? 2B C1 83 C0 ?? 83 F8
        }

        $skip_hk_china_taiwan_p2 = {
            0F 87 ?? ?? ?? ?? 52 51 E8 ?? ?? ?? ?? 83 C4 ?? 8B 55 ?? 83 FA ?? 72 ?? 8B 4D ?? 42 
            8B C1 81 FA ?? ?? ?? ?? 72 ?? 8B 49 ?? 83 C2 ?? 2B C1 83 C0 ?? 83 F8 ?? 0F 87 ?? ?? 
            ?? ?? 52 51 E8 ?? ?? ?? ?? 83 C4 ?? 8B 55 ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? 
            ?? C6 45 ?? ?? 83 FA ?? 72 ?? 8B 4D ?? 42 8B C1 81 FA ?? ?? ?? ?? 72 ?? 8B 49 ?? 83 
            C2 ?? 2B C1 83 C0 ?? 83 F8 ?? 0F 87 ?? ?? ?? ?? 52 51 E8 ?? ?? ?? ?? 83 C4 ?? B0 ?? 
            8B 4D ?? 64 89 0D ?? ?? ?? ?? 59 8B 4D ?? 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 8B 55 ?? 
            83 FA ?? 72 ?? 8B 4D ?? 42 8B C1 81 FA ?? ?? ?? ?? 72 ?? 8B 49 ?? 83 C2 ?? 2B C1 83 
            C0 ?? 83 F8 ?? 0F 87 ?? ?? ?? ?? 52 51 E8 ?? ?? ?? ?? 83 C4 ?? 8B 55 ?? 83 FA ?? 72 
            ?? 8B 4D ?? 42 8B C1 81 FA ?? ?? ?? ?? 72 ?? 8B 49 ?? 83 C2 ?? 2B C1 83 C0 ?? 83 F8 
            ?? 0F 87 ?? ?? ?? ?? 52 51 E8 ?? ?? ?? ?? 83 C4 ?? 8B 55 ?? 83 FA ?? 72 ?? 8B 8D ?? 
            ?? ?? ?? 42 8B C1 81 FA ?? ?? ?? ?? 72 ?? 8B 49 ?? 83 C2 ?? 2B C1 83 C0 ?? 83 F8 ?? 
            0F 87 ?? ?? ?? ?? 52 51 E8 ?? ?? ?? ?? 83 C4 ?? 8B 55 ?? 83 FA ?? 72 ?? 8B 4D ?? 42 
            8B C1 81 FA ?? ?? ?? ?? 72 ?? 8B 49 ?? 83 C2 ?? 2B C1 83 C0 ?? 83 F8 ?? 77 ?? 52 51 
            E8 ?? ?? ?? ?? 83 C4 ?? 8B 55 ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C6 45 ?? 
            ?? 83 FA ?? 72 ?? 8B 4D ?? 42 8B C1 81 FA ?? ?? ?? ?? 72 ?? 8B 49 ?? 83 C2 ?? 2B C1 
            83 C0 ?? 83 F8 ?? 77 ?? 52 51 E8 ?? ?? ?? ?? 83 C4 ?? 32 C0 E9 ?? ?? ?? ?? 6A ?? E8 
            ?? ?? ?? ?? E8 
        }

        $crypt_files = {
            8B FF 55 8B EC 83 EC ?? A1 ?? ?? ?? ?? 33 C5 89 45 ?? 8B 4D ?? 8B 45 ?? 89 45 ?? 89 
            4D ?? 56 8B 75 ?? 85 C9 75 ?? 33 C0 E9 ?? ?? ?? ?? 85 C0 75 ?? E8 ?? ?? ?? ?? 83 20 
            ?? E8 ?? ?? ?? ?? C7 00 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C8 ?? E9 ?? ?? ?? ?? 53 8B C6 
            8B D6 C1 FA ?? 83 E0 ?? 57 6B F8 ?? 89 55 ?? 8B 14 95 ?? ?? ?? ?? 89 7D ?? 8A 5C 3A 
            ?? 80 FB ?? 74 ?? 80 FB ?? 75 ?? 8B C1 F7 D0 A8 ?? 75 ?? E8 ?? ?? ?? ?? 83 20 ?? E8 
            ?? ?? ?? ?? C7 00 ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? F6 44 3A ?? ?? 74 ?? 6A 
            ?? 6A ?? 6A ?? 56 E8 ?? ?? ?? ?? 83 C4 ?? 33 C0 8D 7D ?? AB 56 AB AB E8 ?? ?? ?? ?? 
            59 84 C0 74 ?? 84 DB 74 ?? FE CB 80 FB ?? 8B 5D ?? 0F 87 ?? ?? ?? ?? FF 75 ?? 8D 45 
            ?? 53 50 E8 ?? ?? ?? ?? 83 C4 ?? 8B F0 E9 ?? ?? ?? ?? FF 75 ?? 8B 5D ?? 8D 45 ?? 53 
            56 50 E8 ?? ?? ?? ?? 83 C4 ?? EB ?? 8B 4D ?? 8B 55 ?? 8B 04 8D ?? ?? ?? ?? 80 7C 10 
            ?? ?? 7D ?? 0F BE C3 8B 5D ?? 83 E8 ?? 74 ?? 83 E8 ?? 74 ?? 83 E8 ?? 75 ?? FF 75 ?? 
            8D 45 ?? 53 56 50 E8 ?? ?? ?? ?? EB ?? FF 75 ?? 8D 45 ?? 53 56 50 E8 ?? ?? ?? ?? EB 
            ?? FF 75 ?? 8D 45 ?? 53 56 50 E8 ?? ?? ?? ?? EB ?? 8B 4C 10 ?? 8D 7D ?? 8B 5D ?? 33 
            C0 AB 6A ?? AB AB 8D 45 ?? 50 FF 75 ?? 53 51 FF 15 ?? ?? ?? ?? 85 C0 75 ?? FF 15 ?? 
            ?? ?? ?? 89 45 ?? 8D 75 ?? 8D 7D ?? A5 A5 A5 8B 4D ?? 8B 55 ?? 8B 45 ?? 85 C0 75 ?? 
            8B 45 ?? 85 C0 74 ?? 6A ?? 5E 3B C6 75 ?? E8 ?? ?? ?? ?? C7 00 ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 89 30 EB ?? 50 E8 ?? ?? ?? ?? 59 EB ?? 8B 04 8D ?? ?? ?? ?? F6 44 10 ?? ?? 74 
            ?? 80 3B ?? 75 ?? 33 C0 EB ?? E8 ?? ?? ?? ?? C7 00 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 20 
            ?? 83 C8 ?? EB ?? 2B 45 ?? 5F 5B 8B 4D ?? 33 CD 5E E8 ?? ?? ?? ?? 8B E5 5D C3 
        }

    condition:
        uint16(0) == 0x5A4D and 
        (
            all of ($skip_hk_china_taiwan_p*)
        ) and 
        (
            all of ($find_files_*) 
        ) and 
        (
            $crypt_files
        ) and 
        (
            all of ($remote_connection_p*)
        )
}