rule Win32_Ransomware_Gibon : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "GIBON"
        description         = "Yara rule that detects Gibon ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Gibon"
        tc_detection_factor = 5

    strings:

        $remote_server_connection_1_0 = {
            53 8B DC 83 EC ?? 83 E4 ?? 83 C4 ?? 55 8B 6B ?? 89 6C 24 ?? 8B EC 6A ?? 68 ?? ?? ?? 
            ?? 64 A1 ?? ?? ?? ?? 50 53 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C5 89 45 
            ?? 56 57 50 8D 45 ?? 64 A3 ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? BA ?? ?? ?? ?? 
            C7 45 ?? ?? ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8D 85 
            ?? ?? ?? ?? 50 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? B9 ?? ?? ?? ?? 85 C0 74 ?? BA ?? ?? 
            ?? ?? E9 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 6A ?? 
            6A ?? 6A ?? FF 15 ?? ?? ?? ?? 8B F0 B9 ?? ?? ?? ?? 83 FE ?? 75 ?? BA ?? ?? ?? ?? E9 
            ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 68 ?? ?? ?? ?? 
            FF 15 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? B8 ?? ?? ?? ?? 6A ?? 66 89 85 ?? ?? ?? ?? FF 15 
            ?? ?? ?? ?? 66 89 85 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 6A ?? 50 56 FF 15 ?? ?? ?? ?? 8B 
            3D ?? ?? ?? ?? 85 C0 79 ?? FF D7 50 51 BA ?? ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 
            83 C4 ?? 8B C8 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? BA ?? ?? ?? ?? B9 ?? ?? ?? 
            ?? E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? C6 45 ?? ?? 8D 8D ?? ?? ?? ?? 8B 43 ?? 
            83 C0 ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 50 C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C6 85 ?? ?? 
            ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 8D 8D ?? 
            ?? ?? ?? E8 ?? ?? ?? ?? 83 7B ?? ?? 8D 43 ?? FF 73 ?? 0F 43 43 ?? 8D 8D ?? ?? ?? ?? 
            50 E8 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8
        }

        $remote_server_connection_1_1 = {
            E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? C6 45 ?? ?? E8 ?? 
            ?? ?? ?? 8B 53 ?? 8D 4B ?? 83 FA ?? 0F 43 4B ?? 8D 41 ?? 89 85 ?? ?? ?? ?? 90 8A 01 
            41 84 C0 75 ?? 2B 8D ?? ?? ?? ?? 8D 43 ?? 6A ?? 83 FA ?? 51 0F 43 43 ?? 50 56 FF 15 
            ?? ?? ?? ?? 85 C0 79 ?? FF D7 50 51 BA ?? ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 
            C4 ?? 8B C8 E8 ?? ?? ?? ?? EB ?? BA ?? ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 E8 
            ?? ?? ?? ?? 83 C4 ?? 8D 85 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 50 56 FF 15 ?? ?? ?? ?? 
            83 F8 ?? 0F 85 ?? ?? ?? ?? BA ?? ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 E8 ?? ?? 
            ?? ?? 83 C4 ?? BE ?? ?? ?? ?? 8B 43 ?? 83 F8 ?? 72 ?? 8B 4B ?? 40 3D ?? ?? ?? ?? 72 
            ?? F6 C1 ?? 0F 85 ?? ?? ?? ?? 8B 41 ?? 3B C1 0F 83 ?? ?? ?? ?? 2B C8 83 F9 ?? 0F 82 
            ?? ?? ?? ?? 83 F9 ?? 0F 87 ?? ?? ?? ?? 8B C8 51 E8 ?? ?? ?? ?? 83 C4 ?? 8B C6 8B 4D 
            ?? 64 89 0D ?? ?? ?? ?? 59 5F 5E 8B 4D ?? 33 CD E8 ?? ?? ?? ?? 8B E5 5D 8B E3 5B C3 
        }

        $encryption_loop_1_0 = {
            66 8B 01 66 3B 02 75 ?? 83 C1 ?? 83 C2 ?? 83 EE ?? 75 ?? C6 85 ?? ?? ?? ?? ?? E9 ?? 
            ?? ?? ?? 8B 85 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 6A ?? 8B 40 ?? 03 C8 8B 51 ?? 83 CA ?? 
            8B C2 83 C8 ?? 83 79 ?? ?? 0F 45 C2 50 E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 32 C0 0F 85 ?? 
            ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 C7 45 ?? ?? ?? 
            ?? ?? 8D 8D ?? ?? ?? ?? 83 CB ?? 68 ?? ?? ?? ?? 89 9D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 
            45 ?? ?? ?? ?? ?? 8B D7 8B 9D ?? ?? ?? ?? 83 CB ?? 83 7F ?? ?? 89 9D ?? ?? ?? ?? 89 
            9D ?? ?? ?? ?? 72 ?? 8B 17 83 78 ?? ?? 8B C8 72 ?? 8B 08 8B 70 ?? 3B 77 ?? 75 ?? 85 
            F6 0F 84 
        }

        $encryption_loop_1_1 = {
            66 8B 01 66 3B 02 75 ?? 83 C1 ?? 83 C2 ?? 83 EE ?? 75 ?? C6 85 ?? ?? ?? ?? ?? EB ?? 
            32 C0 74 ?? C6 85 ?? ?? ?? ?? ?? EB ?? C6 85 ?? ?? ?? ?? ?? F6 C3 ?? 74 ?? 83 E3 ?? 
            8D 8D ?? ?? ?? ?? 89 9D ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 C3 ?? 74 ?? 83 E3 ?? 8D 8D ?? 
            ?? ?? ?? 89 9D ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 C3 ?? 74 ?? 83 E3 ?? 8D 8D ?? ?? ?? ?? 
            89 9D ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 C3 ?? 74 ?? 83 E3 ?? 8D 8D ?? ?? ?? ?? 89 9D ?? 
            ?? ?? ?? E8 ?? ?? ?? ?? 32 C0 75 ?? 83 E3 ?? 8D 8D ?? ?? ?? ?? 89 9D ?? ?? ?? ?? E8 
            ?? ?? ?? ?? 32 C0 C7 45 ?? ?? ?? ?? ?? 75 ?? 83 E3 ?? 8D 8D ?? ?? ?? ?? 89 9D ?? ?? 
            ?? ?? E8 ?? ?? ?? ?? 80 BD ?? ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? 51 FF B5 ?? ?? ?? ?? BA 
            ?? ?? ?? ?? C6 45 ?? ?? 51 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 
            68 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 ?? 8D 85 ?? ?? ?? ?? 50 8D 
            8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 ?? 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 FF 15 
            ?? ?? ?? ?? FF B5 ?? ?? ?? ?? 8B BD ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 8B 95
        }

        $encryption_loop_1_2 = { 
            57 E8 ?? ?? ?? ?? 83 C4 ?? EB ?? BA ?? ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? 
            ?? ?? ?? C3 8B 85 ?? ?? ?? ?? 8B 9D ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 
            89 85 ?? ?? ?? ?? 8B BD ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 50 FF B5 
            ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? FF B5 ?? ?? ?? ?? FF 15 ?? ?? 
            ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 8B 4D ?? 64 89 0D ?? ?? ?? ?? 59 5F 5E 
            5B 8B 4D ?? 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 51 FF B5 ?? ?? ?? ?? BA ?? ?? ?? ?? 51 
            8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 ?? 68 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? 
            ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? 
            ?? 85 C0 0F 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 
            C0 0F 84 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 8D 85 
            ?? ?? ?? ?? 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 69 0F ?? ?? ?? ?? 83 C4 ?? 8B 85 ?? ?? 
            ?? ?? BA ?? ?? ?? ?? 03 48 ?? 8D 85 ?? ?? ?? ?? 50 51 E8 ?? ?? ?? ?? 85 C0 74 ?? BA 
            ?? ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? E9
        }

        $encryption_loop_1_3 = { 
            69 37 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 03 70 ?? E8 ?? ?? ?? ?? 8B 95 ?? 
            ?? ?? ?? 83 C4 ?? 89 85 ?? ?? ?? ?? 81 CB ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 8D 78 ?? 8D 
            4A ?? 89 08 8D 4A ?? 89 48 ?? 8D 4A ?? 89 48 ?? 8D 4A ?? 89 48 ?? 8D 4A ?? 89 48 ?? 
            B9 ?? ?? ?? ?? F3 A5 66 A5 C7 80 ?? ?? ?? ?? ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? C6 45 ?? 
            ?? E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? 
            ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? C6 45 ?? ?? 50 8D 8D ?? ?? ?? ?? E8 
            ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 85 C0 74 ?? 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 
            C6 45 ?? ?? 8B B5 ?? ?? ?? ?? 8B BD ?? ?? ?? ?? 56 C7 85 ?? ?? ?? ?? ?? ?? ?? ?? E8 
            ?? ?? ?? ?? 83 C4 ?? 85 C0 74 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 56 E8 ?? ?? ?? ?? 83 C4 
            ?? 57 E8 ?? ?? ?? ?? 83 C4 ?? 8D 8D ?? ?? ?? ?? C6 45 ?? ?? E8 ?? ?? ?? ?? 8B BD ?? 
            ?? ?? ?? 8B 8D ?? ?? ?? ?? FF 07 8B 07 89 41 ?? 69 17 ?? ?? ?? ?? 8B 41 ?? 80 A4 02 
            ?? ?? ?? ?? ?? 8B 01 48 39 07 75 ?? BA ?? ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 
            E8 ?? ?? ?? ?? 83 C4 ?? FF B5 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 83 BD ?? ?? ?? ?? ?? 0F 
            84 ?? ?? ?? ?? E8 ?? ?? ?? ?? C6 45 ?? ?? 83 BD ?? ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? E8 
            ?? ?? ?? ?? BA ?? ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 8D ?? ?? ?? ?? 8A 11 8B 
            C8 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? B8 ?? ?? ?? ?? C3 
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            $remote_server_connection_1_0 and
            $remote_server_connection_1_1 and
            (all of ($encryption_loop_1_*))
        )
}