rule Win32_Ransomware_HowAreYou : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "HOWAREYOU"
        description         = "Yara rule that detects HowAreYou ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "HowAreYou"
        tc_detection_factor = 5

    strings:

        $remote_connection_p1 = {
            64 8B 0D ?? ?? ?? ?? 8B 89 ?? ?? ?? ?? 3B 61 ?? 0F 86 ?? ?? ?? ?? 83 EC ?? 8B 05 ??
            ?? ?? ?? C7 40 ?? ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 85 C9 0F 85 ?? ?? ?? ?? 8D 0D ?? ??
            ?? ?? 89 08 8B 05 ?? ?? ?? ?? 8D 0D ?? ?? ?? ?? 89 0C 24 89 44 24 ?? E8 ?? ?? ?? ??
            8B 44 24 ?? 8B 4C 24 ?? 8B 54 24 ?? 8B 5C 24 ?? 8B 6C 24 ?? 85 C9 74 ?? 74 ?? 8B 49
            ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 89 4C 24 ?? 89 44 24 ?? 8D 44 24
            ?? 89 04 24 C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 E8 ??
            ?? ?? ?? 83 C4 ?? C3 89 54 24 ?? 89 5C 24 ?? 89 6C 24 ?? 8D 05 ?? ?? ?? ?? 89 04 24
            C7 44 24 ?? ?? ?? ?? ?? 8B 05 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 89 4C 24 ?? 89 44 24 ??
            E8 ?? ?? ?? ?? 8B 44 24 ?? 8B 4C 24 ?? 8B 54 24 ?? 8B 5C 24 ?? 85 D2 74 ?? 74 ?? 8B
            4A ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 89 4C 24 ?? 89 44 24 ?? 8D 05
            ?? ?? ?? ?? 89 04 24 C7 44 24 ?? ?? ?? ?? ?? 8D 44 24 ?? 89 44 24 ?? C7 44 24 ?? ??
            ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 E8 ?? ?? ?? ?? 83 C4 ?? C3 89 D1
        }

        $remote_connection_p2 = {
            EB ?? 89 4C 24 ?? 89 5C 24 ?? 84 03 89 4C 24 ?? C7 04 24 ?? ?? ?? ?? 8D 43 ?? 89 44
            24 ?? E8 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 8B 44 24 ?? 8B 48 ?? 8B 54 24 ?? 89 54
            24 ?? 8B 54 24 ?? 89 54 24 ?? 8B 54 24 ?? 89 54 24 ?? 8B 54 24 ?? 89 14 24 FF D1 8B
            44 24 ?? 8B 4C 24 ?? 85 C0 74 ?? 74 ?? 8B 40 ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ??
            ?? ?? ?? ?? 89 44 24 ?? 89 4C 24 ?? 8D 05 ?? ?? ?? ?? 89 04 24 C7 44 24 ?? ?? ?? ??
            ?? 8D 44 24 ?? 89 44 24 ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? E8 ?? ??
            ?? ?? 90 E8 ?? ?? ?? ?? 83 C4 ?? C3 8D 05 ?? ?? ?? ?? 89 04 24 C7 44 24 ?? ?? ?? ??
            ?? C7 44 24 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 44 24 ?? 8B 4C 24 ?? 8B 54 24 ?? 8B 5C
            24 ?? 8B 5B ?? 89 44 24 ?? 89 4C 24 ?? 89 54 24 ?? 8B 44 24 ?? 89 04 24 FF D3 90 E8
            ?? ?? ?? ?? 83 C4 ?? C3 90 E8 ?? ?? ?? ?? 83 C4 ?? C3 89 04 24 8D 05 ?? ?? ?? ?? 89
            44 24 ?? E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? E9
        }

        $find_files_p1 = {
            64 8B 0D ?? ?? ?? ?? 8B 89 ?? ?? ?? ?? 8D 44 24 ?? 3B 41 ?? 0F 86 ?? ?? ?? ?? 81 EC
            ?? ?? ?? ?? 8B 84 24 ?? ?? ?? ?? 89 04 24 8B 8C 24 ?? ?? ?? ?? 89 4C 24 ?? E8 ?? ??
            ?? ?? 8B 44 24 ?? 8B 4C 24 ?? 8B 54 24 ?? 8B 5C 24 ?? 85 C9 0F 85 ?? ?? ?? ?? 89 54
            24 ?? 89 9C 24 ?? ?? ?? ?? 31 C0 31 C9 31 ED 31 F6 EB ?? 8B 7C 24 ?? 47 8B 9C 24 ??
            ?? ?? ?? 89 CD 89 C6 89 F8 89 D1 8B 54 24 ?? 39 D0 0F 8D ?? ?? ?? ?? 89 44 24 ?? 89
            4C 24 ?? 89 AC 24 ?? ?? ?? ?? 89 74 24 ?? 8D 0C C3 8B 11 89 94 24 ?? ?? ?? ?? 8B 49
            ?? 89 8C 24 ?? ?? ?? ?? 8B 6A ?? 89 0C 24 FF D5 0F B6 44 24 ?? 84 C0 0F 84 ?? ?? ??
            ?? 8B 84 24 ?? ?? ?? ?? 8B 40 ?? 8B 8C 24 ?? ?? ?? ?? 89 0C 24 FF D0 8B 44 24 ?? 8B
            4C 24 ?? 89 0C 24 89 44 24 ?? E8 ?? ?? ?? ?? 8B 44 24 ?? 8B 4C 24 ?? 85 C0 0F 86 ??
            ?? ?? ?? 0F B6 11 80 FA ?? 75 ?? 8B 44 24 ?? 8B 8C 24 ?? ?? ?? ?? 8B 54 24 ?? E9 ??
            ?? ?? ?? 80 FA ?? 74 ?? 89 44 24 ?? 89 8C 24 ?? ?? ?? ?? 89 0C 24 89 44 24 ?? 8B 15
            ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? 8B 2D ?? ?? ?? ?? 89 6C 24 ?? 89 5C 24 ?? 89 54 24 ??
            E8 ?? ?? ?? ?? 0F B6 44 24 ?? 84 C0 74 ?? 8B 44 24 ?? 8B 8C 24 ?? ?? ?? ?? 8B 54 24
            ?? E9 ?? ?? ?? ?? 8B 44 24 ?? 83 F8 ?? 0F 85 ?? ?? ?? ?? 8B 8C 24 ?? ?? ?? ?? 8B 11
        }

        $find_files_p2 = {
            81 FA ?? ?? ?? ?? 75 ?? 0F B7 51 ?? 66 81 FA ?? ?? 75 ?? 0F B6 51 ?? 80 FA ?? 0F 84
            ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? 8B 94 24 ?? ?? ?? ?? 89 54 24 ?? 8B 9C 24 ?? ?? ??
            ?? 89 5C 24 ?? 8D 2D ?? ?? ?? ?? 89 6C 24 ?? C7 44 24 ?? ?? ?? ?? ?? 89 4C 24 ?? 89
            44 24 ?? E8 ?? ?? ?? ?? 8B 44 24 ?? 8B 4C 24 ?? 89 04 24 89 4C 24 ?? E8 ?? ?? ?? ??
            8B 44 24 ?? 8D 48 ?? 8B 54 24 ?? 8B 5C 24 ?? 8B 6C 24 ?? 39 E9 7F ?? 8B B4 24 ?? ??
            ?? ?? 8D 7C C6 ?? 89 1F 8D 04 C6 8B 1D ?? ?? ?? ?? 85 DB 75 ?? 89 10 89 E8 89 CA 89
            F1 E9 ?? ?? ?? ?? 89 B4 24 ?? ?? ?? ?? 89 4C 24 ?? 89 6C 24 ?? 89 04 24 89 54 24 ??
            E8 ?? ?? ?? ?? 8B 4C 24 ?? 8B 6C 24 ?? 8B B4 24 ?? ?? ?? ?? EB ?? 89 94 24 ?? ?? ??
            ?? 89 5C 24 ?? 8D 15 ?? ?? ?? ?? 89 14 24 8B 9C 24 ?? ?? ?? ?? 89 5C 24 ?? 89 44 24
            ?? 89 6C 24 ?? 89 4C 24 ?? E8 ?? ?? ?? ?? 8B 74 24 ?? 8B 44 24 ?? 8B 6C 24 ?? 8D 48
            ?? 8B 44 24 ?? 8B 94 24 ?? ?? ?? ?? 8B 5C 24 ?? E9 ?? ?? ?? ?? 8D 54 24 ?? 89 14 24
            8B 94 24 ?? ?? ?? ?? 89 54 24 ?? 8B 9C 24 ?? ?? ?? ?? 89 5C 24 ?? 8D 2D ?? ?? ?? ??
            89 6C 24 ?? C7 44 24 ?? ?? ?? ?? ?? 89 4C 24 ?? 89 44 24 ?? E8 ?? ?? ?? ?? 8B 44 24
            ?? 8B 4C 24 ?? 89 0C 24 89 44 24 ?? E8 ?? ?? ?? ?? 8B 44 24 ?? 8B 8C 24 ?? ?? ?? ??
            E9 ?? ?? ?? ?? 8B 8C 24 ?? ?? ?? ?? E9 ?? ?? ?? ?? 8B 84 24 ?? ?? ?? ?? 8B 40 ?? 8B
        }

        $find_files_p3 = {
            8C 24 ?? ?? ?? ?? 89 0C 24 FF D0 8B 44 24 ?? 8B 4C 24 ?? 89 0C 24 89 44 24 ?? E8 ??
            ?? ?? ?? 8B 44 24 ?? 89 44 24 ?? 8B 4C 24 ?? 89 4C 24 ?? 89 04 24 89 4C 24 ?? 8B 15
            ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? 8B 2D ?? ?? ?? ?? 89 6C 24 ?? 89 5C 24 ?? 89 54 24 ??
            E8 ?? ?? ?? ?? 0F B6 44 24 ?? 84 C0 74 ?? 8B 44 24 ?? 8B 8C 24 ?? ?? ?? ?? 8B 54 24
            ?? E9 ?? ?? ?? ?? 8B 44 24 ?? 89 04 24 8B 4C 24 ?? 89 4C 24 ?? E8 ?? ?? ?? ?? 8B 44
            24 ?? 89 84 24 ?? ?? ?? ?? 8B 4C 24 ?? 89 4C 24 ?? C7 04 24 ?? ?? ?? ?? 8B 94 24 ??
            ?? ?? ?? 89 54 24 ?? 8B 9C 24 ?? ?? ?? ?? 89 5C 24 ?? 8D 2D ?? ?? ?? ?? 89 6C 24 ??
            C7 44 24 ?? ?? ?? ?? ?? 8B 74 24 ?? 89 74 24 ?? 8B 74 24 ?? 89 74 24 ?? E8 ?? ?? ??
            ?? 8B 44 24 ?? 89 44 24 ?? 8B 4C 24 ?? 89 4C 24 ?? 8B 94 24 ?? ?? ?? ?? 89 14 24 8B
            5C 24 ?? 89 5C 24 ?? 8B 2D ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 89 6C 24
            ?? 89 74 24 ?? 89 7C 24 ?? E8 ?? ?? ?? ?? 0F B6 44 24 ?? 84 C0 0F 84 ?? ?? ?? ?? 8B
            84 24 ?? ?? ?? ?? 85 C0 0F 86 ?? ?? ?? ?? 8B 84 24 ?? ?? ?? ?? 0F B6 08 83 C1 ?? 88
            4C 24 ?? 0F B6 08 83 C1 ?? 88 4C 24 ?? 8D 0D ?? ?? ?? ?? 89 0C 24 8B 15 ?? ?? ?? ??
            89 54 24 ?? 8D 54 24 ?? 89 54 24 ?? E8 ?? ?? ?? ?? 8B 44 24 ?? 8B 48 ?? 8D 51 ?? 8B
            18 8B 40 ?? 39 C2 0F 8F ?? ?? ?? ?? 89 9C 24 ?? ?? ?? ?? 89 54 24 ?? 89 44 24 ?? 8D
        }

        $find_files_p4 = {
            6C CB ?? 8B 74 24 ?? 89 75 ?? 8B 2D ?? ?? ?? ?? 8D 0C CB 85 ED 75 ?? 8B 6C 24 ?? 89
            29 8D 05 ?? ?? ?? ?? 89 04 24 8B 0D ?? ?? ?? ?? 89 4C 24 ?? 8D 4C 24 ?? 89 4C 24 ??
            E8 ?? ?? ?? ?? 8B 44 24 ?? 8B 4C 24 ?? 89 48 ?? 8B 4C 24 ?? 89 48 ?? 8B 0D ?? ?? ??
            ?? 85 C9 75 ?? 8B 8C 24 ?? ?? ?? ?? 89 08 8B 6C 24 ?? 8B 4C 24 ?? 8B B4 24 ?? ?? ??
            ?? E9 ?? ?? ?? ?? 89 04 24 8B 84 24 ?? ?? ?? ?? 89 44 24 ?? E8 ?? ?? ?? ?? EB ?? 89
            0C 24 8B 44 24 ?? 89 44 24 ?? E8 ?? ?? ?? ?? EB ?? 89 4C 24 ?? 8D 2D ?? ?? ?? ?? 89
            2C 24 89 5C 24 ?? 89 4C 24 ?? 89 44 24 ?? 89 54 24 ?? E8 ?? ?? ?? ?? 8B 5C 24 ?? 8B
            44 24 ?? 8B 4C 24 ?? 8D 50 ?? 89 C8 8B 4C 24 ?? E9 ?? ?? ?? ?? 8B 84 24 ?? ?? ?? ??
            89 04 24 8B 44 24 ?? 89 44 24 ?? 8B 05 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 8B 15 ?? ?? ??
            ?? 89 44 24 ?? 89 4C 24 ?? 89 54 24 ?? E8 ?? ?? ?? ?? 0F B6 44 24 ?? 84 C0 74 ?? 8B
            44 24 ?? 8B 8C 24 ?? ?? ?? ?? 8B 54 24 ?? E9 ?? ?? ?? ?? 8B 84 24 ?? ?? ?? ?? 85 C0
            0F 86 ?? ?? ?? ?? 8B 84 24 ?? ?? ?? ?? 0F B6 08 88 4C 24 ?? 0F B6 08 88 4C 24 ?? 8D
        }

        $find_files_p5 = {
            0D ?? ?? ?? ?? 89 0C 24 8B 15 ?? ?? ?? ?? 89 54 24 ?? 8D 54 24 ?? 89 54 24 ?? E8 ??
            ?? ?? ?? 8B 44 24 ?? 8B 48 ?? 8D 51 ?? 8B 18 8B 40 ?? 39 C2 0F 8F ?? ?? ?? ?? 89 9C
            24 ?? ?? ?? ?? 89 54 24 ?? 89 44 24 ?? 8D 6C CB ?? 8B 74 24 ?? 89 75 ?? 8B 2D ?? ??
            ?? ?? 8D 0C CB 85 ED 75 ?? 8B 6C 24 ?? 89 29 8D 05 ?? ?? ?? ?? 89 04 24 8B 0D ?? ??
            ?? ?? 89 4C 24 ?? 8D 4C 24 ?? 89 4C 24 ?? E8 ?? ?? ?? ?? 8B 44 24 ?? 8B 4C 24 ?? 89
            48 ?? 8B 4C 24 ?? 89 48 ?? 8B 0D ?? ?? ?? ?? 85 C9 75 ?? 8B 8C 24 ?? ?? ?? ?? 89 08
            E9 ?? ?? ?? ?? 89 04 24 8B 84 24 ?? ?? ?? ?? 89 44 24 ?? E8 ?? ?? ?? ?? E9 ?? ?? ??
            ?? 89 0C 24 8B 44 24 ?? 89 44 24 ?? E8 ?? ?? ?? ?? EB ?? 89 4C 24 ?? 8D 2D ?? ?? ??
            ?? 89 2C 24 89 5C 24 ?? 89 4C 24 ?? 89 44 24 ?? 89 54 24 ?? E8 ?? ?? ?? ?? 8B 5C 24
            ?? 8B 44 24 ?? 8B 4C 24 ?? 8D 50 ?? 89 C8 8B 4C 24 ?? E9 ?? ?? ?? ?? 89 AC 24 ?? ??
            ?? ?? 89 8C 24 ?? ?? ?? ?? 89 B4 24 ?? ?? ?? ?? C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? C7
            84 24 ?? ?? ?? ?? ?? ?? ?? ?? 81 C4 ?? ?? ?? ?? C3 C7 84 24 ?? ?? ?? ?? ?? ?? ?? ??
            C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? 89 8C 24 ?? ?? ??
            ?? 89 84 24 ?? ?? ?? ?? 81 C4 ?? ?? ?? ?? C3 E8
        }

        $encrypt_files_p1 = {
            64 8B 0D ?? ?? ?? ?? 8B 89 ?? ?? ?? ?? 8D 44 24 ?? 3B 41 ?? 0F 86 ?? ?? ?? ?? 81 EC
            ?? ?? ?? ?? 8B 05 ?? ?? ?? ?? C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? C7 84 24 ?? ?? ?? ??
            ?? ?? ?? ?? 8B 40 ?? 89 04 24 8D 84 24 ?? ?? ?? ?? 89 44 24 ?? E8 ?? ?? ?? ?? 8B 84
            24 ?? ?? ?? ?? 8B 8C 24 ?? ?? ?? ?? 8D 15 ?? ?? ?? ?? 39 CA 0F 85 ?? ?? ?? ?? 8B 48
            ?? 89 4C 24 ?? 8B 00 89 84 24 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? 89 44 24 ?? 89 4C 24
            ?? 8B 15 ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? 89 54 24 ?? 89 5C 24 ?? E8 ?? ?? ?? ?? 8B 44
            24 ?? 89 44 24 ?? 8B 4C 24 ?? 89 4C 24 ?? C6 44 24 ?? ?? C7 84 24 ?? ?? ?? ?? ?? ??
            ?? ?? C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? 8D 54 24 ?? 89 54 24 ?? 8B 94 24 ?? ?? ?? ??
            89 54 24 ?? 8B 5C 24 ?? 89 5C 24 ?? 8D AC 24 ?? ?? ?? ?? 89 6C 24 ?? 89 4C 24 ?? 89
            44 24 ?? C7 04 24 ?? ?? ?? ?? 8D 2D ?? ?? ?? ?? 89 6C 24 ?? E8 ?? ?? ?? ?? 85 C0 0F
            85 ?? ?? ?? ?? 8B 84 24 ?? ?? ?? ?? 89 04 24 8B 4C 24 ?? 89 4C 24 ?? C7 44 24 ?? ??
            ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 44 24 ?? 8B 4C 24 ?? 8B 54 24 ??
            85 D2 0F 85 ?? ?? ?? ?? 89 44 24 ?? 89 44 24 ?? C7 04 24 ?? ?? ?? ?? 8D 0D ?? ?? ??
            ?? 89 4C 24 ?? E8 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 8B 44 24 ?? 89 04 24 8B 44 24
            ?? 89 44 24 ?? E8 ?? ?? ?? ?? 8B 44 24 ?? 8B 4C 24 ?? 8B 54 24 ?? 85 D2 0F 85 ?? ??
            ?? ?? 89 44 24 ?? C7 04 24 ?? ?? ?? ?? 8D 05 ?? ?? ?? ?? 89 44 24 ?? E8
        }

        $encrypt_files_p2 = {
            85 C0 0F 85 ?? ?? ?? ?? 8D 05 ?? ?? ?? ?? 89 04 24 C7 44 24 ?? ?? ?? ?? ?? C7 44 24
            ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 44 24 ?? 89 44 24 ?? 8B 4C 24 ?? 89 4C 24 ?? 8B 54
            24 ?? 89 54 24 ?? 89 14 24 89 4C 24 ?? 89 44 24 ?? E8 ?? ?? ?? ?? 8B 44 24 ?? 8B 4C
            24 ?? 85 C9 0F 85 ?? ?? ?? ?? 8B 05 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ??
            89 14 24 89 4C 24 ?? 89 44 24 ?? E8 ?? ?? ?? ?? 8B 44 24 ?? 8B 4C 24 ?? 8B 54 24 ??
            8B 5C 24 ?? 85 C9 0F 85 ?? ?? ?? ?? 89 1C 24 89 54 24 ?? 8B 44 24 ?? 89 44 24 ?? 8B
            4C 24 ?? 89 4C 24 ?? 8B 54 24 ?? 89 54 24 ?? E8 ?? ?? ?? ?? 8B 44 24 ?? 89 44 24 ??
            8B 4C 24 ?? 89 4C 24 ?? 8D 15 ?? ?? ?? ?? 89 14 24 8B 15 ?? ?? ?? ?? 8B 1D ?? ?? ??
            ?? 8B 2D ?? ?? ?? ?? 89 54 24 ?? 89 5C 24 ?? 89 6C 24 ?? E8 ?? ?? ?? ?? 8B 44 24 ??
            89 44 24 ?? 8B 4C 24 ?? 89 4C 24 ?? 8D 15 ?? ?? ?? ?? 89 14 24 C7 44 24 ?? ?? ?? ??
            ?? C7 44 24 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 44 24 ?? 89 84 24 ?? ?? ?? ?? 8B 4C 24
            ?? 89 4C 24 ?? 8B 54 24 ?? 89 54 24 ?? 8B 5C 24 ?? 89 1C 24 8B 6C 24 ?? 89 6C 24 ??
            8B 6C 24 ?? 89 6C 24 ?? 8B 6C 24 ?? 89 6C 24 ?? E8 ?? ?? ?? ?? 8B 44 24 ?? 8B 4C 24
            ?? 85 C0 0F 85 ?? ?? ?? ?? 31 C0 EB ?? 8B 4C 24 ?? 8B 54 24 ?? 8D 04 0A 89 44 24 ??
            8B 4C 24 ?? 89 0C 24 8B 94 24 ?? ?? ?? ?? 89 54 24 ?? 8B 5C 24 ?? 89 5C 24 ?? 8B 6C
            24 ?? 89 6C 24 ?? E8 ?? ?? ?? ?? 8B 44 24 ?? 89 44 24 ?? 8B 4C 24 ?? 89 4C 24 ?? 8B
            54 24 ?? 89 54 24 ?? 85 C9 74 ?? 8B 1D ?? ?? ?? ?? 39 D9 0F 85 ?? ?? ?? ?? 89 0C 24
        }

        $encrypt_files_p3 = {
            89 54 24 ?? 8B 05 ?? ?? ?? ?? 89 44 24 ?? E8 ?? ?? ?? ?? 0F B6 44 24 ?? 84 C0 0F 84
            ?? ?? ?? ?? 8D 05 ?? ?? ?? ?? 89 04 24 8B 4C 24 ?? 89 4C 24 ?? 89 4C 24 ?? E8 ?? ??
            ?? ?? 8B 44 24 ?? 8B 4C 24 ?? 8B 54 24 ?? 8B 5C 24 ?? 8B 6C 24 ?? 39 EB 0F 87 ?? ??
            ?? ?? 89 44 24 ?? 89 4C 24 ?? 89 54 24 ?? 8B 74 24 ?? 8B 7E ?? 89 44 24 ?? 89 4C 24
            ?? 89 54 24 ?? 8B B4 24 ?? ?? ?? ?? 89 74 24 ?? 89 5C 24 ?? 89 6C 24 ?? 8B 6C 24 ??
            89 2C 24 FF D7 8B 44 24 ?? 8B 48 ?? 8B 54 24 ?? 89 54 24 ?? 8B 5C 24 ?? 89 5C 24 ??
            8B 6C 24 ?? 89 6C 24 ?? 8B 74 24 ?? 89 34 24 FF D1 8B 44 24 ?? 89 04 24 8B 4C 24 ??
            89 4C 24 ?? 8B 4C 24 ?? 89 4C 24 ?? 8B 4C 24 ?? 89 4C 24 ?? E8 ?? ?? ?? ?? 8B 44 24
            ?? 85 C0 0F 85 ?? ?? ?? ?? 8B 05 ?? ?? ?? ?? 8B 4C 24 ?? 39 C1 0F 85 ?? ?? ?? ?? 89
            0C 24 8B 44 24 ?? 89 44 24 ?? 8B 05 ?? ?? ?? ?? 89 44 24 ?? E8 ?? ?? ?? ?? 0F B6 44
            24 ?? 84 C0 0F 84 ?? ?? ?? ?? 8B 84 24 ?? ?? ?? ?? 89 04 24 8B 44 24 ?? 89 44 24 ??
            C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 44 24 ?? 89 04 24
            C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? E8 ?? ?? ??
            ?? 8B 44 24 ?? B9 ?? ?? ?? ?? F7 E9 8B 44 24 ?? 01 C2 C1 F8 ?? C1 FA ?? 29 C2 89 D0
            89 D3 F7 E9 8D 04 13 C1 F8 ?? C1 FB ?? 29 D8 83 C0 ?? 89 44 24 ?? 31 C9 EB ?? 8B 54
            24 ?? 8D 4A ?? 8B 44 24 ?? 39 C1 7D ?? 89 4C 24 ?? 8B 44 24 ?? 89 04 24 8D 0D ?? ??
            ?? ?? 89 4C 24 ?? C7 44 24 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 44 24 ?? 85 C0 74 ?? 90
            E8 ?? ?? ?? ?? 81 C4 ?? ?? ?? ?? C3 90
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            all of ($find_files_p*)
        ) and
        (
            all of ($encrypt_files_p*)
        ) and
        (
            all of ($remote_connection_p*)
        )
}