rule Win32_Ransomware_Lolkek : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "LOLKEK"
        description         = "Yara rule that detects Lolkek ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Lolkek"
        tc_detection_factor = 5

    strings:

        $encrypt_files = {
            57 6A ?? FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? A1 ?? 
            ?? ?? ?? B9 ?? ?? ?? ?? FF 0D ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 3C 85 ?? ?? ?? ?? 40 99 
            F7 F9 89 15 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 6A ?? 6A ?? FF 35 ?? ?? ?? ?? FF 15 ?? ?? 
            ?? ?? 85 FF 0F 84 ?? ?? ?? ?? 53 8B 1D ?? ?? ?? ?? 56 8B CF E8 ?? ?? ?? ?? 85 C0 74 
            ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 57 8B F0 68 ?? ?? ?? ?? 56 FF D3 83 
            C4 ?? 56 57 FF 15 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 83 C4 ?? 57 E8 ?? ?? ?? ?? 83 C4 ?? 
            6A ?? FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? A1 ?? ?? 
            ?? ?? B9 ?? ?? ?? ?? FF 0D ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 3C 85 ?? ?? ?? ?? 40 99 F7 
            F9 89 15 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 6A ?? 6A ?? FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? 
            ?? 85 FF 0F 85 ?? ?? ?? ?? 5E 5B 33 C0 5F C2 
        }

        $find_volumes_p1 = {
            55 8B EC 83 E4 ?? 81 EC ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C4 89 84 24 ?? ?? ?? ?? 53 56 
            57 E8 ?? ?? ?? ?? 6A ?? 8D 84 24 ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 6A ?? 50 C7 44 
            24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? 
            ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 
            24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? 
            ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? C7 84 24 ?? ?? ?? ?? 
            ?? ?? ?? ?? C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? C7 84 
            24 ?? ?? ?? ?? ?? ?? ?? ?? C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? C7 84 24 ?? ?? ?? ?? ?? 
            ?? ?? ?? C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? C7 84 24 
            ?? ?? ?? ?? ?? ?? ?? ?? C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? C7 84 24 ?? ?? ?? ?? ?? ?? 
            ?? ?? C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 F6 83 C4 ?? 89 74 24 ?? 33
        }

        $find_volumes_p2 = {
            FF 8B 5C BC ?? 53 FF 15 ?? ?? ?? ?? 83 F8 ?? 75 ?? 89 9C B4 ?? ?? ?? ?? 46 47 83 FF 
            ?? 7C ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 83 C4 ?? 85 FF 0F 84 ?? ?? ?? ?? 68 ?? 
            ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 89 44 24 ?? 85 C0 74 ?? 68 ?? ?? ?? ?? 57 FF 15 ?? 
            ?? ?? ?? 8B D8 0F 1F 00 85 F6 74 ?? 8D 44 24 ?? 50 6A ?? 8D 84 24 ?? ?? ?? ?? 50 57 
            FF 15 ?? ?? ?? ?? 85 C0 74 ?? 8D 84 24 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 83 F8 ?? 74 
            ?? 4E 57 FF B4 B4 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 57 53 FF 15 ?? ?? ?? 
            ?? 85 C0 75 ?? 53 FF 15 ?? ?? ?? ?? FF 74 24 ?? E8 ?? ?? ?? ?? 83 C4 ?? 57 E8 ?? ?? 
            ?? ?? 83 C4 ?? 8B 3D ?? ?? ?? ?? 33 F6 8B 1D ?? ?? ?? ?? C6 84 24 ?? ?? ?? ?? ?? FF 
            D7 33 D2 B9 ?? ?? ?? ?? F7 F1 68 ?? ?? ?? ?? 80 C2 ?? 88 94 34 ?? ?? ?? ?? FF D3 46 
            83 FE ?? 7C ?? 8D 84 24 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? 
            ?? 83 C4 ?? 8D 44 24 ?? 68 ?? ?? ?? ?? 6A ?? 6A ?? 6A ?? 50 FF 15
        }

        $find_files_p1 = {
            8B FF 55 8B EC 51 8B 4D ?? 8D 51 ?? 8A 01 41 84 C0 75 ?? 57 8B 7D ?? 2B CA 8B C7 41 
            F7 D0 89 4D ?? 3B C8 76 ?? 6A ?? 58 5F C9 C3 53 56 8D 5F ?? 03 D9 6A ?? 53 E8 ?? ?? 
            ?? ?? 8B F0 59 59 85 FF 74 ?? 57 FF 75 ?? 53 56 E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 75 ?? 
            FF 75 ?? 2B DF 8D 04 3E FF 75 ?? 53 50 E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 75 ?? 8B 5D ?? 
            8B CB E8 ?? ?? ?? ?? 33 FF 89 45 ?? 85 C0 74 ?? 56 E8 ?? ?? ?? ?? 8B 75 ?? 59 EB ?? 
            8B 43 ?? 89 30 8B F7 83 43 ?? ?? 57 E8 ?? ?? ?? ?? 59 8B C6 5E 5B EB ?? 33 FF 57 57 
            57 57 57 E8 ?? ?? ?? ?? CC 8B FF 55 8B EC 81 EC ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C5 89 
            45 ?? 8B 4D ?? 8B 55 ?? 53 57 8B 7D ?? 89 95 ?? ?? ?? ?? 3B CF 74 ?? 8A 01 3C ?? 74 
            ?? 3C ?? 74 ?? 3C ?? 74 ?? 51 57 E8 ?? ?? ?? ?? 59 59 8B C8 3B CF 75 ?? 8B 95 ?? ?? 
            ?? ?? 8A 01 88 85 ?? ?? ?? ?? 3C ?? 75 ?? 8D 47 ?? 3B C8 74 ?? 52 33 DB 53 53 57 E8 
            ?? ?? ?? ?? 83 C4 ?? E9 ?? ?? ?? ?? 8A 85 ?? ?? ?? ?? 33 DB 3C ?? 74 ?? 3C ?? 74 ?? 
            3C ?? 8A C3 75 ?? B0 ?? 2B CF 0F B6 C0 41 89 9D ?? ?? ?? ?? F7 D8 89 9D
        }

        $find_files_p2 = {
            56 1B C0 89 9D ?? ?? ?? ?? 23 C1 89 9D ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 89 9D ?? ?? ?? 
            ?? 88 9D ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 57 E8 ?? ?? ?? ?? 83 C4 
            ?? 8D 8D ?? ?? ?? ?? F7 D8 1B C0 53 53 53 51 F7 D0 23 85 ?? ?? ?? ?? 53 50 FF 15 ?? 
            ?? ?? ?? 8B F0 83 FE ?? 75 ?? FF B5 ?? ?? ?? ?? 53 53 57 E8 ?? ?? ?? ?? 83 C4 ?? 8B 
            D8 E9 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 8B 48 ?? 2B 08 C1 F9 ?? 89 8D ?? ?? ?? ?? 89 9D 
            ?? ?? ?? ?? 89 9D ?? ?? ?? ?? 89 9D ?? ?? ?? ?? 89 9D ?? ?? ?? ?? 89 9D ?? ?? ?? ?? 
            88 9D ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 8D 85 
            ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? F7 D8 1B C0 F7 D0 23 85 ?? ?? ?? ?? 80 38 ?? 
            75 ?? 8A 48 ?? 84 C9 74 ?? 80 F9 ?? 75 ?? 38 58 ?? 74 ?? FF B5 ?? ?? ?? ?? FF B5 ?? 
            ?? ?? ?? 57 50 E8 ?? ?? ?? ?? 83 C4 ?? 89 85 ?? ?? ?? ?? 85 C0 75 ?? 38 9D ?? ?? ?? 
            ?? 74 ?? FF B5 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8D 85 ?? ?? ?? ?? 50 56 FF 15 ?? ?? ?? 
            ?? 85 C0 0F 85 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 8B 8D ?? ?? ?? ?? 8B 10 8B 40 ?? 2B C2 
            C1 F8 ?? 3B C8 74 ?? 68 ?? ?? ?? ?? 2B C1 6A ?? 50 8D 04 8A 50 E8 ?? ?? ?? ?? 83 C4 
            ?? EB ?? 38 9D ?? ?? ?? ?? 74 ?? FF B5 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 
            59 8B D8 56 FF 15 ?? ?? ?? ?? 80 BD ?? ?? ?? ?? ?? 5E 74 ?? FF B5 ?? ?? ?? ?? E8 ?? 
            ?? ?? ?? 59 8B C3 8B 4D ?? 5F 33 CD 5B E8 ?? ?? ?? ?? C9 C3 
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            all of ($find_volumes_p*)
        ) and
        (
            all of ($find_files_p*)
        ) and
        (
            $encrypt_files
        )
}