rule Win32_Ransomware_Plague17 : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "PLAGUE17"
        description         = "Yara rule that detects Plague17 ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Plague17"
        tc_detection_factor = 5

    strings:

        $find_files_p1 = {
            55 89 E5 57 56 8D 85 ?? ?? ?? ?? 53 81 EC ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 31 C0 66 89 
            85 ?? ?? ?? ?? 8B 45 ?? 89 8D ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 8B 50 ?? 8B 
            00 66 83 7C 50 ?? ?? 74 ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D ?? BA ?? ?? ?? 
            ?? 2B 51 ?? 39 D0 0F 87 ?? ?? ?? ?? 8B 4D ?? 89 44 24 ?? C7 04 24 ?? ?? ?? ?? E8 ?? 
            ?? ?? ?? 8B 45 ?? 8B 7D ?? 83 EC ?? 8B 00 8B 57 ?? 8D 8D ?? ?? ?? ?? 8D 14 50 C6 44 
            24 ?? ?? 89 04 24 89 8D ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 89 54 24 ?? E8 ?? ?? ?? ?? 83 
            EC ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? BA ?? ?? ?? ?? 2B 95 ?? ?? ?? ?? 39 D0 0F 
            87 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 89 44 24 ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 
            85 ?? ?? ?? ?? 83 EC ?? 8D 8D ?? ?? ?? ?? 8D BD ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 
            8B 85 ?? ?? ?? ?? 83 EC ?? 39 F8 74 ?? 89 04 24 E8 ?? ?? ?? ?? 8B 45 ?? 8B 7D ?? 8D
        }

        $find_files_p2 = {
            9D ?? ?? ?? ?? 8D B5 ?? ?? ?? ?? 89 D9 8B 00 C6 44 24 ?? ?? 8B 57 ?? 89 B5 ?? ?? ?? 
            ?? 89 04 24 8D 14 50 89 54 24 ?? E8 ?? ?? ?? ?? 8B 8D ?? ?? ?? ?? 83 EC ?? 89 1C 24 
            E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 83 EC ?? 39 F0 74 ?? 89 04 24 E8 ?? ?? ?? ?? 8B 85 
            ?? ?? ?? ?? 89 5C 24 ?? 89 04 24 FF 15 ?? ?? ?? ?? 83 EC ?? 83 F8 ?? 89 C6 0F 84 ?? 
            ?? ?? ?? 8D BD ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 89 3C 24 E8 ?? ?? ?? ?? 85 C0 74 
            ?? C7 44 24 ?? ?? ?? ?? ?? 89 3C 24 E8 ?? ?? ?? ?? 85 C0 74 ?? 8B 45 ?? F6 85 ?? ?? 
            ?? ?? ?? 89 7C 24 ?? 89 44 24 ?? 8D 85 ?? ?? ?? ?? 89 04 24 0F 85 ?? ?? ?? ?? E8 ?? 
            ?? ?? ?? 8D 85 ?? ?? ?? ?? 8B 8D ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? 
            ?? 8D 8D ?? ?? ?? ?? 83 EC ?? 39 C8 74 ?? 89 04 24 E8 ?? ?? ?? ?? EB ?? C7 44 24 ?? 
            ?? ?? ?? ?? 89 3C 24 E8 ?? ?? ?? ?? 85 C0 75 ?? 89 5C 24 ?? 89 34 24 FF 15 ?? ?? ?? 
            ?? 83 EC ?? 85 C0 75 ?? 89 34 24 FF 15 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 8D 9D ?? ?? ?? 
            ?? 83 EC ?? 39 D8 74 ?? 89 04 24 E8 ?? ?? ?? ?? 8D 65 ?? 5B 5E 5F 5D C2 ?? ?? 8D 76 
            ?? 8D BC 27 ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 89 3C 24 E8 ?? ?? ?? ?? 85 C0 74
        }

        $find_files_p3 = { 
            8B 45 ?? F6 85 ?? ?? ?? ?? ?? 89 7C 24 ?? 89 44 24 ?? 8D 85 ?? ?? ?? ?? 89 04 24 75 
            ?? E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 8B 8D ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? E9 ?? 
            ?? ?? ?? E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 8B 8D ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 
            8B 85 ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? 83 EC ?? 39 D0 0F 85 ?? ?? ?? ?? E9 ?? ?? ?? ?? 
            E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 8B 8D ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? EB ?? 89 
            C3 8B 85 ?? ?? ?? ?? 8D B5 ?? ?? ?? ?? 39 F0 74 ?? 89 04 24 E8 ?? ?? ?? ?? 8B 85 ?? 
            ?? ?? ?? 8D B5 ?? ?? ?? ?? 39 F0 74 ?? 89 04 24 E8 ?? ?? ?? ?? 89 1C 24 E8 ?? ?? ?? 
            ?? EB ?? 89 C3 8B 85 ?? ?? ?? ?? 39 F0 75 ?? EB ?? EB ?? EB ?? 89 C3 EB ?? C7 04 24 
            ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB
        }

        $encrypt_files_p1 = {
            55 89 E5 57 56 53 81 EC ?? ?? ?? ?? 8B 45 ?? 89 8D ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? 
            ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 
            ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 8B 00 89 04 24 FF 15 ?? ?? ?? ?? 83 EC ?? 83 
            F8 ?? 89 85 ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? 89 C6 8D 85 ?? ?? ?? ?? 8D BD ?? ?? ?? ?? 
            89 34 24 89 44 24 ?? FF 15 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 83 EC ?? 8B 95 ?? ?? ?? ?? 
            89 7C 24 ?? C7 44 24 ?? ?? ?? ?? ?? 8D BD ?? ?? ?? ?? 89 34 24 05 ?? ?? ?? ?? 89 85 
            ?? ?? ?? ?? 89 44 24 ?? 83 D2 ?? A1 ?? ?? ?? ?? 89 95 ?? ?? ?? ?? 89 54 24 ?? 89 85 
            ?? ?? ?? ?? FF D0 31 C0 83 EC ?? 83 BD ?? ?? ?? ?? ?? B9 ?? ?? ?? ?? F3 AB 7C ?? 0F 
            8E ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 8D B5 ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 
            ?? ?? ?? ?? ?? 89 44 24 ?? 8B 85 ?? ?? ?? ?? 89 74 24 ?? 89 04 24 FF 15 ?? ?? ?? ?? 
            83 EC ?? 8D 85 ?? ?? ?? ?? B9 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 83 EC ?? 85 C0 0F 
            85 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 35 ?? ?? ?? ?? 0B 85 ?? ?? ?? ?? 0F 85 ?? ?? ?? ?? 
            80 7D ?? ?? 0F 85 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 C3 8D 85 ?? ?? 
            ?? ?? 89 D9 89 04 24 89 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 8B 95 ?? ?? 
            ?? ?? 83 EC ?? 8B B5 ?? ?? ?? ?? 89 D9 89 85 ?? ?? ?? ?? 89 95 ?? ?? ?? ?? 8B 85 ?? 
            ?? ?? ?? 8B 95 ?? ?? ?? ?? 89 1E 0F A4 C2 ?? C1 E0 ?? 89 95 ?? ?? ?? ?? 89 85 ?? ?? 
            ?? ?? E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 89 85 ?? 
            ?? ?? ?? 8B 85 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 8D
        }

        $encrypt_files_p2 = {
            85 ?? ?? ?? ?? 89 04 24 8B 0E E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 83 EC ?? 89 04 24 8B 
            85 ?? ?? ?? ?? 89 44 24 ?? 8B 85 ?? ?? ?? ?? 89 44 24 ?? 8B 85 ?? ?? ?? ?? 89 44 24 
            ?? 8B 0E E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 83 EC ?? 89 04 24 89 54 
            24 ?? 8B 0E 8D B5 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B BD ?? ?? ?? ?? 83 EC ?? 8B 85 ?? ?? 
            ?? ?? 85 FF 0F 84 ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 8B 95 
            ?? ?? ?? ?? 8D BD ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 89 7C 24 ?? 89 44 24 ?? 8B 85 
            ?? ?? ?? ?? 89 54 24 ?? 89 04 24 FF 95 ?? ?? ?? ?? 83 EC ?? C6 45 ?? ?? C7 04 24 ?? 
            ?? ?? ?? E8 ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 89 04 24 89 
            85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 2B 85 ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 
            1B 95 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 89 95 ?? ?? ?? ?? 0F AC D0 ?? C1 EA ?? 89 D3 09 
            C3 0F 84 ?? ?? ?? ?? 83 C0 ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? 
            ?? ?? 89 85 ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 D2 ?? 89 95 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 
            90 8D B4 26 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 89 74 24 ?? C7 44 
            24 ?? ?? ?? ?? ?? 89 44 24 ?? 8B 85 ?? ?? ?? ?? 89 04 24 FF 95 ?? ?? ?? ?? 8B 8D ?? 
            ?? ?? ?? 8B 9D ?? ?? ?? ?? 83 EC ?? 8B 95 ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 89 5C
        }

        $encrypt_files_p3 = { 
            24 ?? 89 0C 24 8B 0A E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 83 EC ?? 8B 
            9D ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 89 7C 24 ?? 89 44 24 ?? 89 54 24 ?? 89 1C 24 
            FF 95 ?? ?? ?? ?? 8B 8D ?? ?? ?? ?? 83 EC ?? 89 9D ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? 
            ?? 89 74 24 ?? C7 44 24 ?? ?? ?? ?? ?? 89 1C 24 89 4C 24 ?? FF 15 ?? ?? ?? ?? 8B 85 
            ?? ?? ?? ?? 83 EC ?? 8B 95 ?? ?? ?? ?? 8D 9D ?? ?? ?? ?? 81 85 ?? ?? ?? ?? ?? ?? ?? 
            ?? C7 44 24 ?? ?? ?? ?? ?? 83 95 ?? ?? ?? ?? ?? 89 44 24 ?? 8B 85 ?? ?? ?? ?? 89 5C 
            24 ?? 89 54 24 ?? 89 04 24 FF 95 ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 8D 9D ?? ?? ?? ?? 83 
            EC ?? 81 85 ?? ?? ?? ?? ?? ?? ?? ?? 89 D9 83 95 ?? ?? ?? ?? ?? 8B 02 89 04 24 E8 ?? 
            ?? ?? ?? 8B 9D ?? ?? ?? ?? 8B 8D ?? ?? ?? ?? 83 EC ?? 8B 95 ?? ?? ?? ?? 8B 85 ?? ?? 
            ?? ?? 89 9D ?? ?? ?? ?? 89 9D ?? ?? ?? ?? 8B 9D ?? ?? ?? ?? 89 8D ?? ?? ?? ?? 89 8D 
            ?? ?? ?? ?? 89 95 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 89 95 ?? ?? ?? ?? 8B 0B 89 85 ?? ?? 
            ?? ?? E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 89 04 24 8B 0B E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? 
            ?? 83 EC ?? 89 04 24 8B 85 ?? ?? ?? ?? 89 44 24 ?? 8B 85 ?? ?? ?? ?? 89 44 24 ?? 8B 
            85 ?? ?? ?? ?? 89 44 24 ?? 8B 0B E8 ?? ?? ?? ?? 8B 0B 83 EC ?? E8 ?? ?? ?? ?? 8B 9D 
            ?? ?? ?? ?? 89 95 ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? C7 44 24 ?? ?? ?? 
            ?? ?? 89 74 24 ?? C7 44 24 ?? ?? ?? ?? ?? 89 54 24 ?? 89 1C 24 FF 15 ?? ?? ?? ?? 8B
        }

        $encrypt_files_p4 = { 
            85 ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 83 EC ?? C7 44 24 ?? ?? ?? ?? ?? 89 7C 24 ?? 89 1C 
            24 89 44 24 ?? 89 54 24 ?? FF 95 ?? ?? ?? ?? 83 EC ?? 83 85 ?? ?? ?? ?? ?? 8B 9D ?? 
            ?? ?? ?? 83 95 ?? ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 8B 8D ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 
            31 CB 31 D0 89 DA 09 C2 0F 85 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 2B 85 ?? ?? ?? ?? 8B 95 
            ?? ?? ?? ?? 1B 95 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 89 95 ?? ?? ?? ?? 8B 8D ?? ?? ?? ?? 
            8B 85 ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 89 74 24 ?? 89 4C 24 ?? 8B 8D ?? ?? ?? ?? 
            89 C3 89 44 24 ?? 89 0C 24 FF 95 ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 83 EC ?? 8B 85 ?? ?? 
            ?? ?? C7 44 24 ?? ?? ?? ?? ?? 89 54 24 ?? 8B 95 ?? ?? ?? ?? 89 14 24 8B 08 E8 ?? ?? 
            ?? ?? 83 EC ?? 8B 85 ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 89 7C 24 ?? 8B BD ?? ?? ?? ?? C7 
            44 24 ?? ?? ?? ?? ?? 89 44 24 ?? 89 54 24 ?? 89 3C 24 FF 95 ?? ?? ?? ?? 83 EC ?? 8B 
            95 ?? ?? ?? ?? 89 BD ?? ?? ?? ?? 89 5C 24 ?? 8B 1D ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? 
            ?? 89 74 24 ?? 89 54 24 ?? 89 3C 24 89 9D ?? ?? ?? ?? FF D3 8B 95 ?? ?? ?? ?? 8B 85 
            ?? ?? ?? ?? 8D 9D ?? ?? ?? ?? 83 EC ?? B9 ?? ?? ?? ?? C7 85
        }

        $encrypt_files_p5 = { 
            89 DF C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 0F AC D0 ?? C1 EA 
            ?? 01 85 ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 11 95 ?? ?? ?? ?? 31 C0 C7 85 ?? 
            ?? ?? ?? ?? ?? ?? ?? F3 AB C7 44 24 ?? ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? C7 85 ?? ?? 
            ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C6 45 
            ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? C7 44 24 ?? ?? 
            ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 89 04 24 89 54 24 ?? E8 ?? ?? ?? ?? 8B BD ?? ?? ?? 
            ?? C7 44 24 ?? ?? ?? ?? ?? 89 44 24 ?? 89 5C 24 ?? C7 04 24 ?? ?? ?? ?? 89 85 ?? ?? 
            ?? ?? 89 7C 24 ?? E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? 31 C0 F3 AB 8B BD ?? ?? ?? ?? 89 74 
            24 ?? 8D B5 ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 89 74 24 ?? 
            89 3C 24 FF 95 ?? ?? ?? ?? 83 EC ?? 89 3C 24 FF 15 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 83 
            EC ?? 8B 18 85 DB 74 ?? 89 D9 E8 ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 89 1C 24 E8 ?? 
            ?? ?? ?? 8B 85 ?? ?? ?? ?? C7 00 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? 
            ?? 8D 65 ?? 31 C0 5B 5E 5F 5D C2 ?? ?? 8D BD ?? ?? ?? ?? 31 C0 B9 ?? ?? ?? ?? 8B B5 
            ?? ?? ?? ?? 31 D2 C7 85 ?? ?? ?? ?? ?? ?? ?? ?? F3 AB 8B BD ?? ?? ?? ?? C7 85 ?? ?? 
            ?? ?? ?? ?? ?? ?? 89 F9 C1 F9 ?? 83 E1 ?? 89 C8 01 F0 11 FA 0F AC D0 ?? C1 FA ?? 83
        }

        $encrypt_files_p6 = { 
            C0 ?? 83 D2 ?? 0F A4 C2 ?? C1 E0 ?? 89 95 ?? ?? ?? ?? 89 95 ?? ?? ?? ?? 89 FA 09 F2 
            89 85 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 0F 85 ?? ?? ?? ?? 8B B5 ?? ?? ?? ?? 8D 85 ?? ?? 
            ?? ?? 8D 95 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 89 F7 C6 00 ?? 83 C0 ?? 39 C2 75 ?? 89 BD 
            ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 C3 8B 85 ?? ?? ?? ?? 89 D9 89 04 
            24 E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 83 EC ?? 89 18 A1 ?? ?? ?? ?? 89 44 24 ?? 8D 85 
            ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D ?? 89 
            44 24 ?? C7 44 24 ?? ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 75 ?? 83 C0 
            ?? 83 EC ?? 8B 56 ?? 39 D0 0F 87 ?? ?? ?? ?? 8B 7D ?? 29 C2 8D B5 ?? ?? ?? ?? 8D 9D 
            ?? ?? ?? ?? 8B 0F C6 44 24 ?? ?? 89 9D ?? ?? ?? ?? 8D 0C 41 8D 04 51 89 0C 24 89 F1 
            89 44 24 ?? E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 83 EC ?? 89 34 24 8D 48 ?? E8 ?? ?? ?? 
            ?? 8B 85 ?? ?? ?? ?? 83 EC ?? 39 D8 74 ?? 89 04 24 E8 ?? ?? ?? ?? 8B BD ?? ?? ?? ?? 
            8D B5 ?? ?? ?? ?? 8D 9D ?? ?? ?? ?? 8B 47 ?? 89 34 24 89 44 24 ?? E8 ?? ?? ?? ?? 8B 
            85 ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 8B 0F C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? 
            ?? ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 89 95 ?? ?? ?? ?? E8 ?? ?? ?? ?? 66 90 89 34 24 8B 
            0F 83 C6 ?? E8 ?? ?? ?? ?? 83 EC ?? 39 DE 75 ?? 8B BD ?? ?? ?? ?? 8B B5
        }

        $encrypt_files_p7 = { 
            8B 0F E8 ?? ?? ?? ?? 8B 07 8D 8D ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? 
            ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 89 
            04 24 E8 ?? ?? ?? ?? 8B 8D ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 83 EC ?? 8B 85 ?? ?? ?? ?? 
            8B 9D ?? ?? ?? ?? 89 8D ?? ?? ?? ?? 89 8D ?? ?? ?? ?? 8B 0F 89 95 ?? ?? ?? ?? 89 95 
            ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 89 9D ?? ?? ?? ?? 89 9D ?? ?? ?? ?? 
            E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 89 04 24 8B 0F E8 ?? ?? ?? ?? 8B 0F 83 EC ?? E8 ?? 
            ?? ?? ?? 8B 0F 89 F7 E8 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 89 95 ?? ?? 
            ?? ?? 8B 95 ?? ?? ?? ?? 89 34 24 8D B5 ?? ?? ?? ?? 89 44 24 ?? 8B 85 ?? ?? ?? ?? C7 
            44 24 ?? ?? ?? ?? ?? 89 54 24 ?? 89 44 24 ?? FF 95 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 83 
            EC ?? 89 3C 24 C7 44 24 ?? ?? ?? ?? ?? 89 74 24 ?? C7 44 24 ?? ?? ?? ?? ?? 89 44 24 
            ?? FF 15 ?? ?? ?? ?? 8B BD ?? ?? ?? ?? 83 EC ?? 8B 85 ?? ?? ?? ?? 85 FF 0F 85 ?? ?? 
            ?? ?? 3D ?? ?? ?? ?? 0F 87 ?? ?? ?? ?? 3D ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 
            0F 87 ?? ?? ?? ?? 3D ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 0F 87 ?? ?? ?? ?? 3D 
            ?? ?? ?? ?? 0F 97 C0 0F B6 C0 89 85 ?? ?? ?? ?? E9 ?? ?? ?? ?? 8D 65 ?? B8 ?? ?? ?? 
            ?? 5B 5E 5F 5D C2 ?? ?? 8B 85 ?? ?? ?? ?? 89 04 24 FF 15 ?? ?? ?? ?? 83 EC ?? 8D 65 
            ?? B8 ?? ?? ?? ?? 5B 5E 5F 5D C2 ?? ?? 8B 85 ?? ?? ?? ?? 89 04 24 FF 15
        }

        $encrypt_files_p8 = { 
            83 EC ?? 8D 65 ?? 31 C0 5B 5E 5F 5D C2 ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 
            04 24 ?? ?? ?? ?? 89 C6 89 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 04 24 C1 F8 ?? 89 F1 89 
            44 24 ?? 8D B5 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 83 EC ?? 89 B5 ?? ?? ?? 
            ?? 89 85 ?? ?? ?? ?? 89 C3 A1 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 89 85 
            ?? ?? ?? ?? 8B 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B B5 ?? ?? ?? ?? 8B BD ?? ?? ?? ?? 89 
            04 24 89 54 24 ?? 89 74 24 ?? 89 7C 24 ?? E8 ?? ?? ?? ?? 8B B5 ?? ?? ?? ?? 8B BD ?? 
            ?? ?? ?? 89 95 ?? ?? ?? ?? 89 54 24 ?? 89 85 ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 89 
            7C 24 ?? 89 44 24 ?? 89 34 24 FF 95 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 83 EC ?? 89 5C 24 
            ?? C7 44 24 ?? ?? ?? ?? ?? 83 C3 ?? C7 44 24 ?? ?? ?? ?? ?? 89 34 24 89 44 24 ?? FF 
            95 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 83 EC ?? 39 C3 0F 85 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 
            C7 44 24 ?? ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 8D 76 ?? 81 BD ?? ?? 
            ?? ?? ?? ?? ?? ?? 0F 86 ?? ?? ?? ?? E9 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 
            E9 ?? ?? ?? ?? 89 54 24 ?? 89 44 24 ?? C7 44 24 ?? ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? 
            E8 ?? ?? ?? ?? 89 C6 C7 44 24 ?? ?? ?? ?? ?? 89 1C 24 E8 ?? ?? ?? ?? 89 34 24 E8 ?? 
            ?? ?? ?? 89 C3 8B 85 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 89 1C 24 E8 ?? ?? ?? ?? EB 
          }

        $remote_connection_p1 = {
            55 57 56 53 81 EC ?? ?? ?? ?? 8B 1A 39 18 0F 84 ?? ?? ?? ?? 89 54 24 ?? 89 C6 8D 5C 
            24 ?? F6 05 ?? ?? ?? ?? ?? 0F 85 ?? ?? ?? ?? B8 ?? ?? ?? ?? 89 DF 8B 56 ?? 89 54 24 
            ?? 8B 56 ?? 89 54 24 ?? 8B 56 ?? 89 54 24 ?? C7 44 24 ?? ?? ?? ?? ?? 89 44 24 ?? 89 
            3C 24 E8 ?? ?? ?? ?? 89 3C 24 E8 ?? ?? ?? ?? 01 C7 89 F8 29 D8 BA ?? ?? ?? ?? 89 D5 
            29 C5 F6 05 ?? ?? ?? ?? ?? 0F 85 ?? ?? ?? ?? 8B 06 89 44 24 ?? 8B 46 ?? 89 44 24 ?? 
            C7 44 24 ?? ?? ?? ?? ?? 89 6C 24 ?? 89 3C 24 E8 ?? ?? ?? ?? 89 5C 24 ?? 8B 7C 24 ?? 
            8B 07 89 04 24 E8 ?? ?? ?? ?? FF 47 ?? 8B 46 ?? 01 47 ?? 8B 6E ?? 85 ED 0F 84 ?? ?? 
            ?? ?? 89 6C 24 ?? 8D 44 24 ?? 89 04 24 E8 ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? E9 ?? 
            ?? ?? ?? 8D B6 ?? ?? ?? ?? 8D BC 27 ?? ?? ?? ?? 85 C0 74 ?? C6 03 ?? A8 ?? 0F 85 ?? 
            ?? ?? ?? 8B 7D ?? 8B 75 ?? 89 2C 24 E8 ?? ?? ?? ?? 89 7C 24 ?? 89 74 24 ?? 89 44 24 
            ?? C7 44 24 ?? ?? ?? ?? ?? B8 ?? ?? ?? ?? 8B 74 24 ?? 29 F0 89 44 24 ?? 8D 04 33 89 
            04 24 E8 ?? ?? ?? ?? 89 DF 8B 17 83 C7 ?? 8D 82 ?? ?? ?? ?? F7 D2 21 D0 25 ?? ?? ?? 
            ?? 74 ?? A9 ?? ?? ?? ?? 75 ?? C1 E8 ?? 83 C7 ?? 88 C1 00 C1 83 DF ?? 29 DF 8B 75
        }

        $remote_connection_p2 = {
            89 34 24 E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? 29 F9 39 C1 0F 8D ?? ?? ?? ?? 8D 04 3B 83 F9 
            ?? 0F 83 ?? ?? ?? ?? 85 C9 74 ?? 8A 16 88 10 F6 C1 ?? 0F 85 ?? ?? ?? ?? BA ?? ?? ?? 
            ?? B8 ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 89 54 24 ?? 01 D8 89 04 24 E8 ?? ?? ?? ?? 
            89 5C 24 ?? 8B 44 24 ?? 8B 00 89 04 24 E8 ?? ?? ?? ?? 8B 6D ?? 85 ED 74 ?? 8D 44 24 
            ?? 89 44 24 ?? 89 2C 24 E8 ?? ?? ?? ?? 85 C0 75 ?? FF 44 24 ?? 8B 44 24 ?? 83 F8 ?? 
            0F 82 ?? ?? ?? ?? C7 44 03 ?? ?? ?? ?? ?? 8D 48 ?? C1 E9 ?? 89 DF B8 ?? ?? ?? ?? F3 
            AB E9 ?? ?? ?? ?? 8D B6 ?? ?? ?? ?? 81 C4 ?? ?? ?? ?? 5B 5E 5F 5D C3 90 8D 74 26 ?? 
            8D 40 ?? 89 04 24 E8 ?? ?? ?? ?? 8B 10 89 54 24 ?? 8B 50 ?? 89 54 24 ?? 8B 40 ?? 89 
            44 24 ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 89 1C 24 E8 ?? ?? ?? ?? 89 
            DA 8B 0A 83 C2 ?? 8D 81 ?? ?? ?? ?? F7 D1 21 C8 25 ?? ?? ?? ?? 74 ?? A9
        }

        $remote_connection_p3 = { 
            75 ?? C1 E8 ?? 83 C2 ?? 88 C1 00 C1 83 DA ?? 29 DA 8D 3C 13 B8 ?? ?? ?? ?? 29 D0 E9 
            ?? ?? ?? ?? 8D B6 ?? ?? ?? ?? 8D BF ?? ?? ?? ?? B8 ?? ?? ?? ?? 29 F8 89 44 24 ?? 89 
            74 24 ?? 01 DF 89 3C 24 E8 ?? ?? ?? ?? 89 D8 8B 08 83 C0 ?? 8D 91 ?? ?? ?? ?? F7 D1 
            21 CA 81 E2 ?? ?? ?? ?? 74 ?? F7 C2 ?? ?? ?? ?? 75 ?? C1 EA ?? 83 C0 ?? 88 D1 00 D1 
            83 D8 ?? 29 D8 BA ?? ?? ?? ?? 29 C2 E9 ?? ?? ?? ?? 8D 74 26 ?? 8D BC 27 ?? ?? ?? ?? 
            8B 16 89 10 8B 54 0E ?? 89 54 08 ?? 8D 78 ?? 83 E7 ?? 29 F8 29 C6 01 C1 C1 E9 ?? F3 
            A5 E9 ?? ?? ?? ?? 8D B4 26 ?? ?? ?? ?? 8D BC 27 ?? ?? ?? ?? 89 54 24 ?? 8D 46 ?? 89 
            04 24 E8 ?? ?? ?? ?? 89 44 24 ?? C7 44 24 ?? ?? ?? ?? ?? 89 6C 24 ?? 89 3C 24 E8 ?? 
            ?? ?? ?? 89 3C 24 E8 ?? ?? ?? ?? 01 C7 89 F8 29 D8 8B 54 24 ?? 29 C2 89 D5 E9 ?? ?? 
            ?? ?? 8D B4 26 ?? ?? ?? ?? 8D BC 27 ?? ?? ?? ?? 8B 44 24 ?? 66 C7 44 03 ?? ?? ?? E9 
            ?? ?? ?? ?? 66 8B 54 0E ?? 66 89 54 08 ?? E9 ?? ?? ?? ?? 90 8B 54 24 ?? 8B 44 24 ?? 
            E9 
        }

    condition:
        uint16(0) == 0x5A4D and 
        (
            all of ($find_files_p*)
        ) and 
        (
            all of ($encrypt_files_p*)
        ) and 
        (
            all of ($remote_connection_p*)
        )     
}