rule Win32_Ransomware_Redeemer : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "REDEEMER"
        description         = "Yara rule that detects Redeemer ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Redeemer"
        tc_detection_factor = 5

    strings:

        $find_files = {
            8D 85 ?? ?? ?? ?? 50 56 FF 15 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 8B B5 ?? ?? ?? ?? 
            8B BD ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? C6 45 ?? ?? E8 ?? ?? ?? ?? 83 C6 ?? 89 B5 ?? ?? 
            ?? ?? 89 B5 ?? ?? ?? ?? 3B F7 0F 85 ?? ?? ?? ?? 83 BD ?? ?? ?? ?? ?? 0F 84 ?? ?? ?? 
            ?? 8B 3D ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 8D 8D ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 83 EC ?? 8D 85 ?? ?? ?? ?? 8B CC 89 A5 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 EC ?? 
            C6 45 ?? ?? 8D 85 ?? ?? ?? ?? 8B CC 50 E8 ?? ?? ?? ?? C6 45 ?? ?? E8 ?? ?? ?? ?? 83 
            C4 ?? 84 C0 0F 85 ?? ?? ?? ?? 83 EC ?? 8D 85 ?? ?? ?? ?? 8B CC 89 A5 ?? ?? ?? ?? 50 
            E8 ?? ?? ?? ?? 83 EC ?? C6 45 ?? ?? 8D 85 ?? ?? ?? ?? 8B CC 50 E8 ?? ?? ?? ?? C6 45 
            ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 84 C0 75 ?? 83 EC ?? 8D 85 ?? ?? ?? ?? 8B CC 89 A5 ?? 
            ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 EC ?? C6 45 ?? ?? 8D 85 ?? ?? ?? ?? 8B CC 50 E8 ?? ?? 
            ?? ?? C6 45 ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 84 C0 75 ?? 83 EC ?? 8D 85 ?? ?? ?? ?? 8B 
            CC 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 85 
            ?? ?? ?? ?? 50 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? 
            ?? 6A ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 8D 8D ?? ?? ?? ?? E8 
            ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 8B F0 
        }

        $encrypt_files_p1 = {
            80 FB ?? 0F 85 ?? ?? ?? ?? 83 EC ?? 8D 55 ?? 8B CC 89 A5 ?? ?? ?? ?? 68 ?? ?? ?? ?? 
            E8 ?? ?? ?? ?? 83 EC ?? C6 45 ?? ?? 8B CC C7 41 ?? ?? ?? ?? ?? C7 41 ?? ?? ?? ?? ?? 
            C7 41 ?? ?? ?? ?? ?? 83 79 ?? ?? C7 41 ?? ?? ?? ?? ?? 72 ?? 8B 01 EB ?? 8B C1 33 D2 
            6A ?? 66 89 10 8D 45 ?? 52 50 E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? C6 45 ?? ?? E8 ?? ?? ?? 
            ?? 83 C4 ?? 8B CC C7 41 ?? ?? ?? ?? ?? C7 41 ?? ?? ?? ?? ?? C7 41 ?? ?? ?? ?? ?? 83 
            79 ?? ?? C7 41 ?? ?? ?? ?? ?? 72 ?? 8B 01 EB ?? 8B C1 33 D2 6A ?? 66 89 10 8D 45 ?? 
            52 50 E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 8B F0 8D 45 ?? 3B C6 
            74 ?? 8B 45 ?? 83 F8 ?? 72 ?? 40 8D 4D ?? 50 FF 75 ?? E8 ?? ?? ?? ?? 33 C0 C7 45 ?? 
            ?? ?? ?? ?? 56 8D 4D ?? C7 45 ?? ?? ?? ?? ?? 66 89 45 ?? E8 ?? ?? ?? ?? C6 45
        }

        $encrypt_files_p2 = {
            8B 85 ?? ?? ?? ?? 83 F8 ?? 72 ?? 40 8D 8D ?? ?? ?? ?? 50 FF B5 ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 8B 35 ?? ?? ?? ?? 33 C0 83 7D ?? ?? 66 89 85 ?? ?? ?? ?? 8D 45 ?? 0F 43 45 ?? 
            50 C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? FF D6 85 C0 0F 85 ?? 
            ?? ?? ?? FF 15 ?? ?? ?? ?? 83 F8 ?? 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 ?? 8D 8D 
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 83 78 ?? ?? 72 ?? 8B 00 50 FF D6 8B 85 ?? ?? ?? 
            ?? 83 F8 ?? 72 ?? 40 8D 8D ?? ?? ?? ?? 50 FF B5 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 C7 
            85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 66 89 85 ?? ?? ?? ?? E9 ?? 
            ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 8D 45 ?? C6 45 ?? ?? 50 C7 45 ?? ?? ?? ?? ?? E8 ?? 
            ?? ?? ?? 8B 45 ?? 83 C4 ?? 83 F8 ?? 72 ?? 40 8D 4D ?? 50 FF 75 ?? E8 ?? ?? ?? ?? 33 
            C0 C7 45 ?? ?? ?? ?? ?? 8D 4D ?? C7 45 ?? ?? ?? ?? ?? 66 89 45 ?? E8 ?? ?? ?? ?? 8D 
            4D ?? E8 ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 8B 4D ?? 64 89 0D ?? ?? ?? ?? 59 5F 5E 
            5B 8B 4D ?? 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 E8
        }

        $modify_processes_p1 = {
            8D 85 ?? ?? ?? ?? 50 6A ?? 6A ?? 6A ?? 6A ?? FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8D 
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? C6 45 ?? ?? E8 ?? ?? ?? 
            ?? 68 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? C6 45 ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8D 
            ?? ?? ?? ?? C6 45 ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? C6 45 ?? ?? 
            E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? C6 45 ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? 
            ?? ?? 8D 8D ?? ?? ?? ?? C6 45 ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 
            C6 45 ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? C6 45 ?? ?? E8 ?? ?? ?? 
            ?? 68 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? C6 45 ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8D 
            ?? ?? ?? ?? C6 45 ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? C6 45 ?? ?? 
            E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? C6 45 ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? 
            ?? ?? 8D 8D ?? ?? ?? ?? C6 45 ?? ?? E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? C6 45 ?? ?? 50
        }

        $modify_processes_p2 = { 
            8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 
            ?? ?? ?? ?? 99 B9 ?? ?? ?? ?? F7 F9 6A ?? 8D 8D ?? ?? ?? ?? 6A ?? 8D 04 52 8D 04 C1 
            50 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 BD ?? ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 6A ?? 0F 
            43 85 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 83 BD ?? ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? 8D B5 
            ?? ?? ?? ?? 0F 43 95 ?? ?? ?? ?? 0F 43 B5 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 83 C8 ?? 
            50 56 FF 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 99 B9 ?? ?? ?? ?? F7 F9 6A ?? 8D 8D ?? ?? ?? 
            ?? 6A ?? 8D 04 52 8D 04 C1 50 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 EC ?? 8D 85 ?? ?? 
            ?? ?? 8B CC 89 A5 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 EC ?? C6 45 ?? ?? 8B CC FF 37 E8 
            ?? ?? ?? ?? C6 45 ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? C6 45 ?? ?? 8D 85 ?? ?? ?? ?? 68 ?? 
            ?? ?? ?? 6A ?? 6A ?? 50 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? C6 45 ?? ?? 8D 85 ?? ?? 
            ?? ?? 6A ?? 50 E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 8B 4D ?? 64 89 
            0D ?? ?? ?? ?? 59 5F 5E 8B 4D ?? 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 FF 77
        }

    condition:
        uint16(0) == 0x5A4D and 
        (
            $find_files
        ) and
        (
            all of ($encrypt_files_p*)
        ) and
        (
            all of ($modify_processes_p*)
        )
}