rule Win32_Ransomware_Sanwai : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "SANWAI"
        description         = "Yara rule that detects Sanwai ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Sanwai"
        tc_detection_factor = 5

    strings:

        $find_files = {
            55 8B EC 6A ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 83 EC ?? 53 56 57 A1 ?? ?? ?? ??
            33 C5 50 8D 45 ?? 64 A3 ?? ?? ?? ?? 89 55 ?? 8B D9 83 7B ?? ?? 8B F3 8B 45 ?? 8B 7D
            ?? 89 45 ?? 72 ?? 8B 33 8D 4E ?? 66 8B 06 83 C6 ?? 66 85 C0 75 ?? 2B F1 D1 FE 0F 84
            ?? ?? ?? ?? 3B 73 ?? 0F 85 ?? ?? ?? ?? 88 45 ?? 8D 55 ?? FF 75 ?? 8D 4D ?? C7 45 ??
            ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 8D 45 ?? C7 45 ?? ?? ?? ??
            ?? 50 8B CB E8 ?? ?? ?? ?? 8B 55 ?? 83 FA ?? 72 ?? 8B 4D ?? 8D 14 55 ?? ?? ?? ?? 8B
            C1 81 FA ?? ?? ?? ?? 72 ?? 8B 49 ?? 83 C2 ?? 2B C1 83 C0 ?? 83 F8 ?? 76 ?? FF 15 ??
            ?? ?? ?? 52 51 E8 ?? ?? ?? ?? 83 C4 ?? 83 7B ?? ?? 72 ?? 8B 1B 8B 75 ?? 57 56 53 E8
            ?? ?? ?? ?? 85 C0 75 ?? 8B 36 8B CF E8 ?? ?? ?? ?? 84 C0 74 ?? 57 56 E8 ?? ?? ?? ??
            85 C0 75 ?? 8B CF E8 ?? ?? ?? ?? 84 C0 75 ?? 33 C0 8B 4D ?? 64 89 0D ?? ?? ?? ?? 59
            5F 5E 5B 8B E5 5D C3 83 F8 ?? 75 ?? 8B 4D ?? D1 E9 F6 C1 ?? B9 ?? ?? ?? ?? 0F 45 C1
            8B 4D ?? 64 89 0D ?? ?? ?? ?? 59 5F 5E 5B 8B E5 5D C3 B8 ?? ?? ?? ?? 8B 4D ?? 64 89
            0D ?? ?? ?? ?? 59 5F 5E 5B 8B E5 5D C3
        }

        $import_key = {
            8D 44 24 ?? 50 6A ?? 6A ?? 6A ?? 8D 44 24 ?? 50 FF 74 24 ?? FF 15 ?? ?? ?? ?? 5E 85
            C0 75 ?? 50 FF 74 24 ?? FF 15 ?? ?? ?? ?? 32 C0 5F 8B 4C 24 ?? 33 CC E8 ?? ?? ?? ??
            83 C4 ?? C3 8B 44 24 ?? FF 74 24 ?? 8B 08 8B 40 ?? 89 47 ?? 8D 44 24 ?? 50 57 6A ??
            6A ?? 6A ?? FF 74 24 ?? 89 0F FF 15 ?? ?? ?? ?? FF 74 24 ?? FF 15 ?? ?? ?? ?? 6A ??
            FF 74 24 ?? FF 15 ?? ?? ?? ?? 8B 4C 24 ?? B0 ?? 5F 33 CC E8 ?? ?? ?? ?? 83 C4 ?? C3
        }

        $encrypt_files = {
            8B 01 3B 02 75 ?? 83 C1 ?? 83 C2 ?? 83 EE ?? 73 ?? 8A 01 3A 02 75 ?? 83 FE ?? 74 ??
            8A 41 ?? 3A 42 ?? 75 ?? 8A 41 ?? 3A 42 ?? 75 ?? 8A 41 ?? 3A 42 ?? 75 ?? 33 C0 EB ??
            1B C0 83 C8 ?? 85 C0 75 ?? 8B 5D ?? 8B 7D ?? C6 85 ?? ?? ?? ?? ?? E9 ?? ?? ?? ?? 8B
            BD ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 8B CF E8 ?? ?? ?? ?? 51 C6 45 ?? ?? 8D 4D ?? 8B
            9D ?? ?? ?? ?? 51 83 CB ?? 8B C8 89 9D ?? ?? ?? ?? E8 ?? ?? ?? ?? 81 CB ?? ?? ?? ??
            C7 45 ?? ?? ?? ?? ?? 8D 4D ?? 83 CB ?? 83 7D ?? ?? 89 9D ?? ?? ?? ?? 0F 43 4D ?? 83
            7D ?? ?? 89 9D ?? ?? ?? ?? 0F 85 ?? ?? ?? ?? BA ?? ?? ?? ?? BE ?? ?? ?? ?? 8B 01 3B
            02 75 ?? 83 C1 ?? 83 C2 ?? 83 EE ?? 73 ?? 8A 01 3A 02 75 ?? 83 FE ?? 74 ?? 8A 41 ??
            3A 42 ?? 75 ?? 8A 41 ?? 3A 42 ?? 75 ?? 8A 41 ?? 3A 42 ?? 75 ?? 33 C0 EB ?? 1B C0 83
            C8 ?? 85 C0 75 ?? 8B 5D ?? 8B 7D ?? C6 85 ?? ?? ?? ?? ?? E9 ?? ?? ?? ?? 8D 45 ?? 8B
            CF 50 E8 ?? ?? ?? ?? 51 8D 4D ?? C7 45 ?? ?? ?? ?? ?? 51 83 CB ?? 8B C8 89 9D ?? ??
            ?? ?? E8 ?? ?? ?? ?? 8B 7D ?? 8D 4D ?? 81 CB ?? ?? ?? ?? 89 9D ?? ?? ?? ?? 8B 5D ??
            83 FB ?? 0F 43 CF 83 7D ?? ?? 0F 85
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            $find_files
        ) and
        (
            $import_key
        ) and
        (
            $encrypt_files
        )
}