rule Win32_Ransomware_TechandStrat : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "TECHANDSTRAT"
        description         = "Yara rule that detects TechandStrat ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "TechandStrat"
        tc_detection_factor = 5

    strings:

        $enum_shares_p1 = {
            55 8B EC 83 EC ?? 53 56 57 8D 45 ?? C7 45 ?? ?? ?? ?? ?? 50 FF 75 ?? C7 45 ?? ?? ??
            ?? ?? 6A ?? 6A ?? 6A ?? FF 15 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? FF 75 ?? 6A ?? FF
            15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 8B D8 85 DB 74 ?? 8D 45 ?? 50 53 8D 45 ?? 50 FF
            75 ?? FF 15 ?? ?? ?? ?? 85 C0 75
        }

        $enum_shares_p2 = {
            8D 46 ?? B9 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? EB ?? FF 36 E8 ?? ?? ?? ?? 47 83 C6 ?? 3B
            7D ?? 72 ?? 8D 45 ?? 50 53 8D 45 ?? 50 FF 75 ?? FF 15 ?? ?? ?? ?? 85 C0 74 ?? 53 6A
            ?? FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? FF 75 ?? FF 15 ?? ?? ?? ?? 5F 5E 5B 8B E5
            5D C2
        }

        $find_files = {
            8B FF 55 8B EC 81 EC ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C5 89 45 ?? 8B 4D ?? 53 8B 5D ??
            56 8B 75 ?? 57 89 B5 ?? ?? ?? ?? EB ?? 8A 01 3C ?? 74 ?? 3C ?? 74 ?? 3C ?? 74 ?? 51
            53 E8 ?? ?? ?? ?? 59 59 8B C8 3B CB 75 ?? 8A 11 80 FA ?? 75 ?? 8D 43 ?? 3B C8 74 ??
            56 33 FF 57 57 53 E8 ?? ?? ?? ?? 83 C4 ?? EB ?? 33 FF 80 FA ?? 74 ?? 80 FA ?? 74 ??
            80 FA ?? 74 ?? 8B C7 EB ?? 33 C0 40 0F B6 C0 2B CB 41 F7 D8 68 ?? ?? ?? ?? 1B C0 23
            C1 89 85 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 57 50 E8 ?? ?? ?? ?? 83 C4 ?? 8D 85 ?? ?? ??
            ?? 57 57 57 50 57 53 FF 15 ?? ?? ?? ?? 8B F0 8B 85 ?? ?? ?? ?? 83 FE ?? 75 ?? 50 57
            57 53 E8 ?? ?? ?? ?? 83 C4 ?? 8B F8 83 FE ?? 74 ?? 56 FF 15 ?? ?? ?? ?? 8B C7 8B 4D
            ?? 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 8B 48 ?? 2B 08 C1 F9 ?? 89 8D ?? ?? ??
            ?? 80 BD ?? ?? ?? ?? ?? 75 ?? 8A 8D ?? ?? ?? ?? 84 C9 74 ?? 80 F9 ?? 75 ?? 80 BD ??
            ?? ?? ?? ?? 74 ?? 50 FF B5 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 53 50 E8 ?? ?? ?? ?? 83 C4
            ?? 85 C0 75 ?? 8D 85 ?? ?? ?? ?? 50 56 FF 15 ?? ?? ?? ?? 85 C0 8B 85 ?? ?? ?? ?? 75
            ?? 8B 10 8B 40 ?? 8B 8D ?? ?? ?? ?? 2B C2 C1 F8 ?? 3B C8 0F 84 ?? ?? ?? ?? 68 ?? ??
            ?? ?? 2B C1 6A ?? 50 8D 04 8A 50 E8 ?? ?? ?? ?? 83 C4 ?? E9 ?? ?? ?? ?? 8B FF 56 57
            8B F9 8B 37 EB ?? FF 36 E8 ?? ?? ?? ?? 59 83 C6 ?? 3B 77 ?? 75 ?? FF 37 E8 ?? ?? ??
            ?? 59 5F 5E C3
        }

        $encrypt_files_p1 = {
            55 8B EC 83 E4 ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 56 8B 75 ?? 8D 44 24 ?? 57 50 C6 44
            24 ?? ?? FF 36 FF 15 ?? ?? ?? ?? 6A ?? 8D 44 24 ?? 6A ?? 50 E8 ?? ?? ?? ?? 83 C4 ??
            8D 84 24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? 50 E8 ?? ?? ?? ?? 8B 4C 24 ?? 83 C4 ?? 8B
            44 24 ?? 81 E9 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 83 D8 ?? 6A ?? 6A ?? 50 51 FF 36 FF D7
            6A ?? 8D 44 24 ?? 50 68 ?? ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 50 FF 36 FF 15 ?? ?? ?? ??
            81 BC 24 ?? ?? ?? ?? ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B 4C 24 ?? 33
            D2 69 C0 ?? ?? ?? ?? 89 4C 24 ?? 8B 4C 24 ?? 89 8C 24 ?? ?? ?? ?? 83 C9 ?? 51 40 C7
            44 24 ?? ?? ?? ?? ?? F7 F1 8D 84 24 ?? ?? ?? ?? C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? 50
            C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? 89 54 24 ?? 89 94
            24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 51 8D 84 24 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8D 94 24 ??
            ?? ?? ?? 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F 10 84 24 ?? ?? ?? ?? 6A ?? 6A ?? 0F
            11 84 24 ?? ?? ?? ?? 0F 57 C0 66 0F 13 44 24 ?? 8B 44 24 ?? 50 89 44 24 ?? 8B 44 24
            ?? 50 FF 36 89 44 24 ?? FF D7 6A ?? 8D 44 24 ?? 0F 57 C0 50 68 ?? ?? ?? ?? 8D 84 24
            ?? ?? ?? ?? 66 0F 13 44 24 ?? 50 FF 36 FF 15 ?? ?? ?? ?? 8B 44 24 ?? 89 44 24 ?? 85
            C0 0F 84
        }

        $encrypt_files_p2 = {
            6A ?? 6A ?? FF 74 24 ?? 0F 11 84 24 ?? ?? ?? ?? FF 74 24 ?? FF 36 FF 15 ?? ?? ?? ??
            6A ?? 8D 44 24 ?? 50 FF 74 24 ?? 8D 84 24 ?? ?? ?? ?? 50 FF 36 FF 15 ?? ?? ?? ?? 8B
            84 24 ?? ?? ?? ?? 8B C8 85 C0 B8 ?? ?? ?? ?? 6A ?? 0F 44 C8 69 44 24 ?? ?? ?? ?? ??
            33 D2 6A ?? 40 89 44 24 ?? F7 F1 8B 4C 24 ?? 33 C0 83 C2 ?? 13 C0 01 54 24 ?? 13 C8
            8B 44 24 ?? 89 4C 24 ?? 0F A4 C1 ?? C1 E0 ?? 51 50 FF 36 89 4C 24 ?? 89 44 24 ?? FF
            15 ?? ?? ?? ?? 6A ?? 8D 44 24 ?? 50 68 ?? ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 50 FF 36 FF
            15 ?? ?? ?? ?? 8B 44 24 ?? 89 44 24 ?? 85 C0 0F 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 84
            24 ?? ?? ?? ?? 6A ?? 50 E8 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 83 C4 ?? C7 84 24 ?? ?? ??
            ?? ?? ?? ?? ?? 6A ?? 6A ?? FF D7 8B 35 ?? ?? ?? ?? 50 FF D6 6A ?? 6A ?? 89 44 24 ??
            FF D7 50 FF D6 6A ?? 6A ?? 89 44 24 ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ??
            ?? FF D7 50 FF D6 6A ?? 6A ?? 89 44 24 ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ??
            ?? ?? FF D7 50 FF D6
        }

        $encrypt_files_p3 = {
            6A ?? 6A ?? 66 0F 13 44 24 ?? FF 74 24 ?? FF 74 24 ?? FF 36 FF 15 ?? ?? ?? ?? 6A ??
            8D 44 24 ?? 50 68 ?? ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 50 FF 36 FF 15 ?? ?? ?? ?? C6 44
            24 ?? ?? FF 36 FF 15 ?? ?? ?? ?? 80 7C 24 ?? ?? 74 ?? 68 ?? ?? ?? ?? 6A ?? 83 C6 ??
            56 FF 15 ?? ?? ?? ?? 56 8D 84 24 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D
            84 24 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 50 56 FF 15 ?? ?? ?? ??
            8B 75 ?? 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 83 C4 ?? 6A ?? 68 ?? ?? ?? ?? FF 15
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            all of ($enum_shares_p*)
        ) and
        (
            $find_files
        ) and
        (
            all of ($encrypt_files_p*)
        )
}