rule Win32_Ransomware_TorrentLocker : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "TORRENTLOCKER"
        description         = "Yara rule that detects TorrentLocker ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "TorrentLocker"
        tc_detection_factor = 5

    strings:
      $tlocker_ep = {
          68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 74 05 E8 ?? ?? ?? ?? 33 C0 C3 
      }

      $tlocker_contact_server_1 = {
          55 8B EC 83 EC ?? 8D 45 ?? 50 8D 4D ?? 51 B8 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 74 21 83 7D 
          ?? ?? 8B 45 ?? 75 05 8B 10 89 55 ?? 85 C0 74 0F 50 A1 ?? ?? ?? ?? 6A ?? 50 FF 15 ?? ?? ?? ?? 53 56 57 8D 9B ?? ?? ?? ?? 
          8B 4D ?? 8D 55 ?? 52 6A ?? BB ?? ?? ?? ?? 89 4D ?? E8 ?? ?? ?? ?? 8B F0 83 C4 ?? 89 75 ?? 85 F6 0F 84 2C 01 00 00 8B BE 
          ?? ?? ?? ?? 81 C7 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 85 DB 0F 84 EB 00 00 00 6A ?? 68 ?? ?? ?? ?? 68 
          ?? ?? ?? ?? 6A ?? 6A ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 53 FF 15 ?? ?? ?? ?? 8B F0 85 F6 0F 84 89 00 00 00 8D 45 ?? 50 8D 
          4D ?? 51 6A ?? 56 C7 45 ?? ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 74 16 81 4D ?? ?? ?? ?? ?? 6A ?? 8D 55 ?? 52 6A ?? 56 FF 
          15 ?? ?? ?? ?? 8B 45 ?? 57 50 6A ?? 6A ?? 56 FF 15 ?? ?? ?? ?? 85 C0 74 38 6A ?? 8D 4D ?? 51 8D 55 ?? 52 68 ?? ?? ?? ?? 
          56 C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 74 10 81 7D ?? ?? ?? ?? ?? 75 07 C7 45 ?? ?? ?? ?? 
          ?? 8B 3D ?? ?? ?? ?? 56 FF D7 EB 06 8B 3D ?? ?? ?? ?? 8D 45 ?? 50 8D 4D ?? 51 6A ?? 53 C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? 
          ?? ?? ?? FF 15 ?? ?? ?? ?? 53 8B F0 FF D7 85 F6 74 06 8B 55 ?? 52 FF D7 8B 75 ?? 8B 0D ?? ?? ?? ?? 33 C0 83 7D ?? ?? 56 
          0F 94 C0 6A ?? 51 8B F8 FF 15 ?? ?? ?? ?? 85 FF 75 10 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? E9 9E FE FF FF 5F 5E 5B 8B E5 5D 
          C3 
      }

      $tlocker_contact_server_2_1 = {
          55 8B EC 83 EC ?? 8D 45 ?? 50 8D 4D ?? 51 B8 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 74 21 83 7D 
          ?? ?? 8B 45 ?? 75 05 8B 10 89 55 ?? 85 C0 74 0F 50 A1 ?? ?? ?? ?? 6A ?? 50 FF 15 ?? ?? ?? ?? 53 56 57 8D 9B ?? ?? ?? ?? 
          8B 4D ?? 8D 55 ?? 52 6A ?? BF ?? ?? ?? ?? 89 4D ?? E8 ?? ?? ?? ?? 8B F0 83 C4 ?? 89 75 ?? 85 F6 0F 84 E5 01 00 00 BF ?? 
          ?? ?? ?? 39 3D ?? ?? ?? ?? 74 11 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 89 3D ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B 
          9E ?? ?? ?? ?? 81 C3 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 85 FF 0F 84 EB 00 00 00 6A ?? 68 ?? ?? ?? ?? 
          68 ?? ?? ?? ?? 6A ?? 6A ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 57 FF 15 ?? ?? ?? ?? 8B F0 85 F6 0F 84 89 00 00 00 8D 45 ?? 50 
          8D 4D ?? 51 6A ?? 56 C7 45 ?? ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 74 16 81 4D ?? ?? ?? ?? ?? 6A ?? 8D 55 ?? 52 6A ?? 56 
          FF 15 ?? ?? ?? ?? 8B 45 ?? 53 50 6A ?? 6A ?? 56 FF 15 ?? ?? ?? ?? 85 C0 74 38 6A ?? 8D 4D ?? 51 8D 55 ?? 52 68 ?? ?? ?? 
          ?? 56 C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 74 10 81 7D ?? ?? ?? ?? ?? 75 07 C7 45 ?? ?? ?? 
          ?? ?? 56 8B 35 ?? ?? ?? ?? FF D6 EB 06 8B 35 ?? ?? ?? ?? 8D 45 ?? 50 8D 4D ?? 51 6A ?? 57 C7 45 ?? ?? ?? ?? ?? C7 45 ??
      }

      $tlocker_contact_server_2_2 = { 
          ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 57 8B D8 FF D6 85 DB 74 06 8B 55 ?? 52 FF D6 8B 75 ?? 33 C0 83 7D ?? ?? 0F 94 C0 8B F8 85 
          FF 74 18 8B 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? EB 5E 8B 15 ?? ?? ?? ?? 3B 15 ?? ?? ?? ?? 75 
          34 FF 15 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 8B D1 41 89 0D ?? ?? ?? ?? 85 D2 7E 71 8B 0D ?? ?? ?? ?? 3B C1 73 08 8B C8 89 0D 
          ?? ?? ?? ?? 2B C1 3D ?? ?? ?? ?? 72 1C A1 ?? ?? ?? ?? 40 83 F8 ?? 7E 05 A1 ?? ?? ?? ?? 8B C8 A3 ?? ?? ?? ?? E8 ?? ?? ?? 
          ?? 81 3D ?? ?? ?? ?? ?? ?? ?? ?? 75 0B 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 56 6A ?? 50 FF 15 ?? ?? ?? ?? 85 
          FF 75 17 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? E9 E5 FD FF FF A3 ?? ?? ?? ?? EB BF 5F 5E 5B 8B E5 5D C3 
      }

      $tlocker_get_server_data = {
          55 8B EC 83 EC ?? 56 57 33 FF 57 57 8D 45 ?? 50 53 33 F6 FF 15 ?? ?? ?? ?? 85 C0 74 77 8D 49 ?? 8B 4D ?? 03 CF 85 F6 75 
          73 33 C0 85 C9 74 0F 8B 15 ?? ?? ?? ?? 51 50 52 FF 15 ?? ?? ?? ?? 33 C9 85 C0 0F 95 C1 8B F0 8B C1 85 C0 74 33 8B 55 ?? 
          8D 4D ?? 51 52 8D 04 37 50 53 FF 15 ?? ?? ?? ?? 85 C0 74 1C 8B 45 ?? 85 C0 74 ?? 6A ?? 6A ?? 8D 4D ?? 51 53 03 F8 FF 15 
          ?? ?? ?? ?? 85 C0 75 A0 85 F6 74 10 8B 0D ?? ?? ?? ?? 56 6A ?? 51 FF 15 ?? ?? ?? ?? 5F 33 C0 5E 8B E5 5D C3 
      }

      $tlocker_remove_shadow_copies = {
          55 8B EC 81 EC ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C5 89 45 ?? A1 ?? ?? ?? ?? 53 57 6A ?? 33 FF 57 50 FF 15 ?? ?? ?? ?? 8B D8 
          3B DF 0F 84 DC 00 00 00 56 8D B5 ?? ?? ?? ?? 89 BD ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0A C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 
          68 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 3D ?? ?? ?? ?? 73 5E B8 ?? ?? ?? ?? 8B D3 2B D0 0F B7 08 66 89 0C 
          02 83 C0 ?? 66 3B CF 75 F1 6A ?? 8D 95 ?? ?? ?? ?? 57 52 E8 ?? ?? ?? ?? 83 C4 ?? 8D 85 ?? ?? ?? ?? 50 8D 8D ?? ?? ?? ?? 
          51 8D 95 ?? ?? ?? ?? 52 57 68 ?? ?? ?? ?? 57 57 57 53 57 C7 85 ?? ?? ?? ?? ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 75 0F FF 
          15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B F8 83 BD ?? ?? ?? ?? ?? 74 0B 8B B5 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 53 
          6A ?? 50 FF 15 ?? ?? ?? ?? 5E 8B C7 5F 5B 8B 4D ?? 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 8B 4D ?? 5F 33 CD B8 ?? ?? ?? ?? 5B 
          E8 ?? ?? ?? ?? 8B E5 5D C3 
      }

      $tlocker_find_files = {
          55 8B EC 81 EC ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C5 89 45 ?? 8B 0D ?? ?? ?? ?? 8B 45 ?? 53 56 57 68 ?? ?? ?? ?? 33 F6 56 51 
          89 85 ?? ?? ?? ?? 89 B5 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B D8 85 DB 0F 84 AD 01 00 00 53 56 56 6A ?? 56 FF 15 ?? ?? ?? ?? 
          85 C0 0F 88 89 01 00 00 68 ?? ?? ?? ?? 53 53 FF 15 ?? ?? ?? ?? 8B C3 8D 50 ?? 8D 9B ?? ?? ?? ?? 66 8B 08 83 C0 ?? 66 85 
          C9 75 F5 2B C2 D1 F8 8B F8 E8 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 85 C0 0F 84 4D 01 00 00 8D 95 ?? ?? ?? ?? 52 50 FF 15 ?? ?? 
          ?? ?? 89 85 ?? ?? ?? ?? 85 C0 0F 84 15 01 00 00 F6 85 ?? ?? ?? ?? ?? 0F 84 EC 00 00 00 B9 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 
          66 8B 10 66 3B 11 75 1E 66 85 D2 74 15 66 8B 50 ?? 66 3B 51 ?? 75 0F 83 C0 ?? 83 C1 ?? 66 85 D2 75 DE 33 C0 EB 05 1B C0 
          83 D8 ?? 85 C0 0F 84 AE 00 00 00 B9 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 66 8B 10 66 3B 11 75 1E 66 85 D2 74 15 66 8B 50 ?? 66 
          3B 51 ?? 75 0F 83 C0 ?? 83 C1 ?? 66 85 D2 75 DE 33 C0 EB 05 1B C0 83 D8 ?? 85 C0 74 74 8D 85 ?? ?? ?? ?? 8D 50 ?? 8B FF 
          66 8B 08 83 C0 ?? 66 85 C9 75 F5 2B C2 D1 F8 03 C7 8D 44 00 ?? 85 C0 74 6C 50 A1 ?? ?? ?? ?? 6A ?? 50 FF 15 ?? ?? ?? ?? 
          8B F0 85 F6 74 57 53 8D 4F ?? 51 56 E8 ?? ?? ?? ?? 83 C4 ?? 8D 95 ?? ?? ?? ?? 52 56 56 FF 15 ?? ?? ?? ?? 8B 85 ?? ?? ?? 
          ?? 50 56 E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 74 0A C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 51 52 FF 
          15 ?? ?? ?? ?? 85 C0 0F 85 EB FE FF FF 8B 85 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 50 6A ?? 51 FF 15 ?? ?? ?? ?? 8B B5 ?? ?? ?? 
          ?? 8B 15 ?? ?? ?? ?? 53 6A ?? 52 FF 15 ?? ?? ?? ?? 8B 4D ?? 5F 8B C6 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 
      }
        
    condition:
        uint16(0) == 0x5A4D and
        (($tlocker_ep and $tlocker_get_server_data and $tlocker_remove_shadow_copies and $tlocker_find_files) and
        ($tlocker_contact_server_1 or ($tlocker_contact_server_2_1 and $tlocker_contact_server_2_2)))
}