rule Win32_Ransomware_Xorist : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "XORIST"
        description         = "Yara rule that detects Xorist ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Xorist"
        tc_detection_factor = 5

    strings:

        $search_and_encrypt_v1_p1 = {
            55 8B EC 81 EC ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 40 0F 
            84 ?? ?? ?? ?? 48 89 45 ?? 8B 85 ?? ?? ?? ?? 83 E0 ?? 0F 84 ?? ?? ?? ?? 8D 85 ?? ?? 
            ?? ?? 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 
            68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 
            2D ?? ?? ?? ?? 50 C6 80 ?? ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 80 ?? ?? ?? ?? ?? ?? ?? ?? C6 80 ?? ?? ?? ?? 
            ?? E8 ?? ?? ?? ?? 58 C7 80 ?? ?? ?? ?? ?? ?? ?? ?? C6 80 ?? ?? ?? ?? ?? E9 ?? ?? ?? 
            ?? E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 84 ?? 
            ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 
            8D 85 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? 
            ?? ?? E8 ?? ?? ?? ?? 2D ?? ?? ?? ?? C6 80 ?? ?? ?? ?? ?? A0 ?? ?? ?? ?? 3C ?? 75 ?? 
            68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 9D ?? ?? ?? ?? 53 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 80 
        }

        $search_and_encrypt_v1_p2 = {
            3D ?? ?? ?? ?? ?? 75 ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 F8 ?? 74 ?? 
            E9 ?? ?? ?? ?? EB ?? 8B 3D ?? ?? ?? ?? 8B 0F 83 C7 ?? 51 57 68 ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 8B D8 57 E8 ?? ?? ?? ?? 03 F8 47 59 83 FB ?? 74 ?? 49 75 ?? E9 ?? ?? ?? ?? 68 
            ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? ?? 75 ?? 68 ?? ?? ?? ?? 
            68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 35 ?? 
            ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB ?? 80 3D ?? ?? ?? ?? ?? 75 ?? 68 ?? ?? ?? 
            ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? C6 00 ?? EB ?? 68 ?? 
            ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A ?? 6A ?? 6A ?? 6A ?? 6A ?? 68 ?? ?? ?? ?? 
            68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 40 85 C0 0F 84 ?? ?? ?? ?? 48 A3 ?? ?? ?? ?? 6A ?? FF 
        }

        $search_and_encrypt_v1_p3 = {
            35 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 F8 ?? 7D ?? FF 35 ?? ?? ?? ?? E8 ?? 
            ?? ?? ?? E9 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 35 ?? ?? ?? 
            ?? E8 ?? ?? ?? ?? 6A ?? 6A ?? FF 35 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 
            ?? 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? 
            ?? 83 3D ?? ?? ?? ?? ?? 75 ?? E9 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8A 10 B9 
            ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? AC 32 C2 D0 C2 AA E2 ?? A1 ?? ?? ?? ?? 80 
            3D ?? ?? ?? ?? ?? 75 ?? E8 ?? ?? ?? ?? EB ?? 80 3D ?? ?? ?? ?? ?? 75 ?? E8 ?? ?? ?? 
            ?? EB ?? E8 ?? ?? ?? ?? 6A ?? 6A ?? FF 35 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? 
            ?? 6A ?? 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? E8 ?? 
            ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? 
            ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 
            85 ?? ?? ?? ?? 50 FF 75 ?? E8 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? FF 75 ?? E8 ?? ?? 
            ?? ?? C9 C3
        }

        $extract_rsrc_v1 = {
            55 8B EC 83 C4 ?? B9 ?? ?? ?? ?? BF ?? ?? ?? ?? 51 57 0F 31 5F 59 25 ?? ?? ?? ?? C1 
            E8 ?? 83 C0 ?? AA E2 ?? 33 C0 AA 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? 
            ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 
            6A ?? 68 ?? ?? ?? ?? 6A ?? E8 ?? ?? ?? ?? 0B C0 75 ?? C9 C3 89 45 ?? 50 6A ?? E8 ?? 
            ?? ?? ?? 0B C0 75 ?? C9 C3 89 45 ?? FF 75 ?? 6A ?? E8 ?? ?? ?? ?? 0B C0 75 ?? C9 C3 
            89 45 ?? 50 E8 ?? ?? ?? ?? 0B C0 75 ?? C9 C3 89 45 ?? 8B D8 6A ?? 6A ?? 6A ?? 6A ?? 
            6A ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 F8 ?? 74 ?? 89 45 ?? 6A ?? 6A 
            ?? 6A ?? FF 75 ?? E8 ?? ?? ?? ?? 6A ?? 8D 45 ?? 50 FF 75 ?? 53 FF 75 ?? E8 ?? ?? ?? 
            ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 75 ?? E8 ?? ?? ?? ?? FF 75 ?? E8 
            ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 6A ?? E8 ?? ?? ?? ?? FF 75 ?? E8 ?? ?? ?? ?? 
            C9 C3
        }

        $search_and_encrypt_v2_p1 = {
            55 8B EC 81 EC ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 40 0F 
            84 ?? ?? ?? ?? 48 89 45 ?? 8B 85 ?? ?? ?? ?? 83 E0 ?? 0F 84 ?? ?? ?? ?? 8D 85 ?? ?? 
            ?? ?? 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 
            68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 
            2D ?? ?? ?? ?? 50 C6 80 ?? ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 80 ?? ?? ?? ?? ?? ?? ?? ?? C6 80 ?? ?? ?? ?? 
            ?? E8 ?? ?? ?? ?? 58 C7 80 ?? ?? ?? ?? ?? ?? ?? ?? C6 80 ?? ?? ?? ?? ?? E9 ?? ?? ?? 
            ?? E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 84 ?? 
            ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 
            68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 2D ?? ?? ?? ?? C6 80 ?? ?? ?? ?? ?? A0 ?? ?? ?? ?? 3C 
            ?? 75 ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 9D ?? ?? ?? ?? 53 68 ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 80 3D ?? ?? ?? ?? ?? 75 ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 F8 
            ?? 74 ?? E9 ?? ?? ?? ?? EB ?? 8B 3D ?? ?? ?? ?? 8B 0F 83 C7 ?? 51 57 68
        }

        $search_and_encrypt_v2_p2 = {
            E8 ?? ?? ?? ?? 8B D8 57 E8 ?? ?? ?? ?? 03 F8 47 59 83 FB ?? 74 ?? 49 75 ?? E9 ?? ??
            ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? ?? 75 ?? 68 ?? 
            ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 
            FF 35 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB ?? 80 3D ?? ?? ?? ?? ?? 75 ?? 68 
            ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? C6 00 ?? 6A 
            ?? 6A ?? 6A ?? 6A ?? 6A ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 40 85 C0 0F 
            84 ?? ?? ?? ?? 48 A3 ?? ?? ?? ?? 6A ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? 
            ?? 83 F8 ?? 7D ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 
            ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A ?? 6A ?? FF 35 ?? ?? 
            ?? ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 35 
            ?? ?? ?? ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? ?? 75 ?? EB ?? 68 ?? 
            ?? ?? ?? E8 ?? ?? ?? ?? 8A 10 B9 ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? AC 32 C2 
            D0 C2 AA E2 ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A ?? 6A ?? FF 35 ?? ?? ?? ?? FF 35 ?? 
            ?? ?? ?? E8 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 
            35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 35 ?? 
            ?? ?? ?? E8 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? 
            ?? E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 FF 75 ?? E8 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? 
            ?? FF 75 ?? E8 ?? ?? ?? ?? C9 C3
        }

        $extract_rsrc_v2 = {
            55 8B EC 83 C4 ?? 53 6A ?? 6A ?? 6A ?? E8 ?? ?? ?? ?? 0B C0 75 ?? E9 ?? ?? ?? ?? 89 
            45 ?? 50 6A ?? E8 ?? ?? ?? ?? 0B C0 75 ?? E9 ?? ?? ?? ?? 89 45 ?? FF 75 ?? 6A ?? E8 
            ?? ?? ?? ?? 0B C0 75 ?? E9 ?? ?? ?? ?? 89 45 ?? 50 E8 ?? ?? ?? ?? 0B C0 75 ?? E9 ?? 
            ?? ?? ?? 89 45 ?? 8B F8 6A ?? 57 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C7 ?? 8B 45 ?? 83 
            E8 ?? 50 57 E8 ?? ?? ?? ?? 8B 1F 83 C7 ?? 53 6A ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 
            0B C0 75 ?? E9 ?? ?? ?? ?? A3 ?? ?? ?? ?? 53 57 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 03 
            FB 8B 1F 83 C7 ?? 53 6A ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0B C0 75 ?? E9 ?? ?? ?? 
            ?? A3 ?? ?? ?? ?? 53 57 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 03 FB 8B 1F 83 C7 ?? 53 6A 
            ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0B C0 75 ?? E9 ?? ?? ?? ?? A3 ?? ?? ?? ?? 53 57 
            FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 03 FB 6A ?? 57 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C7 
            ?? 6A ?? 57 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C7 ?? 6A ?? 57 68 ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 83 C7 ?? 6A ?? 57 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C7 ?? 6A ?? 57 68 ?? ?? ?? 
            ?? E8 ?? ?? ?? ?? 83 C7 ?? 6A ?? 57 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C7 ?? 6A ?? 57 
            68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C7 ?? 6A ?? 57 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C7 
            ?? FF 75 ?? E8 ?? ?? ?? ?? 5B C9 C3
        }

    condition:
        uint16(0) == 0x5A4D and
        ( 
            (
                $extract_rsrc_v1
            ) and 
            (
                all of ($search_and_encrypt_v1_p*)
            )
        ) or
        (
            (
                $extract_rsrc_v2
            ) and
            (
                all of ($search_and_encrypt_v2_p*)
            )
        )
}