rule Win64_Ransomware_Curator : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "CURATOR"
        description         = "Yara rule that detects Curator ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Curator"
        tc_detection_factor = 5

    strings:

        $encrypt_files_p1 = {
            44 8B CB C7 44 24 ?? ?? ?? ?? ?? 45 33 C0 48 8D 8D ?? ?? ?? ?? 33 D2 FF 15 ?? ?? ??
            ?? 48 8B BD ?? ?? ?? ?? 4C 8D 35 ?? ?? ?? ?? 48 85 FF 0F 84 ?? ?? ?? ?? 48 8B 0D ??
            ?? ?? ?? 41 8B DC 48 81 C1 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 7E ?? 45 33 F6 48 8B
            05 ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? BA ?? ?? ?? ?? 41 0F BE 8C 06 ?? ?? ?? ?? 45 0F
            BE 8C 06 ?? ?? ?? ?? 89 4C 24 ?? 48 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 D2 48 8D 8D
            ?? ?? ?? ?? 44 8D 42 ?? E8 ?? ?? ?? ?? 8B CB 4D 8D 76 ?? FF C3 41 83 C4 ?? 88 84 0D
            ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? 48 81 C1 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 44 3B E0 7C
            ?? 4C 8D 35 ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 45 33 E4 48 89 44 24 ?? 48 8D 95 ?? ??
            ?? ?? 45 33 C9 44 89 64 24 ?? 44 8B C3 48 8B CF FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ??
            ?? ?? 48 8B 1D ?? ?? ?? ?? 48 8D 4C 24 ?? 48 8B 15 ?? ?? ?? ?? 4C 8B C3 E8 ?? ?? ??
            ?? 48 8B 8D ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 45 8D 44 24 ??
            48 89 44 24 ?? 45 33 C9 48 8D 44 24 ?? 89 9D ?? ?? ?? ?? 33 D2 48 89 44 24 ?? FF 15
            ?? ?? ?? ?? 85 C0 74 ?? 41 8B DC 44 39 A5 ?? ?? ?? ?? 76 ?? 8B C3 4C 8D 05 ?? ?? ??
            ?? BA ?? ?? ?? ?? 48 8D 8D ?? ?? ?? ?? 44 0F B6 4C 04 ?? E8 ?? ?? ?? ?? 48 8D 95 ??
            ?? ?? ?? 49 8B CE FF 15 ?? ?? ?? ?? FF C3 3B 9D ?? ?? ?? ?? 72 ?? 48 8B 8D ?? ?? ??
            ?? FF 15 ?? ?? ?? ?? 33 D2 48 8B CF FF 15 ?? ?? ?? ?? B9
        }

        $encrypt_files_p2 = {
            48 8B C4 48 89 58 ?? 48 89 70 ?? 48 89 78 ?? 55 41 54 41 55 41 56 41 57 48 8D A8 ??
            ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 2B E0 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89
            85 ?? ?? ?? ?? 45 33 E4 C7 44 24 ?? ?? ?? ?? ?? 41 B8 ?? ?? ?? ?? 44 89 25 ?? ?? ??
            ?? 48 8D 95 ?? ?? ?? ?? 44 89 25 ?? ?? ?? ?? 33 C9 44 89 25 ?? ?? ?? ?? 45 8B FC 4C
            89 25 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8D 8D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 63 C8
            48 8D 85 ?? ?? ?? ?? 48 8D 04 48 48 83 C0 ?? 66 83 38 ?? 75 ?? 66 44 89 20 4C 8D 05
            ?? ?? ?? ?? 48 83 C0 ?? 4C 89 64 24 ?? 48 89 05 ?? ?? ?? ?? 45 33 C9 48 8D 05 ?? ??
            ?? ?? 44 89 64 24 ?? 33 D2 48 89 05 ?? ?? ?? ?? 33 C9 FF 15 ?? ?? ?? ?? 33 D2 33 C9
            44 8D 42 ?? FF 15 ?? ?? ?? ?? 48 8B F0 48 85 C0 74 ?? 48 8B 1D ?? ?? ?? ?? 48 81 C3
            ?? ?? ?? ?? EB ?? 48 8B CB FF 15 ?? ?? ?? ?? 41 B8 ?? ?? ?? ?? 48 8B D3 48 8B CE 44
            8B F0 FF 15 ?? ?? ?? ?? 48 8B F8 48 85 C0 74 ?? 4C 8D 85 ?? ?? ?? ?? BA ?? ?? ?? ??
            48 8B C8 FF 15 ?? ?? ?? ?? 48 8B CF FF 15 ?? ?? ?? ?? 41 8D 46
        }

        $find_files = {
            48 89 5C 24 ?? 48 89 7C 24 ?? 55 48 8D AC 24 ?? ?? ?? ?? 48 81 EC ?? ?? ?? ?? 48 8B
            05 ?? ?? ?? ?? 48 33 C4 48 89 85 ?? ?? ?? ?? 48 8B F9 4C 8D 05 ?? ?? ?? ?? 4C 8B C9
            BA ?? ?? ?? ?? 48 8D 8D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8D 54 24 ?? 48 8D 8D ?? ??
            ?? ?? FF 15 ?? ?? ?? ?? 48 8B D8 48 83 F8 ?? 0F 84 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ??
            48 8D 4C 24 ?? FF 15 ?? ?? ?? ?? 85 C0 74 ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 ?? FF
            15 ?? ?? ?? ?? 85 C0 74 ?? 48 8D 44 24 ?? 4C 8B CF 4C 8D 05 ?? ?? ?? ?? 48 89 44 24
            ?? BA ?? ?? ?? ?? 48 8D 8D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? F6 44 24 ?? ?? 48 8D 8D ??
            ?? ?? ?? 74 ?? 48 8D 15 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8D 8D ?? ?? ?? ?? E8 ?? ??
            ?? ?? EB ?? FF 15 ?? ?? ?? ?? 48 8D 54 24 ?? 48 8B CB FF 15 ?? ?? ?? ?? 85 C0 0F 85
            ?? ?? ?? ?? 48 8B CB FF 15 ?? ?? ?? ?? 48 8B CF FF 15 ?? ?? ?? ?? 48 8B 8D ?? ?? ??
            ?? 48 33 CC E8 ?? ?? ?? ?? 4C 8D 9C 24 ?? ?? ?? ?? 49 8B 5B ?? 49 8B 7B ?? 49 8B E3
            5D C3
        }

        $remote_connection = {
            44 0F B7 45 ?? 33 DB 48 8B 55 ?? 45 33 C9 48 89 5C 24 ?? 48 8B CE 89 5C 24 ?? C7 44
            24 ?? ?? ?? ?? ?? 48 89 5C 24 ?? FF 15 ?? ?? ?? ?? 4C 8B F0 48 85 C0 0F 84 ?? ?? ??
            ?? 80 7D ?? ?? B9 ?? ?? ?? ?? 4C 8B 45 ?? B8 ?? ?? ?? ?? 48 8B 55 ?? 0F 44 C8 48 89
            5C 24 ?? 45 33 C9 89 4C 24 ?? 89 4D ?? 49 8B CE 48 89 5C 24 ?? 48 89 5C 24 ?? FF 15
            ?? ?? ?? ?? 48 8B D8 48 85 C0 0F 84 ?? ?? ?? ?? 83 65 ?? ?? 4C 8D 4D ?? 4C 8D 45 ??
            C7 45 ?? ?? ?? ?? ?? BA ?? ?? ?? ?? 48 8B C8 FF 15 ?? ?? ?? ?? 85 C0 74 ?? 81 4D ??
            ?? ?? ?? ?? 4C 8D 45 ?? 41 B9 ?? ?? ?? ?? 48 8B CB 41 8D 51 ?? FF 15 ?? ?? ?? ?? 4C
            8B 4D ?? 48 8B C7 48 F7 D8 48 8B D7 8B 45 ?? 48 8B CB 45 1B C0 89 44 24 ?? FF 15 ??
            ?? ?? ?? 85 C0 74 ?? 33 FF 83 65 ?? ?? 48 8D 55 ?? 45 33 C9 45 33 C0 48 8B CB FF 15
            ?? ?? ?? ?? 85 C0 74 ?? 8B 55 ?? 49 8B CF 03 D7 E8 ?? ?? ?? ?? 44 8B 45 ?? 4C 8D 4D
            ?? 8B D7 48 8B CB 48 03 D0 4C 8B F8 FF 15 ?? ?? ?? ?? 8B 45 ?? 03 F8 EB ?? 8B 45
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            $find_files
        ) and
        (
            all of ($encrypt_files_p*)
        ) and
        (
            $remote_connection
        )
}