rule Win64_Ransomware_HermeticRansom : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "HERMETICRANSOM"
        description         = "Yara rule that detects HermeticRansom ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "HermeticRansom"
        tc_detection_factor = 5

    strings:

        $drop_ransom_note = {
            65 48 8B 0C 25 ?? ?? ?? ?? 48 8B 89 ?? ?? ?? ?? 48 8D 84 24 ?? ?? ?? ?? 48 3B 41 ??
            0F 86 ?? ?? ?? ?? 48 81 EC ?? ?? ?? ?? 48 89 AC 24 ?? ?? ?? ?? 48 8D AC 24 ?? ?? ??
            ?? E8 ?? ?? ?? ?? 0F 10 04 24 0F 11 44 24 ?? 0F 10 44 24 ?? 0F 11 44 24 ?? 0F 10 44
            24 ?? 0F 11 04 24 E8 ?? ?? ?? ?? 48 8B 44 24 ?? 48 8B 4C 24 ?? 48 8D BC 24 ?? ?? ??
            ?? 48 8D 35 ?? ?? ?? ?? 48 89 6C 24 ?? 48 8D 6C 24 ?? E8 ?? ?? ?? ?? 48 8B 6D ?? 48
            89 8C 24 ?? ?? ?? ?? 48 89 84 24 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 8B 0D ?? ?? ??
            ?? 48 89 8C 24 ?? ?? ?? ?? 48 89 84 24 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 8B 0D ??
            ?? ?? ?? 48 89 84 24 ?? ?? ?? ?? 48 89 8C 24 ?? ?? ?? ?? 48 C7 04 24 ?? ?? ?? ?? 48
            8D 84 24 ?? ?? ?? ?? 48 89 44 24 ?? 48 C7 44 24 ?? ?? ?? ?? ?? 48 C7 44 24 ?? ?? ??
            ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 ?? 48 89 44 24 ?? 48 8B 4C 24 ?? 48 89 8C 24 ?? ??
            ?? ?? 48 8D 15 ?? ?? ?? ?? 48 89 14 24 48 C7 44 24 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 48
            8B 44 24 ?? 48 8B 4C 24 ?? 48 8D 94 24 ?? ?? ?? ?? 48 89 14 24 48 89 4C 24 ?? 48 89
            44 24 ?? 48 8D 05 ?? ?? ?? ?? 48 89 44 24 ?? 48 C7 44 24 ?? ?? ?? ?? ?? E8 ?? ?? ??
            ?? 48 8B 44 24 ?? 48 8B 4C 24 ?? 48 C7 04 24 ?? ?? ?? ?? 48 89 44 24 ?? 48 89 4C 24
            ?? 48 8D 05 ?? ?? ?? ?? 48 89 44 24 ?? 48 C7 44 24 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 48
            8B 44 24 ?? 48 8B 4C 24 ?? 48 89 0C 24 48 89 44 24 ?? 48 C7 44 24 ?? ?? ?? ?? ?? C7
            44 24 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 ?? 48 89 84 24 ?? ?? ?? ?? 48 8B 4C
            24 ?? 48 89 8C 24 ?? ?? ?? ?? 48 89 44 24 ?? C7 04 24 ?? ?? ?? ?? 48 8D 15 ?? ?? ??
            ?? 48 89 54 24 ?? E8 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 48 8B 84 24 ?? ?? ?? ?? 48
        }

        $encrypt_files_p1 = {
            E8 ?? ?? ?? ?? 48 8B 44 24 ?? 48 89 84 24 ?? ?? ?? ?? 48 8B 4C 24 ?? 48 89 8C 24 ??
            ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 8B 35 ?? ?? ?? ?? 48 89 14 24
            48 89 74 24 ?? 48 89 5C 24 ?? 48 8D 15 ?? ?? ?? ?? 48 89 54 24 ?? 48 C7 44 24 ?? ??
            ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 89 5C 24 ?? 48 89 54 24 ?? E8
            ?? ?? ?? ?? 48 8B 44 24 ?? 48 8B 4C 24 ?? 48 8B 54 24 ?? 48 8B 9C 24 ?? ?? ?? ?? 48
            85 DB 0F 85 ?? ?? ?? ?? 48 89 44 24 ?? 48 89 4C 24 ?? 48 89 94 24 ?? ?? ?? ?? 48 8D
            05 ?? ?? ?? ?? 48 89 04 24 48 C7 44 24 ?? ?? ?? ?? ?? 48 C7 44 24 ?? ?? ?? ?? ?? E8
            ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 04 24 48 8B 44 24 ?? 48 89 C1 48 C1 F8 ?? 48
            C1 E8 ?? 48 01 C8 48 C1 F8 ?? 48 89 84 24 ?? ?? ?? ?? 48 C1 E0 ?? 48 29 C1 48 89 4C
            24 ?? 48 89 4C 24 ?? E8 ?? ?? ?? ?? 48 8B 84 24 ?? ?? ?? ?? 48 89 04 24 0F 57 C0 0F
            11 44 24 ?? E8 ?? ?? ?? ?? 48 8B 84 24 ?? ?? ?? ?? 48 83 F8 ?? 7E ?? B8 ?? ?? ?? ??
            48 89 84 24 ?? ?? ?? ?? 31 C9 EB ?? 48 8B 84 24 ?? ?? ?? ?? 48 8B 8C 24 ?? ?? ?? ??
            48 39 C1 0F 8D ?? ?? ?? ?? 48 89 CA 48 C1 E1 ?? 48 FF C2 48 89 D3 48 C1 E2 ?? 48 39
            D1 0F 87 ?? ?? ?? ?? 48 8B 74 24 ?? 48 39 F2 0F 87 ?? ?? ?? ?? 48 89 9C 24 ?? ?? ??
            ?? 48 8B 05 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 8B 3D ?? ?? ?? ?? 48 89 3C 24 48 89
        }

        $encrypt_files_p2 = {
            5C 24 ?? 48 89 44 24 ?? 48 29 CE 48 89 F3 48 F7 DE 48 C1 FE ?? 48 21 CE 48 8B BC 24
            ?? ?? ?? ?? 48 01 FE 48 89 74 24 ?? 48 29 CA 48 89 54 24 ?? 48 89 5C 24 ?? E8 ?? ??
            ?? ?? 48 8B 44 24 ?? 48 8B 4C 24 ?? 48 8B 54 24 ?? 48 8B 5C 24 ?? 48 85 DB 0F 85 ??
            ?? ?? ?? 48 8B 9C 24 ?? ?? ?? ?? 48 89 1C 24 48 89 44 24 ?? 48 89 4C 24 ?? 48 89 54
            24 ?? E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 48 83 F8 ?? 0F 8D ?? ?? ?? ?? 48 C1 E0 ?? 48 8B
            4C 24 ?? 48 39 C8 0F 87 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 8B
            35 ?? ?? ?? ?? 48 89 14 24 48 89 5C 24 ?? 48 89 74 24 ?? 48 8B 54 24 ?? 48 29 C2 48
            89 D3 48 F7 DA 48 C1 FA ?? 48 21 C2 48 8B B4 24 ?? ?? ?? ?? 48 01 F2 48 89 54 24 ??
            48 29 C1 48 89 4C 24 ?? 48 89 5C 24 ?? E8 ?? ?? ?? ?? 48 8B 44 24 ?? 48 8B 4C 24 ??
            48 8B 54 24 ?? 48 8B 5C 24 ?? 48 85 DB 74 ?? 48 8B 84 24 ?? ?? ?? ?? 48 8B 8C 24 ??
            ?? ?? ?? 48 89 8C 24 ?? ?? ?? ?? 48 89 84 24 ?? ?? ?? ?? 48 8B AC 24 ?? ?? ?? ?? 48
            81 C4 ?? ?? ?? ?? C3 48 8B 9C 24 ?? ?? ?? ?? 48 89 1C 24 48 89 44 24 ?? 48 89 4C 24
            ?? 48 89 54 24 ?? E8 ?? ?? ?? ?? 48 8B 84 24
        }

        $find_files = {
            65 48 8B 0C 25 ?? ?? ?? ?? 48 8B 89 ?? ?? ?? ?? 48 3B 61 ?? 0F 86 ?? ?? ?? ?? 48 83
            EC ?? 48 89 6C 24 ?? 48 8D 6C 24 ?? 48 C7 04 24 ?? ?? ?? ?? 48 8B 84 24 ?? ?? ?? ??
            48 89 44 24 ?? 48 8B 8C 24 ?? ?? ?? ?? 48 89 4C 24 ?? 48 8D 15 ?? ?? ?? ?? 48 89 54
            24 ?? 48 C7 44 24 ?? ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 89 54
            24 ?? 48 89 5C 24 ?? 48 8D 15 ?? ?? ?? ?? 48 89 54 24 ?? 48 C7 44 24 ?? ?? ?? ?? ??
            E8 ?? ?? ?? ?? 48 8B 44 24 ?? 48 89 44 24 ?? 48 8B 4C 24 ?? 48 89 4C 24 ?? 48 8B 94
            24 ?? ?? ?? ?? 48 89 14 24 48 8B 9C 24 ?? ?? ?? ?? 48 89 5C 24 ?? 48 89 44 24 ?? 48
            89 4C 24 ?? E8 ?? ?? ?? ?? 48 8B 44 24 ?? 48 85 C0 0F 84 ?? ?? ?? ?? 48 8B 84 24 ??
            ?? ?? ?? 48 8B 8C 24 ?? ?? ?? ?? 48 89 04 24 48 89 4C 24 ?? 48 C7 44 24 ?? ?? ?? ??
            ?? C7 44 24 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 ?? 48 8B 4C 24 ?? 48 85 C9 75
            ?? 48 89 44 24 ?? 48 89 04 24 E8 ?? ?? ?? ?? 48 8B 44 24 ?? 48 85 C0 74 ?? 48 8B 44
            24 ?? 48 89 04 24 E8 ?? ?? ?? ?? C6 84 24 ?? ?? ?? ?? ?? 48 8B 6C 24 ?? 48 83 C4 ??
            C3 48 8B 44 24 ?? 48 89 04 24 E8 ?? ?? ?? ?? C6 84 24 ?? ?? ?? ?? ?? 48 8B 6C 24 ??
            48 83 C4 ?? C3 48 89 04 24 E8 ?? ?? ?? ?? C6 84 24 ?? ?? ?? ?? ?? 48 8B 6C 24 ?? 48
            83 C4 ?? C3 48 8B 44 24
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            $find_files
        ) and
        (
            all of ($encrypt_files_p*)
        ) and
        (
            $drop_ransom_note
        )
}