rule Win64_Ransomware_Nokoyawa : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "NOKOYAWA"
        description         = "Yara rule that detects Nokoyawa ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Nokoyawa"
        tc_detection_factor = 5

    strings:

        $enum_shares = {
            48 89 4C 24 ?? 48 81 EC ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ??
            48 8D 44 24 ?? 48 89 44 24 ?? 4C 8B 8C 24 ?? ?? ?? ?? 45 33 C0 33 D2 B9 ?? ?? ?? ??
            FF 15 ?? ?? ?? ?? 89 44 24 ?? 83 7C 24 ?? ?? 74 ?? 33 C0 E9 ?? ?? ?? ?? 8B 44 24 ??
            8B D0 B9 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 89 44 24 ?? 48 83 7C 24 ?? ?? 75 ?? 33 C0
            E9 ?? ?? ?? ?? 8B 44 24 ?? 44 8B C0 33 D2 48 8B 4C 24 ?? E8 ?? ?? ?? ?? 4C 8D 4C 24
            ?? 4C 8B 44 24 ?? 48 8D 54 24 ?? 48 8B 4C 24 ?? FF 15 ?? ?? ?? ?? 89 44 24 ?? 83 7C
            24 ?? ?? 0F 85 ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? EB ?? 8B 44 24 ?? FF C0 89 44 24
            ?? 8B 44 24 ?? 39 44 24 ?? 73 ?? 48 8B 44 24 ?? 83 78 ?? ?? 75 ?? 8B 44 24 ?? 48 6B
            C0 ?? 48 8B 4C 24 ?? 48 8B 54 01 ?? 48 8D 4C 24 ?? E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ??
            ?? 48 8D 4C 24 ?? E8 ?? ?? ?? ?? 48 8D 4C 24 ?? E8 ?? ?? ?? ?? 8B 44 24 ?? 48 6B C0
            ?? 48 8B 4C 24 ?? 8B 44 01 ?? 83 E0 ?? 83 F8 ?? 75 ?? 8B 44 24 ?? 48 6B C0 ?? 48 8B
            4C 24 ?? 48 03 C8 48 8B C1 48 8B C8 E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? EB ?? 81 7C 24 ??
            ?? ?? ?? ?? 74 ?? EB ?? 81 7C 24 ?? ?? ?? ?? ?? 0F 85 ?? ?? ?? ?? 48 8B 4C 24 ?? FF
            15 ?? ?? ?? ?? 48 8B 4C 24 ?? FF 15
        }

        $find_files_p1 = {
            FF 15 ?? ?? ?? ?? 48 89 44 24 ?? 48 83 7C 24 ?? ?? 0F 84 ?? ?? ?? ?? 8B 44 24 ?? 83
            E0 ?? 85 C0 0F 84 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 ?? E8 ?? ?? ?? ?? 85
            C0 0F 84 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 ?? E8 ?? ?? ?? ?? 85 C0 0F 84
            ?? ?? ?? ?? 48 8D 4C 24 ?? E8 ?? ?? ?? ?? 48 98 48 8B D0 48 8D 4C 24 ?? E8 ?? ?? ??
            ?? 3D ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? 48 8D 4C 24 ?? E8 ?? ?? ?? ?? 48 98 48 8B D0 48
            8D 4C 24 ?? E8 ?? ?? ?? ?? 3D ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? 48 8D 4C 24 ?? E8 ?? ??
            ?? ?? 48 98 48 8B D0 48 8D 4C 24 ?? E8 ?? ?? ?? ?? 3D ?? ?? ?? ?? 74 ?? 48 8D 4C 24
            ?? E8 ?? ?? ?? ?? 48 98 48 8B D0 48 8D 4C 24 ?? E8 ?? ?? ?? ?? 3D ?? ?? ?? ?? 74 ??
            48 8D 4C 24 ?? E8 ?? ?? ?? ?? 48 98 48 8B D0 48 8D 4C 24 ?? E8 ?? ?? ?? ?? 3D ?? ??
            ?? ?? 74 ?? 48 8D 4C 24 ?? E8 ?? ?? ?? ?? 48 98 48 8B D0 48 8D 4C 24 ?? E8 ?? ?? ??
            ?? 3D ?? ?? ?? ?? 75 ?? E9 ?? ?? ?? ?? 48 8B 94 24 ?? ?? ?? ?? 48 8D 8C 24 ?? ?? ??
            ?? E8 ?? ?? ?? ?? 48 8B 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF C8 48 98 48 8B 8C 24 ??
            ?? ?? ?? 0F B7 04 41 83 F8 ?? 75 ?? 48 8B 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF C8 48
        }

        $find_files_p2 = {
            98 48 8B 8C 24 ?? ?? ?? ?? 0F B7 04 41 83 F8 ?? 74 ?? 48 8D 15 ?? ?? ?? ?? 48 8D 8C
            24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 54 24 ?? 48 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ??
            48 8D 15 ?? ?? ?? ?? 48 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 8C 24 ?? ?? ?? ??
            E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 48 8B 94 24 ?? ?? ?? ?? 48 8D 8C 24 ?? ?? ?? ?? E8 ??
            ?? ?? ?? 48 8B 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF C8 48 98 48 8B 8C 24 ?? ?? ?? ??
            0F B7 04 41 83 F8 ?? 75 ?? 48 8B 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF C8 48 98 48 8B
            8C 24 ?? ?? ?? ?? 0F B7 04 41 83 F8 ?? 74 ?? 48 8D 15 ?? ?? ?? ?? 48 8D 8C 24 ?? ??
            ?? ?? E8 ?? ?? ?? ?? 48 8D 54 24 ?? 48 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 4C
            24 ?? E8 ?? ?? ?? ?? 48 8B D0 48 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 15 ?? ??
            ?? ?? 48 8D 4C 24 ?? E8 ?? ?? ?? ?? 48 85 C0 75 ?? 48 8D 15 ?? ?? ?? ?? 48 8D 8C 24
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 ?? 48 8D 15 ?? ?? ?? ?? 48 8D 8C 24 ?? ?? ?? ??
            E8 ?? ?? ?? ?? 85 C0 74 ?? 48 8D 15 ?? ?? ?? ?? 48 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ??
            ?? 85 C0 75 ?? EB ?? 48 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 54 24 ?? 48 8B 4C
            24 ?? FF 15 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 48 8B 4C 24 ?? FF 15 ?? ?? ?? ?? 48
            81 C4
        }

        $encrypt_files = {
            48 89 4C 24 ?? 48 83 EC ?? 48 C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44
            24 ?? ?? ?? ?? ?? 45 33 C9 45 33 C0 BA ?? ?? ?? ?? 48 8B 8C 24 ?? ?? ?? ?? FF 15 ??
            ?? ?? ?? 48 89 44 24 ?? 48 83 7C 24 ?? ?? 0F 84 ?? ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ??
            ?? ?? 48 89 44 24 ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 ?? B9 ?? ?? ?? ?? E8
            ?? ?? ?? ?? 48 89 44 24 ?? BA ?? ?? ?? ?? 48 8B 4C 24 ?? E8 ?? ?? ?? ?? 48 8B 54 24
            ?? 48 8B 4C 24 ?? E8 ?? ?? ?? ?? 4C 8B 44 24 ?? 48 8B 15 ?? ?? ?? ?? 48 8B 4C 24 ??
            E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 ?? 41 B8 ?? ?? ?? ?? 33 D2
            48 8B 4C 24 ?? E8 ?? ?? ?? ?? 48 8B 44 24 ?? 48 C7 40 ?? ?? ?? ?? ?? 48 8B 44 24 ??
            48 8B 4C 24 ?? 48 89 48 ?? 48 8B 44 24 ?? C7 40 ?? ?? ?? ?? ?? 48 8B 44 24 ?? 48 C7
            40 ?? ?? ?? ?? ?? 48 8B 44 24 ?? C7 40 ?? ?? ?? ?? ?? 48 8B 44 24 ?? 48 8B 4C 24 ??
            48 89 48 ?? 48 8B 44 24 ?? 48 8B 4C 24 ?? 48 89 48 ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ??
            48 8B 4C 24 ?? 48 89 41 ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 4C 24 ?? 48 89 41 ??
            48 8B 44 24 ?? C7 40 ?? ?? ?? ?? ?? 48 8B 44 24 ?? 48 83 C0 ?? 48 8B 94 24 ?? ?? ??
            ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 98 4C 8B C0 48 8D
            15 ?? ?? ?? ?? 48 8B 44 24 ?? 48 8B 48 ?? E8 ?? ?? ?? ?? 48 8B 44 24 ?? 48 83 C0 ??
            48 8B D0 48 8B 4C 24 ?? FF 15 ?? ?? ?? ?? 48 8B 4C 24 ?? E8 ?? ?? ?? ?? 48 8B 54 24
            ?? 48 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 ?? 48 89 44 24 ?? 45 33 C9 41 B8
            ?? ?? ?? ?? 48 8B 44 24 ?? 48 8B 50 ?? 48 8B 44 24 ?? 48 8B 48 ?? FF 15 ?? ?? ?? ??
            48 8D 05 ?? ?? ?? ?? F0 FF 00 48 83 C4 ?? C3
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            all of ($find_files_p*)
        ) and
        (
            $enum_shares
        ) and
        (
            $encrypt_files
        )
}