rule Win64_Ransomware_Solaso : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "SOLASO"
        description         = "Yara rule that detects Solaso ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Solaso"
        tc_detection_factor = 5

    strings:

        $find_files_p1 = {
            C6 85 ?? ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 48 89 45 ?? 4C 89 AD ?? ?? ?? ?? 48 8D 85
            ?? ?? ?? ?? 48 89 45 ?? B1 ?? E8 ?? ?? ?? ?? 48 89 85 ?? ?? ?? ?? 48 8D 8D ?? ?? ??
            ?? E8 ?? ?? ?? ?? 90 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 8D ?? ?? ?? ??
            E8 ?? ?? ?? ?? 90 48 8D 95 ?? ?? ?? ?? 48 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 4C 8D
            85 ?? ?? ?? ?? 48 8D 95 ?? ?? ?? ?? 48 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 8B BD
            ?? ?? ?? ?? 4C 8B BD ?? ?? ?? ?? 49 3B FF 0F 84 ?? ?? ?? ?? 66 0F 1F 44 00 ?? 48 8D
            95 ?? ?? ?? ?? 48 8B CF E8 ?? ?? ?? ?? 90 48 8D 95 ?? ?? ?? ?? 48 83 BD ?? ?? ?? ??
            ?? 48 0F 43 95 ?? ?? ?? ?? 4C 8B 85 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ??
            48 8B C8 E8 ?? ?? ?? ?? 4C 89 AD ?? ?? ?? ?? 48 C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C6 85
            ?? ?? ?? ?? ?? 48 8D 95 ?? ?? ?? ?? 48 83 BD ?? ?? ?? ?? ?? 48 0F 43 95 ?? ?? ?? ??
            4C 8B 85 ?? ?? ?? ?? 48 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B CF 48 83 7F ?? ?? 72
            ?? 48 8B 0F BA ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 41 B8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ??
            48 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 48 89 44 24 ?? 4C 89 AD ??
            ?? ?? ?? 4C 89 AD ?? ?? ?? ?? 48 8B B5 ?? ?? ?? ?? 4C 8D B5 ?? ?? ?? ?? 48 83 BD ??
            ?? ?? ?? ?? 4C 0F 43 B5 ?? ?? ?? ?? 48 83 FE ?? 73 ?? 41 0F 10 06 0F 11 85 ?? ?? ??
            ?? 48 C7 85 ?? ?? ?? ?? ?? ?? ?? ?? E9 ?? ?? ?? ?? 48 B8 ?? ?? ?? ?? ?? ?? ?? ?? 48
        }

        $find_files_p2 = {
            8B DE 48 83 CB ?? 48 3B D8 48 0F 47 D8 48 8D 4B ?? 48 81 F9 ?? ?? ?? ?? 72 ?? 48 8D
            41 ?? 48 3B C1 0F 86 ?? ?? ?? ?? 0F AE E8 48 8B C8 E8 ?? ?? ?? ?? 48 8B C8 48 85 C0
            0F 84 ?? ?? ?? ?? 48 83 C0 ?? 48 83 E0 ?? 48 89 48 ?? EB ?? 48 85 C9 74 ?? 0F AE E8
            E8 ?? ?? ?? ?? EB ?? 49 8B C5 48 89 85 ?? ?? ?? ?? 4C 8D 46 ?? 49 8B D6 48 8B C8 E8
            ?? ?? ?? ?? 48 89 9D ?? ?? ?? ?? 48 89 B5 ?? ?? ?? ?? 4C 89 6D ?? 4C 89 6D ?? 48 8B
            B5 ?? ?? ?? ?? 4C 8D B5 ?? ?? ?? ?? 48 83 BD ?? ?? ?? ?? ?? 4C 0F 43 B5 ?? ?? ?? ??
            48 83 FE ?? 73 ?? 41 0F 10 06 0F 11 45 ?? 48 C7 45 ?? ?? ?? ?? ?? E9 ?? ?? ?? ?? 48
            B8 ?? ?? ?? ?? ?? ?? ?? ?? 48 89 45 ?? 48 8B DE 48 83 CB ?? 48 89 5D ?? 48 3B D8 48
            0F 47 D8 48 8D 4B ?? 48 81 F9 ?? ?? ?? ?? 72 ?? 48 8D 41 ?? 48 3B C1 0F 86 ?? ?? ??
            ?? 0F AE E8 48 8B C8 E8 ?? ?? ?? ?? 48 8B C8 48 85 C0 0F 84 ?? ?? ?? ?? 48 83 C0 ??
            48 83 E0 ?? 48 89 48 ?? EB ?? 48 85 C9 74 ?? 0F AE E8 E8 ?? ?? ?? ?? EB ?? 49 8B C5
            48 89 45 ?? 4C 8D 46 ?? 49 8B D6 48 8B C8 E8 ?? ?? ?? ?? 48 89 5D ?? 48 89 75 ?? 4C
            8D 85 ?? ?? ?? ?? 48 8D 55 ?? 48 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 8D
        }

        $encrypt_files_p1 = {
            48 63 53 ?? 48 89 B5 ?? ?? ?? ?? 48 C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C6 45 ?? ?? 45 33
            C0 48 8D 4D ?? E8 ?? ?? ?? ?? 90 48 8D 55 ?? 48 83 BD ?? ?? ?? ?? ?? 48 0F 43 55 ??
            4C 63 43 ?? 48 8D 4C 24 ?? E8 ?? ?? ?? ?? 48 8B 4C 24 ?? 48 89 4B ?? 48 85 C9 0F 84
            ?? ?? ?? ?? 48 8B 95 ?? ?? ?? ?? 48 3B CA 77 ?? 48 89 8D ?? ?? ?? ?? 48 8D 45 ?? 48
            83 BD ?? ?? ?? ?? ?? 48 0F 43 45 ?? C6 04 01 ?? EB ?? 48 8B F1 48 2B F2 4C 8B 85 ??
            ?? ?? ?? 49 8B C0 48 2B C2 48 3B F0 77 ?? 48 89 8D ?? ?? ?? ?? 48 8D 7D ?? 49 83 F8
            ?? 48 0F 43 7D ?? 48 03 FA 4C 8B C6 33 D2 48 8B CF E8 ?? ?? ?? ?? C6 04 37 ?? EB ??
            0F AE E8 C6 44 24 ?? ?? 4C 8B CE 48 8B D6 48 8D 4D ?? E8 ?? ?? ?? ?? 33 F6 8B 43 ??
            99 41 F7 FD B9 ?? ?? ?? ?? 85 C0 0F 45 C8 89 4B ?? 83 F9 ?? 0F 8C ?? ?? ?? ?? 4C 63
            C9 4C 8D 45 ?? 48 8D 54 24 ?? E8 ?? ?? ?? ?? 48 8B F8 48 3B D8 74 ?? 48 8B 0B 48 85
        }

        $encrypt_files_p2 = {
            C9 74 ?? 48 8B 53 ?? E8 ?? ?? ?? ?? 48 8B 0B 48 8B 53 ?? 48 2B D1 48 83 E2 ?? 48 81
            FA ?? ?? ?? ?? 72 ?? 48 83 C2 ?? 4C 8B 41 ?? 49 2B C8 48 8D 41 ?? 48 83 F8 ?? 0F 87
            ?? ?? ?? ?? 49 8B C8 E8 ?? ?? ?? ?? 48 89 33 48 89 73 ?? 48 89 73 ?? 48 8B 07 48 89
            03 48 8B 47 ?? 48 89 43 ?? 48 8B 47 ?? 48 89 43 ?? 48 89 37 48 89 77 ?? 48 89 77 ??
            48 8B 4C 24 ?? 48 85 C9 74 ?? 48 8B 54 24 ?? E8 ?? ?? ?? ?? 48 8B 54 24 ?? 48 8B 4C
            24 ?? 48 2B D1 48 83 E2 ?? 48 8B C1 48 81 FA ?? ?? ?? ?? 72 ?? 48 83 C2 ?? 48 8B 49
            ?? 48 2B C1 48 83 C0 ?? 48 83 F8 ?? 0F 87 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 74 24 ??
            0F 57 C0 F3 0F 7F 44 24 ?? EB ?? 48 8B 0B 48 8D 45 ?? 48 3B C8 74 ?? 48 8D 55 ?? 48
            83 BD ?? ?? ?? ?? ?? 48 0F 43 55 ?? 4C 8B 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B CB E8
            ?? ?? ?? ?? 45 33 C0 48 8D 15 ?? ?? ?? ?? 48 8D 4D ?? E8 ?? ?? ?? ?? 83 7B ?? ?? 74
            ?? 33 FF 0F 1F 40 ?? 66 0F 1F 84 00 ?? ?? 00 00 4C 8B 03 4C 03 C7 49 8B D0 49 83 78
            ?? ?? 72 ?? 49 8B 10 4D 8B 40 ?? 48 8D 4D ?? E8 ?? ?? ?? ?? 48 63 CE 48 C1 E1 ?? 48
        }

        $encrypt_files_p3 = {
            03 0B 45 33 C0 48 8D 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 0B 48 03 CF 48 C7 41 ?? ??
            ?? ?? ?? 48 83 79 ?? ?? 72 ?? 48 8B 09 C6 01 ?? FF C6 48 83 C7 ?? 3B 73 ?? 75 ?? 48
            8D 55 ?? 48 83 BD ?? ?? ?? ?? ?? 48 0F 43 55 ?? 4C 8B 85 ?? ?? ?? ?? 48 8D 8D ?? ??
            ?? ?? E8 ?? ?? ?? ?? 90 48 8B 95 ?? ?? ?? ?? 48 83 FA ?? 72 ?? 48 FF C2 48 8B 4D ??
            48 8B C1 48 81 FA ?? ?? ?? ?? 72 ?? 48 83 C2 ?? 48 8B 49 ?? 48 2B C1 48 83 C0 ?? 48
            83 F8 ?? 0F 87 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 ?? 48 63 48 ?? 33 F6 F6 44 0C
            ?? ?? 75 ?? E9 ?? ?? ?? ?? 48 8B 95 ?? ?? ?? ?? 48 83 FA ?? 72 ?? 48 FF C2 48 8B 4D
            ?? 48 8B C1 48 81 FA ?? ?? ?? ?? 72 ?? 48 83 C2 ?? 48 8B 49 ?? 48 2B C1 48 83 C0 ??
            48 83 F8 ?? 0F 87 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 3D ?? ?? ?? ?? 48 8D 4C 24 ?? E8
            ?? ?? ?? ?? BB ?? ?? ?? ?? 48 85 C0 75 ?? 48 8B 44 24 ?? 48 63 48 ?? 48 8D 44 24 ??
            48 03 C8 41 8B D4 48 83 79 ?? ?? 0F 45 D3 0B 51 ?? 45 33 C0 E8 ?? ?? ?? ?? 48 8D 8D
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 C0 75 ?? 48 8B 85 ?? ?? ?? ?? 48 63 48 ?? 48 8D 85
            ?? ?? ?? ?? 48 03 C8 48 83 79 ?? ?? 44 0F 45 E3 44 0B 61 ?? 45 33 C0 41 8B D4 E8 ??
            ?? ?? ?? 90 48 8B 85 ?? ?? ?? ?? 48 63 48 ?? 48 89 BC 0D ?? ?? ?? ?? 48 8B 85 ?? ??
            ?? ?? 48 63 48 ?? 8D 91 ?? ?? ?? ?? 89 94 0D ?? ?? ?? ?? 48 8D 8D ?? ?? ?? ?? E8 ??
            ?? ?? ?? 48 8B 85 ?? ?? ?? ?? 48 63 48 ?? 48 8D 05 ?? ?? ?? ?? 48 89 84 0D ?? ?? ??
            ?? 48 8B 85 ?? ?? ?? ?? 48 63 48 ?? 8D 51 ?? 89 94 0D ?? ?? ?? ?? 48 8D 1D ?? ?? ??
            ?? 48 89 9D ?? ?? ?? ?? 48 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 8B 44 24 ?? 48 63
        }

        $encrypt_files_p4 = {
            48 ?? 48 8D 05 ?? ?? ?? ?? 48 89 44 0C ?? 48 8B 44 24 ?? 48 63 48 ?? 8D 91 ?? ?? ??
            ?? 89 54 0C ?? 48 8D 4C 24 ?? E8 ?? ?? ?? ?? 48 8B 44 24 ?? 48 63 48 ?? 48 8D 05 ??
            ?? ?? ?? 48 89 44 0C ?? 48 8B 44 24 ?? 48 63 48 ?? 8D 51 ?? 89 54 0C ?? 48 89 5D ??
            48 8D 4D ?? E8 ?? ?? ?? ?? 90 49 8B 57 ?? 48 83 FA ?? 72 ?? 49 8B 0F 48 FF C2 48 81
            FA ?? ?? ?? ?? 72 ?? 48 83 C2 ?? 4C 8B 41 ?? 49 2B C8 48 8D 41 ?? 48 83 F8 ?? 0F 87
            ?? ?? ?? ?? 49 8B C8 E8 ?? ?? ?? ?? 49 89 77 ?? 49 C7 47 ?? ?? ?? ?? ?? 41 C6 07 ??
            49 8B 56 ?? 48 83 FA ?? 72 ?? 48 FF C2 49 8B 0E 48 81 FA ?? ?? ?? ?? 72 ?? 48 83 C2
            ?? 4C 8B 41 ?? 49 2B C8 48 8D 41 ?? 48 83 F8 ?? 77 ?? 49 8B C8 E8 ?? ?? ?? ?? 49 89
            76 ?? 49 C7 46 ?? ?? ?? ?? ?? 41 C6 06 ?? 48 8B 8D ?? ?? ?? ?? 48 33 CC E8 ?? ?? ??
            ?? 48 8B 9C 24 ?? ?? ?? ?? 48 81 C4 ?? ?? ?? ?? 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3
            E8
        }

        $encrypt_files_p5 = {
            48 8B C4 48 89 58 ?? 48 89 70 ?? 48 89 78 ?? 4C 89 40 ?? 55 41 54 41 55 41 56 41 57
            48 8D 68 ?? 48 81 EC ?? ?? ?? ?? 45 8B E1 49 8B D8 44 8B 4D ?? 48 8B FA 44 8B 45 ??
            48 8B F1 41 8B D4 48 8D 4D ?? E8 ?? ?? ?? ?? 0F 10 00 F2 0F 10 48 ?? 0F 11 45 ?? 66
            0F 73 D8 ?? 66 49 0F 7E C7 F2 0F 11 4D ?? 49 C1 EF ?? F2 0F 11 4D ?? 4C 89 7D ?? 41
            83 FF ?? 75 ?? E8 ?? ?? ?? ?? 33 F6 89 30 83 0F ?? E8 ?? ?? ?? ?? 8B 00 E9 ?? ?? ??
            ?? E8 ?? ?? ?? ?? 89 07 83 F8 ?? 75 ?? E8 ?? ?? ?? ?? 33 F6 89 30 83 0F ?? E8 ?? ??
            ?? ?? C7 00 ?? ?? ?? ?? EB ?? 8B 4D ?? 4C 8D 4D ?? 4C 8B 75 ?? 41 8B C4 48 8B 55 ??
            45 8B C7 C1 E8 ?? 49 C1 EE ?? F7 D0 44 0B 75 ?? 83 E0 ?? C7 06 ?? ?? ?? ?? 33 F6 48
            89 74 24 ?? 44 89 74 24 ?? 89 4C 24 ?? 48 8B CB 48 C1 EA ?? C7 45 ?? ?? ?? ?? ?? 48
            89 75 ?? 89 45 ?? 4C 89 75 ?? FF 15 ?? ?? ?? ?? 8B 5D ?? B9 ?? ?? ?? ?? 4C 8B E8 48
            83 F8 ?? 75 ?? 8B C3 23 C1 3B C1 75 ?? 41 F6 C4 ?? 74 ?? 8B 4D ?? 4C 8D 4D ?? 48 89
            74 24 ?? 0F BA F3 ?? 89 5D ?? 45 8B C7 48 8B 55 ?? 44 89 74 24 ?? 89 4C 24 ?? 48 8B
        }

        $encrypt_files_p6 = {
            4D ?? 48 C1 EA ?? FF 15 ?? ?? ?? ?? 4C 8B E8 48 83 F8 ?? 75 ?? 48 63 0F 4C 8D 3D ??
            ?? ?? ?? 48 8B C1 83 E1 ?? 48 C1 F8 ?? 48 8D 0C C9 49 8B 04 C7 80 64 C8 ?? ?? FF 15
            ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 49 8B CD FF 15 ?? ?? ?? ?? 85 C0 75
            ?? FF 15 ?? ?? ?? ?? 8B C8 8B D8 E8 ?? ?? ?? ?? 48 63 17 4C 8D 3D ?? ?? ?? ?? 48 8B
            CA 83 E2 ?? 48 C1 F9 ?? 48 8D 14 D2 49 8B 0C CF 80 64 D1 ?? ?? 49 8B CD FF 15 ?? ??
            ?? ?? 85 DB 0F 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 00 ?? ?? ?? ?? E9 ?? ?? ?? ?? 44 8A
            75 ?? 83 F8 ?? 75 ?? 41 80 CE ?? EB ?? 83 F8 ?? 75 ?? 41 80 CE ?? 8B 0F 49 8B D5 E8
            ?? ?? ?? ?? 48 63 0F 4C 8D 3D ?? ?? ?? ?? 48 8B C1 41 80 CE ?? 48 C1 F8 ?? 83 E1 ??
            44 88 75 ?? 49 8B 04 C7 48 8D 0C C9 44 88 74 C8 ?? 48 63 0F 48 8B C1 83 E1 ?? 48 C1
            F8 ?? 48 8D 0C C9 49 8B 04 C7 40 88 74 C8 ?? 41 F6 C4 ?? 74 ?? 8B 0F E8 ?? ?? ?? ??
            89 45 ?? 85 C0 74 ?? 8B 0F E8 ?? ?? ?? ?? 8B 45 ?? E9 ?? ?? ?? ?? 0F 10 45 ?? 4C 8D
            4D ?? 8B 0F F2 0F 10 4D ?? 48 8D 55 ?? 45 8B C4 0F 29 45 ?? 40 88 75 ?? F2 0F 11 4D
            ?? E8 ?? ?? ?? ?? 48 63 0F 89 45 ?? 85 C0 75 ?? 48 8B C1 48 C1 F9 ?? 83 E0 ?? 49 8B
        }

        $encrypt_files_p7 = {
            0C CF 48 8D 14 C0 8A 45 ?? 88 44 D1 ?? 48 63 0F 48 8B C1 83 E1 ?? 48 C1 F8 ?? 48 8D
            14 C9 49 8B 0C C7 41 8B C4 C1 E8 ?? 24 ?? 80 64 D1 ?? ?? 08 44 D1 ?? 41 F6 C6 ?? 75
            ?? 41 F6 C4 ?? 74 ?? 48 63 0F 48 8B C1 83 E1 ?? 48 C1 F8 ?? 48 8D 0C C9 49 8B 04 C7
            80 4C C8 ?? ?? B9 ?? ?? ?? ?? 8B C3 23 C1 3B C1 0F 85 ?? ?? ?? ?? 41 F6 C4 ?? 0F 84
            ?? ?? ?? ?? 49 8B CD FF 15 ?? ?? ?? ?? 48 8B 4D ?? 4C 8D 4D ?? 44 8B 45 ?? 0F BA F3
            ?? 48 89 74 24 ?? 89 4C 24 ?? 8B 4D ?? 89 4C 24 ?? 48 8B 4D ?? 89 5D ?? 48 8B 55 ??
            48 C1 EA ?? FF 15 ?? ?? ?? ?? 48 8B D0 48 83 F8 ?? 75 ?? FF 15 ?? ?? ?? ?? 8B C8 E8
            ?? ?? ?? ?? 48 63 0F 48 8B C1 83 E1 ?? 48 C1 F8 ?? 48 8D 0C C9 49 8B 04 C7 80 64 C8
            ?? ?? 8B 0F E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 48 63 0F 48 8B C1 48 C1 F8 ?? 83 E1 ?? 49
            8B 04 C7 48 8D 0C C9 48 89 54 C8 ?? 33 C0 4C 8D 9C 24 ?? ?? ?? ?? 49 8B 5B ?? 49 8B
            73 ?? 49 8B 7B ?? 49 8B E3 41 5F 41 5E 41 5D 41 5C 5D C3
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            all of ($find_files_p*)
        ) and
        (
            all of ($encrypt_files_p*)
        )
}