rule Linux_Trojan_BiBiWiper : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "BIBIWIPER"
        description         = "Yara rule that detects BiBiWiper trojan."

        tc_detection_type   = "Trojan"
        tc_detection_name   = "BiBiWiper"
        tc_detection_factor = 5

    strings:

        $destroy_files_p1 = {
            55 48 89 E5 53 48 81 EC ?? ?? ?? ?? 48 89 BD ?? ?? ?? ?? 48 89 B5 ?? ?? ?? ?? 48 89
            95 ?? ?? ?? ?? 48 89 8D ?? ?? ?? ?? 4C 89 85 ?? ?? ?? ?? 44 89 8D ?? ?? ?? ?? 48 8B
            05 ?? ?? ?? ?? 48 83 C0 ?? 48 89 05 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? 48 BA ?? ?? ??
            ?? ?? ?? ?? ?? 48 89 C8 48 F7 EA 48 89 D0 48 C1 F8 ?? 48 89 CA 48 C1 FA ?? 48 29 D0
            48 69 D0 ?? ?? ?? ?? 48 89 C8 48 29 D0 48 85 C0 0F 94 C0 84 C0 74 ?? E8 ?? ?? ?? ??
            48 8B 85 ?? ?? ?? ?? 48 89 85 ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 89
            D6 48 89 C7 E8 ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? BE ?? ?? ?? ?? 48 89 C7 E8 ?? ?? ??
            ?? 48 8D 85 ?? ?? ?? ?? 48 8D 8D ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 89 CE 48 89 C7
            E8 ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 48 8D 95 ?? ?? ?? ?? 48 8D 8D ?? ?? ?? ?? 48 89
            CE 48 89 C7 E8 ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 48 89 C7 E8 ?? ?? ?? ?? 48 8D 85 ??
            ?? ?? ?? 48 89 C7 E8 ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 48 89 C7 E8 ?? ?? ?? ?? 48 8D
            8D ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? BA ?? ?? ?? ?? 48 89 CE 48 89 C7 E8 ?? ?? ?? ??
            48 8D 8D ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? BA ?? ?? ?? ?? 48 89 CE 48 89 C7 E8 ?? ??
            ?? ?? 48 8D 95 ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 48 89 D6 48 89 C7 E8 ?? ?? ?? ?? 48
            89 C3 48 8D 8D ?? ?? ?? ?? 48 8D 45 ?? BA ?? ?? ?? ?? 48 89 CE 48 89 C7 E8 ?? ?? ??
            ?? 48 8D 45 ?? 48 89 DE 48 89 C7 E8 ?? ?? ?? ?? 48 8D 45 ?? 48 89 C7 E8
        }

        $destroy_files_p2 = {
            48 8D 85 ?? ?? ?? ?? 48 89 C7 E8 ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 48 89 C7 E8 ?? ??
            ?? ?? 48 8B 85 ?? ?? ?? ?? 48 C1 E0 ?? 48 89 45 ?? 48 8B B5 ?? ?? ?? ?? 48 8B 85 ??
            ?? ?? ?? BA ?? ?? ?? ?? 48 F7 F6 48 8B 55 ?? 48 29 D0 48 89 45 ?? 83 BD ?? ?? ?? ??
            ?? 7E ?? 8B 85 ?? ?? ?? ?? 83 E8 ?? 48 98 48 0F AF 45 ?? BA ?? ?? ?? ?? 48 F7 B5 ??
            ?? ?? ?? 48 89 D0 48 89 C1 48 8B 85 ?? ?? ?? ?? BA ?? ?? ?? ?? 48 89 CE 48 89 C7 E8
            ?? ?? ?? ?? EB ?? 48 8B 85 ?? ?? ?? ?? BA ?? ?? ?? ?? BE ?? ?? ?? ?? 48 89 C7 E8 ??
            ?? ?? ?? 48 8B 85 ?? ?? ?? ?? 48 89 C7 E8 ?? ?? ?? ?? 48 89 45 ?? 48 8B 45 ?? 48 39
            85 ?? ?? ?? ?? 73 ?? BB ?? ?? ?? ?? E9 ?? ?? ?? ?? 48 8B 55 ?? 48 8B 85 ?? ?? ?? ??
            48 29 D0 48 89 45 ?? 48 8B 45 ?? 48 89 45 ?? 48 8D 55 ?? 48 8D 45 ?? 48 89 D6 48 89
            C7 E8 ?? ?? ?? ?? 48 8B 00 48 89 45 ?? 48 8B 45 ?? 48 89 C7 E8 ?? ?? ?? ?? 48 89 45
            ?? 48 8B 45 ?? 89 C2 48 8D 85 ?? ?? ?? ?? 89 D6 48 89 C7 E8 ?? ?? ?? ?? C7 45 ?? ??
            ?? ?? ?? E9 ?? ?? ?? ?? 48 8B 5D ?? 48 8D 85 ?? ?? ?? ?? 48 89 C7 E8 ?? ?? ?? ?? 48
        }

        $destroy_files_p3 = {
            89 C7 48 8B 85 ?? ?? ?? ?? 48 89 C1 BA ?? ?? ?? ?? 48 89 DE E8 ?? ?? ?? ?? 48 8B 85
            ?? ?? ?? ?? 48 89 C7 E8 ?? ?? ?? ?? 48 89 45 ?? 48 8B 55 ?? 48 8B 45 ?? 48 01 C2 48
            8B 45 ?? 48 01 D0 48 39 85 ?? ?? ?? ?? 73 ?? 48 8B 55 ?? 48 8B 85 ?? ?? ?? ?? 48 29
            D0 48 8B 55 ?? 48 29 D0 48 89 45 ?? 48 83 7D ?? ?? 7E ?? 48 8B 4D ?? 48 8B 85 ?? ??
            ?? ?? BA ?? ?? ?? ?? 48 89 CE 48 89 C7 E8 ?? ?? ?? ?? 83 45 ?? ?? 8B 45 ?? 48 98 48
            39 85 ?? ?? ?? ?? 0F 8F ?? ?? ?? ?? EB ?? 90 48 8B 45 ?? 48 89 C7 E8 ?? ?? ?? ?? 48
            8D 85 ?? ?? ?? ?? 48 89 C7 E8 ?? ?? ?? ?? BB ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 48 89
            C7 E8 ?? ?? ?? ?? 83 FB ?? E9 ?? ?? ?? ?? 48 89 C3 48 8D 85 ?? ?? ?? ?? 48 89 C7 E8
            ?? ?? ?? ?? EB ?? 48 89 C3 48 8D 85 ?? ?? ?? ?? 48 89 C7 E8 ?? ?? ?? ?? EB ?? 48 89
            C3 48 8D 85 ?? ?? ?? ?? 48 89 C7 E8 ?? ?? ?? ?? 48 89 D8 48 89 C7 E8 ?? ?? ?? ?? 48
            89 C3 48 8D 45 ?? 48 89 C7 E8 ?? ?? ?? ?? EB ?? 48 89 C3 48 8D 85 ?? ?? ?? ?? 48 89
            C7 E8 ?? ?? ?? ?? EB ?? 48 89 C3 48 8D 85 ?? ?? ?? ?? 48 89 C7 E8 ?? ?? ?? ?? EB ??
            48 89 C3 48 8D 85 ?? ?? ?? ?? 48 89 C7 E8 ?? ?? ?? ?? EB ?? 48 89 C3 48 8D 85 ?? ??
            ?? ?? 48 89 C7 E8 ?? ?? ?? ?? 48 89 D8 48 89 C7 E8 ?? ?? ?? ?? 48 8B 5D ?? C9 C3
        }

    condition:
        uint32(0) == 0x464C457F and
        (
            all of ($destroy_files_p*)
        )
}