﻿uses
  Common, DataEntry, DataStorage, Regex, SysUtils;

procedure OnStartFilter(aDataStore: TDataStore; Var DoContinue: boolean; Var OutObj: TObject);
var
  DataStore: TDataStore;
begin
  DoContinue := True;
  DataStore := GetDataStore(DATASTORE_FILESYSTEM); // Identifies the data store of the column
  if DataStore = nil then
    Exit;
  OutObj := DataStore.DataFields.FieldByName('BOOKMARK_GROUP'); // noslz
  DataStore.free;
end;

function FilterEntry(anEntry: TEntry; InObj: TObject): integer;
const
  BM_PARENT_FLDR_NAME_STR = 'Folder and Filename Regex Search';
var
  col_result_str: string;
  Column: TDataStoreField;
begin
  Result := -1; // Exclude
  Column := TDataStoreField(InObj);
  if assigned(anEntry) and assigned(Column) then
  begin
    if (anEntry.isBookmarked) then
    begin
      col_result_str := Column.AsString[anEntry];
      if (col_result_str <> '') then
      begin
        if RegexMatch(col_result_str, BM_PARENT_FLDR_NAME_STR, false) then
          Result := 1; // Include
      end;
    end;
  end;
end;

begin

end.
