﻿uses
  Common, DataEntry, DataStorage, Regex, SysUtils;

function FilterEntry(anEntry: TEntry; InObj: TObject): integer;
const
  EXCLUDE_ARCHIVE_REGEX_STR = '' + 'accdt' + '|' + 'accft' + '|' + 'apk' + '|' + 'bau' + '|' + 'bbfw' + '|' + 'cab' + '|' + 'dat' + '|' + 'deskthemepack' + '|' + 'eftx' + '|' + 'glox' + '|' + 'gz' + '|' + 'ipa' + '|' + 'ipsw' + '|' + 'jar'
    + '|' + 'msu' + '|' + 'mzz' + '|' + 'odb' + '|' + 'odg' + '|' + 'odp' + '|' + 'onepkg' + '|' + 'otp' + '|' + 'ots' + '|' + 'ott' + '|' + 'oxt' + '|' + 'rbf' + '|' + 'rdb' + '|' + 'skin' + '|' + 'sob' + '|' + 'stw' + '|' + 'thmx' + '|' +
    'thmx' + '|' + 'ui' + '|' + 'wmf' + '|' + 'wmz' + '|' + 'xpi' + '|' + 'xsn';

var
  theFileDriverInfo: TFileTypeInformation;
  DeterminedFileDriverInfo: TFileTypeInformation;
begin
  Result := -1; // Exclude

  if assigned(anEntry) then
  begin
    theFileDriverInfo := anEntry.FileDriverInfo;
    DeterminedFileDriverInfo := anEntry.DeterminedFileDriverInfo;
    if dtARCHIVE in theFileDriverInfo.DriverType then
    begin
      if DeterminedFileDriverInfo.ShortDisplayName <> '' then
      begin
        if RegexMatch(DeterminedFileDriverInfo.ShortDisplayName, '^(Zip|RAR|7Zip)$', False) then
        begin
          if not RegexMatch(anEntry.Extension, EXCLUDE_ARCHIVE_REGEX_STR, False) then
            Result := 1; // Include
        end;
      end;
    end;
  end;
end;

begin

end.
