﻿{ !NAME:      FEX Registry Filter }
{ !DESC:      Filter files }
{ !AUTHOR:    GetData }

uses
  Common, DataEntry, DataStorage, Regex, SysUtils;

function FilterEntry(anEntry: TEntry; InObj: TObject): integer;
const
  FILE_SIGNATURE = 'REGISTRY'; // noslz
var
  filename: string;
  theFileDriverInfo: TFileTypeInformation;
begin
  Result := -1; // Exclude
  if assigned(anEntry) then
  begin
    filename := UpperCase(anEntry.EntryName);
    if (not anEntry.IsDirectory) and ((filename = 'SOFTWARE') or (filename = 'SYSTEM') or (filename = 'SAM') or (filename = 'NTUSER.DAT') or (filename = 'SECURITY') or (filename = 'USRCLASS.DAT')) then
    begin
      DetermineFileType(anEntry);
      theFileDriverInfo := anEntry.FileDriverInfo;
      if (UpperCase(theFileDriverInfo.ShortDisplayName) = FILE_SIGNATURE) then
        Result := 1; // Show in display
    end;
  end;
end;

begin

end.
