﻿unit Apple_Columns;

interface

uses
  {$IF DEFINED (ISFEXGUI)}
  GUI,
  {$IFEND}
  Columns, DataStorage, SysUtils;

function GetTable(const Name : string) : TSQL_Table_array;

implementation

function GetTable(const Name : string) : TSQL_Table_array;
const
Array_Items_APL_IOS_APPLE_COMMANDCENTER: TSQL_Table_array = (
 (sql_col: 'DNT_kEntitlementsSelfRegistrationUpdateImei'; fex_col: 'IMEI';                              read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_lastGoodImsi';                fex_col: 'Last Good IMSI';                    read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_LastKnownICCID';              fex_col: 'Last Known ICCID';                  read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_com.apple.carrier_1';         fex_col: 'Apple Carrier';                     read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_PhoneNumber';                 fex_col: 'Phone Number';                      read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_APL_IOS_APPLICATION_FOLDER_UUID: TSQL_Table_array = (
 (sql_col: 'DNT_UUID';                        fex_col: 'UUID';                              read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_APPLICATION_NAME';            fex_col: 'Application Name';                  read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_APL_IOS_APPLICATIONPERMISSIONS: TSQL_Table_array = (
 (sql_col: 'DNT_LAST_MODIFIED';               fex_col: 'Last Modified';                     read_as: ftLargeInt;   convert_as: 'UNIX';            col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_AUTH_VALUE_TEXT';             fex_col: 'Access';                            read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_CLIENT';                      fex_col: 'Application';                       read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SERVICE';                     fex_col: 'Service';                           read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_AUTH_VALUE';                  fex_col: 'Auth Value';                        read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_AUTH_REASON';                 fex_col: 'Auth Reason';                       read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_APL_IOS_APPLICATIONSTATE: TSQL_Table_array = (
 (sql_col: 'DNT_ID';                          fex_col: 'ID#';                               read_as: ftInteger;    convert_as: '';                col_type: ftInteger;   show: True),
 (sql_col: 'DNT_APPLICATION_IDENTIFIER';      fex_col: 'Application Identifier';            read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_APL_IOS_APPLICATIONUSAGE: TSQL_Table_array = (
 (sql_col: 'DNT_ZCREATIONDATE';               fex_col: 'Creation Date';                     read_as: ftFloat;      convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_ZVALUESTRING';                fex_col: 'Application Identifier';            read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ZSTREAMNAME';                 fex_col: 'Stream Name';                       read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ZUUID';                       fex_col: 'ZUUID';                             read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_APL_IOS_BIOME_APP_FOCUS: TSQL_Table_array = (
 (sql_col: 'DNT_Created (UTC)';               fex_col: 'Created (UTC)';                     read_as: ftFloat;      convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_DATE_START';                  fex_col: 'Start Timestamp';                   read_as: ftFloat;      convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_DATE_END';                    fex_col: 'End Timestamp';                     read_as: ftFloat;      convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_BUNDLE_ID';                   fex_col: 'Bundle ID';                         read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_METADATA';                    fex_col: 'Metadata';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_GUID';                        fex_col: 'GUID';                              read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_APL_IOS_BIOME_APP_INTENT: TSQL_Table_array = (
 (sql_col: 'DNT_Created (UTC)';               fex_col: 'Created (UTC)';                     read_as: ftFloat;      convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_BUNDLE_ID';                   fex_col: 'Bundle ID';                         read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_TYPE';                        fex_col: 'Type';                              read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_GUID';                        fex_col: 'GUID';                              read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_APL_IOS_BIOME_APP_LAUNCH: TSQL_Table_array = (
 (sql_col: 'DNT_Created (UTC)';               fex_col: 'Created (UTC)';                     read_as: ftFloat;      convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_Field 1';                     fex_col: 'Transition Type';                   read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_Field 6';                     fex_col: 'Bundle ID';                         read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_Field 9';                     fex_col: 'Display Version';                   read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_Field 10';                    fex_col: 'Internal Version';                  read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_APL_IOS_BIOME_KEYBAG_LOCK_STATES: TSQL_Table_array = (
 (sql_col: 'DNT_Created (UTC)';               fex_col: 'Created (UTC)';                     read_as: ftFloat;      convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_STATE';                       fex_col: 'State';                             read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_GUID';                        fex_col: 'GUID';                              read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_APL_IOS_BIOME_PLUGGEDIN_STATES: TSQL_Table_array = (
 (sql_col: 'DNT_DATE_START';                  fex_col: 'Start Timestamp';                   read_as: ftFloat;      convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_DATE_END';                    fex_col: 'End Timestamp';                     read_as: ftFloat;      convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_Created (UTC)';               fex_col: 'Created (UTC)';                     read_as: ftFloat;      convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_GUID';                        fex_col: 'GUID';                              read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_APL_IOS_BIOME_SAFARI_HISTORY: TSQL_Table_array = (
 (sql_col: 'DNT_TIMESTAMP';                   fex_col: 'Timestamp';                         read_as: ftFloat;      convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_URL';                         fex_col: 'URL';                               read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_TITLE';                       fex_col: 'Title';                             read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_GUID';                        fex_col: 'GUID';                              read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_APL_IOS_BIOME_TEXT_INPUT_SESSION: TSQL_Table_array = (
 (sql_col: 'DNT_Created (UTC)';               fex_col: 'Created (UTC)';                     read_as: ftFloat;      convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_Modified (UTC)';              fex_col: 'Modified (UTC)';                    read_as: ftFloat;      convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_TITLE';                       fex_col: 'Title';                             read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_APL_IOS_BIOME_USER_ACTIVITY: TSQL_Table_array = (
 (sql_col: 'DNT_Created (UTC)';               fex_col: 'Created (UTC)';                     read_as: ftFloat;      convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_TITLE';                       fex_col: 'Title';                             read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_TYPE';                        fex_col: 'Type';                              read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SERVICE';                     fex_col: 'Service';                           read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_GUID';                        fex_col: 'GUID';                              read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_APL_IOS_BIOME_USER_NOTIFICATION_EVENTS: TSQL_Table_array = (
 (sql_col: 'DNT_TIMESTAMP';                   fex_col: 'Timestamp';                         read_as: ftDateTime;   convert_as: '';                col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_TITLE';                       fex_col: 'Title';                             read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_BUNDLEID';                    fex_col: 'Bundle ID';                         read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_BODY';                        fex_col: 'Body';                              read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_GUID';                        fex_col: 'GUID';                              read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_METADATA_REF';                fex_col: 'Metadata Ref.';                     read_as: ftInteger;    convert_as: '';                col_type: ftInteger;   show: True),
 );

Array_Items_APL_IOS_INTERACTIONSC_CONTACTS: TSQL_Table_array = (
 (sql_col: 'DNT_ZCREATIONDATE';               fex_col: 'Creation Date';                     read_as: ftFloat;      convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_ZIDENTIFIER';                 fex_col: 'Identifier';                        read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ZDISPLAYNAME';                fex_col: 'Display Name';                      read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ZFIRSTINCOMINGSENDERDATE';    fex_col: 'First Incoming Sender Date';        read_as: ftFloat;      convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_ZLASTINCOMINGSENDERDATE';     fex_col: 'Last Incoming Sender Date';         read_as: ftFloat;      convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_ZFIRSTINCOMINGRECIPIENTDATE'; fex_col: 'First Incoming Recipient Date';     read_as: ftString;     convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_ZLASTINCOMINGRECIPIENTDATE';  fex_col: 'Last Incoming Recipent Date';       read_as: ftString;     convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_ZFIRSTOUTGOINGRECIPIENTDATE'; fex_col: 'First Outgoing Recipient Date';     read_as: ftString;     convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_ZLASTOUTGOINGRECIPIENTDATE';  fex_col: 'Last Outgoing Recipient Date';      read_as: ftString;     convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_ZINCOMINGRECIPIENTCOUNT';     fex_col: 'Incoming Recipient Count';          read_as: ftInteger;    convert_as: '';                col_type: ftInteger;   show: True),
 (sql_col: 'DNT_ZINCOMINGSENDERCOUNT';        fex_col: 'Incoming Sender Count';             read_as: ftInteger;    convert_as: '';                col_type: ftInteger;   show: True),
 (sql_col: 'DNT_ZOUTGOINGRECIPIENTCOUNT';     fex_col: 'Outgoing Recipient Count';          read_as: ftInteger;    convert_as: '';                col_type: ftInteger;   show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_APL_IOS_INTERACTIONSC_INTERACTIONS: TSQL_Table_array = (
 (sql_col: 'DNT_ZCREATIONDATE';               fex_col: 'Creation Date';                     read_as: ftFloat;      convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_ZBUNDLEID';                   fex_col: 'Bundle ID';                         read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ZDISPLAYNAME';                fex_col: 'Display Name';                      read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ZSTARTDATE';                  fex_col: 'Start Date';                        read_as: ftFloat;      convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_ZENDDATE';                    fex_col: 'End Date';                          read_as: ftFloat;      convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_ZUPDATEDATE';                 fex_col: 'Date Updated';                      read_as: ftFloat;      convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_ZUUID';                       fex_col: 'UUID';                              read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_NULL: TSQL_Table_array = (
 (sql_col: '';
 fex_col: '';
 read_as: ftString;
 convert_as: '';
 col_type: ftString;
 show: false));

begin
   if Name = 'APL_IOS_APPLE_COMMANDCENTER'                 then Result := Array_Items_APL_IOS_APPLE_COMMANDCENTER else
   if Name = 'APL_IOS_APPLICATION_FOLDER_UUID'             then Result := Array_Items_APL_IOS_APPLICATION_FOLDER_UUID else
   if Name = 'APL_IOS_APPLICATIONPERMISSIONS'              then Result := Array_Items_APL_IOS_APPLICATIONPERMISSIONS else
   if Name = 'APL_IOS_APPLICATIONSTATE'                    then Result := Array_Items_APL_IOS_APPLICATIONSTATE else
   if Name = 'APL_IOS_APPLICATIONUSAGE'                    then Result := Array_Items_APL_IOS_APPLICATIONUSAGE else
   if Name = 'APL_IOS_BIOME_APP_FOCUS'                     then Result := Array_Items_APL_IOS_BIOME_APP_FOCUS else
   if Name = 'APL_IOS_BIOME_APP_INTENT'                    then Result := Array_Items_APL_IOS_BIOME_APP_INTENT else
   if Name = 'APL_IOS_BIOME_APP_LAUNCH'                    then Result := Array_Items_APL_IOS_BIOME_APP_LAUNCH else
   if Name = 'APL_IOS_BIOME_KEYBAG_LOCK_STATES'            then Result := Array_Items_APL_IOS_BIOME_KEYBAG_LOCK_STATES else
   if Name = 'APL_IOS_BIOME_PLUGGEDIN_STATES'              then Result := Array_Items_APL_IOS_BIOME_PLUGGEDIN_STATES else
   if Name = 'APL_IOS_BIOME_SAFARI_HISTORY'                then Result := Array_Items_APL_IOS_BIOME_SAFARI_HISTORY else
   if Name = 'APL_IOS_BIOME_TEXT_INPUT_SESSION'            then Result := Array_Items_APL_IOS_BIOME_TEXT_INPUT_SESSION else
   if Name = 'APL_IOS_BIOME_USER_ACTIVITY'                 then Result := Array_Items_APL_IOS_BIOME_USER_ACTIVITY else
   if Name = 'APL_IOS_BIOME_USER_NOTIFICATION_EVENTS'      then Result := Array_Items_APL_IOS_BIOME_USER_NOTIFICATION_EVENTS else
   if Name = 'APL_IOS_INTERACTIONSC_CONTACTS'              then Result := Array_Items_APL_IOS_INTERACTIONSC_CONTACTS else
   if Name = 'APL_IOS_INTERACTIONSC_INTERACTIONS'          then Result := Array_Items_APL_IOS_INTERACTIONSC_INTERACTIONS else
  begin
    Result := Array_Items_NULL;
    {$IF DEFINED (ISFEXGUI)}
    ShowMessage('Apple' + ':' + #13#10 + #13#10 + 'Did not locate artifact column layout:' + #13#10 + #13#10 + Name);
    {$IFEND}
    Progress.Log(format('%-54s %-100s', ['Error: Did not locate artifact column layout:', Name]));
  end;
end;
end.
