﻿unit Location_Columns;

interface

uses
  {$IF DEFINED (ISFEXGUI)}
  GUI,
  {$IFEND}
  Columns, DataStorage, SysUtils;

function GetTable(const Name : string) : TSQL_Table_array;

implementation

function GetTable(const Name : string) : TSQL_Table_array;
const

Array_Items_LOC_AND_AIRTAG_PERSONAL_SAFETY_ALERTS: TSQL_Table_array = (
 (sql_col: 'DNT_CREATIONTIMESTAMPMILLIS';     fex_col: 'Timestamp';                        read_as: ftLargeInt;      convert_as: 'UNIX_MS';    col_type: ftDateTime;     show: True),
 (sql_col: 'DNT_LASTUPDATEDTIMESTAMPMILLIS';  fex_col: 'Last Updated Timestamp';           read_as: ftLargeInt;      convert_as: 'UNIX_MS';    col_type: ftDateTime;     show: True),
 (sql_col: 'DNT_MACADDRESS';                  fex_col: 'MAC Address';                      read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
 (sql_col: 'DNT_ALERTLIFECYCLEID';            fex_col: 'Alert Life Cycle ID';              read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
 (sql_col: 'DNT_ALERTSTATUS';                 fex_col: 'Alert Status';                     read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                         read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
);

Array_Items_LOC_AND_AIRTAG_PERSONAL_SAFETY: TSQL_Table_array = (
 (sql_col: 'DNT_CREATIONTIMESTAMPMILLIS';     fex_col: 'Timestamp';                         read_as: ftLargeInt;   convert_as: 'UNIX_MS';         col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_LASTUPDATEDTIMESTAMPMILLIS';  fex_col: 'Last Updated Timestamp';            read_as: ftLargeInt;   convert_as: 'UNIX_MS';         col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_MACADDRESS';                  fex_col: 'MAC Address';                       read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_STATE';                       fex_col: 'State';                             read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_LOCATIONSCAN';                fex_col: 'Latitude';                          read_as: ftString;     convert_as: 'DNT_LAT';         col_type: ftString;    show: True),
 (sql_col: 'DNT_LOCATIONSCAN';                fex_col: 'Longitude';                         read_as: ftString;     convert_as: 'DNT_LON';         col_type: ftString;    show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_LOC_AND_AIRTAG_PERSONAL_SAFETY_LAST_SCAN: TSQL_Table_array = (
 (sql_col: 'DNT_LAST_SCAN_ANDROID';           fex_col: 'Last Scan';                         read_as: ftLargeInt;   convert_as: 'UNIX_MS';         col_type: ftDateTime;  show: True),
 );

Array_Items_LOC_IOS_AIRTAG_INFO: TSQL_Table_array = (
 (sql_col: 'DNT_serialNumber';                fex_col: 'Serial';                            read_as: ftString;     convert_as: '';                col_type: ftString;  show: True),
 (sql_col: 'DNT_identifier';                  fex_col: 'Identifier';                        read_as: ftString;     convert_as: '';                col_type: ftString;  show: True),
 (sql_col: 'DNT_owner';                       fex_col: 'Owner';                             read_as: ftString;     convert_as: '';                col_type: ftString;  show: True),
 (sql_col: 'DNT_name';                        fex_col: 'Airtag Name';                       read_as: ftString;     convert_as: '';                col_type: ftString;  show: True),
 (sql_col: 'DNT_modelName';                   fex_col: 'Model Name';                        read_as: ftString;     convert_as: '';                col_type: ftString;  show: True),
 (sql_col: 'DNT_manufacturerName';            fex_col: 'Manufacturer Name';                 read_as: ftString;     convert_as: '';                col_type: ftString;  show: True),
 (sql_col: 'DNT_productIdentifier';           fex_col: 'Product Identifier';                read_as: ftString;     convert_as: '';                col_type: ftString;  show: True),
 );

Array_Items_LOC_AND_GOOGLEMAPS_SEARCHES: TSQL_Table_array = (
 (sql_col: 'DNT_TIMESTAMP';                   fex_col: 'Timestamp';                         read_as: ftLargeInt;   convert_as: '';                col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_PLACE';                       fex_col: 'Place';                             read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_LATITUDE';                    fex_col: 'Latitude';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_LONGITUDE';                   fex_col: 'Longitude';                         read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_URL';                         fex_col: 'URL';                               read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_LOC_AND_LIFE360_LOCATIONS: TSQL_Table_array = (
 (sql_col: 'DNT_TIMESTAMP';                   fex_col: 'Timestamp';                         read_as: ftLargeInt;   convert_as: 'UNIX_MS';         col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_LATITUDE';                    fex_col: 'Latitude';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_LONGITUDE';                   fex_col: 'Longitude';                         read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_BEARING';                     fex_col: 'Bearing';                           read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ALTITUDE';                    fex_col: 'Altitude';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SPEED';                       fex_col: 'Speed';                             read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_BSSID';                       fex_col: 'BSSID';                             read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SSID';                        fex_col: 'SSID';                              read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_LIFE360ID';                   fex_col: 'Life360 ID';                        read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
);

Array_Items_LOC_IOS_APPLE_MAPS_HISTORY: TSQL_Table_array = (
 (sql_col: 'DNT_SearchKind';                  fex_col: 'Search Kind';                       read_as: ftString;     convert_as: '';                col_type: ftString;    show: False),
 (sql_col: 'DNT_HistoryItemType';             fex_col: 'History Item Type';                 read_as: ftString;     convert_as: '';                col_type: ftString;    show: False),
 (sql_col: 'DNT_Query';                       fex_col: 'Query';                             read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_Latitude';                    fex_col: 'Latitude';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_Longitude';                   fex_col: 'Longitude';                         read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_Location';                    fex_col: 'Location';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ZoomLevel';                   fex_col: 'Zoom Level';                        read_as: ftInteger;    convert_as: '';                col_type: ftInteger;   show: True),
 );

Array_Items_LOC_IOS_APPLE_MAPS_SEARCHES: TSQL_Table_array = (
 (sql_col: 'DNT_ZCREATETIME';                 fex_col: 'Date Created';                      read_as: ftLargeInt;   convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_Z_PK';                        fex_col: 'Z_PK';                              read_as: ftInteger;    convert_as: '';                col_type: ftInteger;   show: True),
 (sql_col: 'DNT_ZROUTEREQUESTSTORAGE';        fex_col: 'Query';                             read_as: ftBytes;      convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ZLATITUDE';                   fex_col: 'Latitude';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ZLONGITUDE';                  fex_col: 'Longitude';                         read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_LOC_IOS_APPLE_MAPS_TILES: TSQL_Table_array = (
 (sql_col: 'DNT_TIMESTAMP';                   fex_col: 'Timestamp';                         read_as: ftLargeInt;   convert_as: 'UNIX';            col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_DATA';                        fex_col: 'Data';                              read_as: ftString;     convert_as: 'BlobBytes';       col_type: ftString;    show: True),
 (sql_col: 'DNT_SIZE';                        fex_col: 'Tile Size';                         read_as: ftInteger;    convert_as: '';                col_type: ftInteger;   show: True),
 (sql_col: 'DNT_ETAG';                        fex_col: 'ETag';                              read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_LOC_IOS_APPLE_MAPS_TRIPS: TSQL_Table_array = (
 (sql_col: 'DNT_ZROUTEREQUESTSTORAGE';        fex_col: 'Route Request Storage BLOB';        read_as: ftBytes;      convert_as: '';                col_type: ftString;    show: False),
 (sql_col: 'DNT_ZMAPITEMSTORAGE';             fex_col: 'Map Item Storage BLOB';             read_as: ftBytes;      convert_as: '';                col_type: ftString;    show: False),
 (sql_col: 'DNT_ZCREATETIME';                 fex_col: 'Date Created';                      read_as: ftLargeInt;   convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_Z_PK';                        fex_col: 'Z_PK';                              read_as: ftInteger;    convert_as: '';                col_type: ftInteger;   show: True),
 (sql_col: 'DNT_SEARCHTYPE';                  fex_col: 'Search Type';                       read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ZQUERY';                      fex_col: 'Query';                             read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ZLOCATIONDISPLAY';            fex_col: 'Location City';                     read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ZLONGITUDE1';                 fex_col: 'Longitude';                         read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ZLATITUDE1';                  fex_col: 'Latitude';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_LOC_IOS_CACHED_LOCATIONS: TSQL_Table_array = (
 (sql_col: 'DNT_ZTIMESTAMP';                  fex_col: 'Timestamp';                         read_as: ftFloat;      convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_ZLATITUDE';                   fex_col: 'Latitude';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ZLONGITUDE';                  fex_col: 'Longitude';                         read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ZHORIZONTALACCURACY';         fex_col: 'Horizontal Accuracy (m)';           read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ZALTITUDE';                   fex_col: 'Altitude (m)';                      read_as: ftFloat;      convert_as: '';                col_type: ftFloat;     show: True),
 (sql_col: 'DNT_ZVERTICALACCURACY';           fex_col: 'Vertical Accuracy (m)';             read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_LOC_IOS_CARPLAY: TSQL_Table_array = (
 (sql_col: 'DNT_NAME';                        fex_col: 'Car Name';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_BLUETOOTHADDRESS';            fex_col: 'BlueTooth Address';                 read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_CARPLAYWIFIUUID';             Fex_col: 'Wifi UUID';                         read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_LOC_IOS_CELLTOWER_LOCATIONS: TSQL_Table_array = (
 (sql_col: 'DNT_TIMESTAMP';                  fex_col: 'Timestamp';                         read_as: ftFloat;      convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_LATITUDE';                   fex_col: 'Latitude';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_LONGITUDE';                  fex_col: 'Longitude';                         read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_HORIZONTALACCURACY';         fex_col: 'Horizontal Accuracy (m)';           read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ALTITUDE';                   fex_col: 'Altitude (m)';                      read_as: ftFloat;      convert_as: '';                col_type: ftFloat;     show: True),
 (sql_col: 'DNT_VERTICALACCURACY';           fex_col: 'Vertical Accuracy (m)';             read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_LOC_IOS_FINDMYDEVICE: TSQL_Table_array = (
{1}(sql_col: 'DNT_item';                      fex_col: 'Item';                              read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
{2}(sql_col: 'DNT_name';                      fex_col: 'Device Name';                       read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
{3}(sql_col: 'DNT_deviceDisplayName';         fex_col: 'Display Name';                      read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
{4}(sql_col: 'DNT_deviceModel';               fex_col: 'Device Model';                      read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
{5}(sql_col: 'DNT_deviceDiscoveryId';         fex_col: 'Device Discovery ID';               read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
{6}(sql_col: 'DNT_id';                        fex_col: 'Device ID';                         read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
{7}(sql_col: 'DNT_mapItemFullAddress';        fex_col: 'Map Item Full Address';             read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
{8}(sql_col: 'DNT_administrativeArea';        fex_col: 'Administrative Area';               read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
{9}(sql_col: 'DNT_timeStamp';                 fex_col: 'Timestamp';                         read_as: ftLargeInt;   convert_as: 'UNIX_MS';         col_type: ftDateTime;  show: True),
{10}(sql_col: 'DNT_latitude';                 fex_col: 'Latitude';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
{11}(sql_col: 'DNT_longitude';                fex_col: 'Longitude';                         read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
{12}(sql_col: 'DNT_latitude';                 fex_col: 'Crowd Sourced Latitude';            read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
{13}(sql_col: 'DNT_longitude';                fex_col: 'Crowd Sourced Longitude';           read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_LOC_IOS_FINDMYITEMS: TSQL_Table_array = (
{1}(sql_col: 'DNT_TIMESTAMP';                 fex_col: 'Timestamp';                         read_as: ftLargeInt;   convert_as: 'UNIX_MS';         col_type: ftDateTime;  show: True),
{2}(sql_col: 'DNT_SERIALNUMBER';              fex_col: 'Serial';                            read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
{3}(sql_col: 'DNT_OWNER';                     fex_col: 'Owner';                             read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
{4}(sql_col: 'DNT_PART_NAME';                 fex_col: 'Part Name';                         read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
{5}(sql_col: 'DNT_DEVICENAME';                fex_col: 'Device Name';                       read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
{6}(sql_col: 'DNT_LATITUDE';                  fex_col: 'Latitude';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
{7}(sql_col: 'DNT_LONGITUDE';                 fex_col: 'Longitude';                         read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
{8}(sql_col: 'DNT_MAPITEMFULLADDRESS';        fex_col: 'Map Address';                       read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_LOC_IOS_GOOGLEMAPS_CARVE: TSQL_Table_array = (
 (sql_col: 'DNT_ADDRESS';                     fex_col: 'Address';                           read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_FILE_OFFSET';                 fex_col: 'File Offset';                       read_as: ftInteger;    convert_as: '';                col_type: ftInteger;   show: True),
 );

Array_Items_LOC_IOS_GOOGLEMAPS_TILES_CARVE: TSQL_Table_array = (
 (sql_col: 'DNT_LATITUDE';                    fex_col: 'Latitude';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_LONGITUDE';                   fex_col: 'Longitude';                         read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_XCOORDINATE';                 fex_col: 'X Coordinate (str)';                read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_YCOORDINATE';                 fex_col: 'Y Coordinate (str)';                read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ZOOM';                        fex_col: 'Zoom';                              read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_LOC_IOS_LYFT_USER: TSQL_Table_array = (
 (sql_col: 'DNT_FIRSTNAME';                   fex_col: 'Full Name';                         read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_LASTNAME';                    fex_col: 'Last Name';                         read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_EMAIL';                       fex_col: 'Email Address';                     read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_PHONENUMBER';                 fex_col: 'Phone Number';                      read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_REFERRALCODE';                fex_col: 'Referral Code';                     read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ID';                          fex_col: 'Lyft ID';                           read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_REGION';                      fex_col: 'Region';                            read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_JOINDATE';                    fex_col: 'Join Date';                         read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_PHOTOURL';                    fex_col: 'Photo URL';                         read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_EMAILVERIFIEDDATE';           fex_col: 'zLyft Email Verified Date';         read_as: ftLargeInt;   convert_as: 'UNIX_MS';        col_type: ftDateTime;    show: True),
 (sql_col: 'DNT_NUMBEROFRIDES';               fex_col: 'Number of Rides';                   read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_REFERRALCODE';                fex_col: 'Referral Code';                     read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_LOC_IOS_PARKED_CAR_LOCATIONS: TSQL_Table_array = (
 (sql_col: 'DNT_ZDATE';                       fex_col: 'Date';                              read_as: ftFloat;      convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_ZLOCLATITUDE';                fex_col: 'Latitude';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ZLOCLONGITUDE';               fex_col: 'Longitude';                         read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ZLOCUNCERTAINTY';             fex_col: 'Uncertainty';                       read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ZIDENTIFIER';                 fex_col: 'Identifier';                        read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_LOC_IOS_SIGNIFICANT_LOCATIONS_CLOUDV2: TSQL_Table_array = (
 (sql_col: 'DNT_ZCREATIONDATE';               fex_col: 'Creation Date';                     read_as: ftFloat;      convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_ZNAME';                       fex_col: 'Location Name';                     read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ZSUBTHOROUGHFARE';            fex_col: 'Address 1';                         read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ZTHOROUGHFARE';               fex_col: 'Address 2';                         read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ZLOCALITY';                   fex_col: 'City';                              read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ZADMINISTRATIVEAREA';         fex_col: 'State';                             read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ZPOSTALCODE';                 fex_col: 'Post Code';                         read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ZCOUNTRYCODE';                fex_col: 'Country Code';                      read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ZLOCLATITUDE';                fex_col: 'Latitude';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ZLOCLONGITUDE';               fex_col: 'Longitude';                         read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ZCKRECORDID';                 fex_col: 'Record ID';                         read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_LOC_IOS_SIGNIFICANT_LOCATIONS_LOCAL: TSQL_Table_array = (
 (sql_col: 'DNT_ZPLACECREATIONDATE';          fex_col: 'Created';                           read_as: ftLargeInt;   convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_ZLOCATIONLATITUDE';           fex_col: 'Latitude';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ZLOCATIONLONGITUDE';          fex_col: 'Longitude';                         read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ZLOCATIONALTITUDE';           fex_col: 'Altitude';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ZCONFIDENCE';                 fex_col: 'Confidence';                        read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_LOC_IOS_SIGNIFICANT_LOCATIONS_VISITS: TSQL_Table_array = (
 (sql_col: 'DNT_ZCREATIONDATE';               fex_col: 'Created';                           read_as: ftLargeInt;   convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_ZENTRYDATE';                  fex_col: 'Date Entry';                        read_as: ftLargeInt;   convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_ZEXITDATE';                   fex_col: 'Date Exit';                         read_as: ftLargeInt;   convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_ZLOCATIONLATITUDE';           fex_col: 'Latitude';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ZLOCATIONLONGITUDE';          fex_col: 'Longitude';                         read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ZLOCATIONALTITUDE';           fex_col: 'Altitude';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ZLOCATIONOFINTERESTCONFIDENCE'; fex_col: 'Confidence';                      read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_LOC_WAZE_FAVORITE_LOCATIONS: TSQL_Table_array = (
 (sql_col: 'DNT_ACCESS_TIME';                 fex_col: 'Access Time';                       read_as: ftLargeInt;   convert_as: 'UNIX';            col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_CREATED_TIME';                fex_col: 'Created Time';                      read_as: ftLargeInt;   convert_as: 'UNIX';            col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_NAME';                        fex_col: 'Location Name';                     read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_PLACE_ID';                    fex_col: 'Place ID';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_LOC_WAZE_RECENT_LOCATIONS: TSQL_Table_array = (
 (sql_col: 'DNT_ACCESS_TIME';                 fex_col: 'Access Time';                       read_as: ftLargeInt;   convert_as: 'UNIX';            col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_CREATED_TIME';                fex_col: 'Created Time';                      read_as: ftLargeInt;   convert_as: 'UNIX';            col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_NAME';                        fex_col: 'Location Name';                     read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_PLACE_ID';                    fex_col: 'place_id';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_LOC_WAZE_SEARCHED_LOCATIONS: TSQL_Table_array = (
 (sql_col: 'DNT_CREATED_TIME';                fex_col: 'Created Time';                      read_as: ftLargeInt;   convert_as: 'UNIX';            col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_ACCESS_TIME';                 fex_col: 'Access Time';                       read_as: ftLargeInt;   convert_as: 'UNIX';            col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_NAME';                        fex_col: 'Location Name';                     read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_HOUSE';                       fex_col: 'House';                             read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_STREET';                      fex_col: 'Street';                            read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_CITY';                        fex_col: 'City';                              read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_STATE';                       fex_col: 'State';                             read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_COUNTRY';                     fex_col: 'Country';                           read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_LATITUDE';                    fex_col: 'Latitude';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_LONGITUDE';                   fex_col: 'Longitude';                         read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_LOC_IOS_WEATHER: TSQL_Table_array = (
 (sql_col: 'DNT_LASTUPDATED';                 fex_col: 'Last Updated';                      read_as: ftFloat;      convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_WEATHER_NAME';                fex_col: 'Weather Name';                      read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_COUNTRY';                     fex_col: 'Country';                           read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_TIMEZONE';                    fex_col: 'Timezone';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_LATITUDE';                    fex_col: 'Latitude';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_LONGITUDE';                   fex_col: 'Longitude';                         read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_LOC_IOS_WIFI_LOCATIONS: TSQL_Table_array = (
 (sql_col: 'DNT_TIMESTAMP';                   fex_col: 'Timestamp';                         read_as: ftFloat;      convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_MAC';                         fex_col: 'MAC Address';                       read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_CHANNEL';                     fex_col: 'Channel';                           read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_LATITUDE';                    fex_col: 'Latitude';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_LONGITUDE';                   fex_col: 'Longitude';                         read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_HORIZONTALACCURACY';          fex_col: 'Accuracy (meters)';                 read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_CONFIDENCE';                  fex_col: 'Confidence';                        read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_NULL: TSQL_Table_array = (
 (sql_col: '';
 fex_col: '';
 read_as: ftString;
 convert_as: '';
 col_type: ftString;
 show: false));

begin
   if Name = 'LOC_AND_AIRTAG_PERSONAL_SAFETY'              then Result := Array_Items_LOC_AND_AIRTAG_PERSONAL_SAFETY else
   if Name = 'LOC_AND_AIRTAG_PERSONAL_SAFETY_ALERTS'       then Result := Array_Items_LOC_AND_AIRTAG_PERSONAL_SAFETY_ALERTS else
   if Name = 'LOC_AND_AIRTAG_PERSONAL_SAFETY_LAST_SCAN'    then Result := Array_Items_LOC_AND_AIRTAG_PERSONAL_SAFETY_LAST_SCAN else
   if Name = 'LOC_AND_GOOGLEMAPS_SEARCHES'                 then Result := Array_Items_LOC_AND_GOOGLEMAPS_SEARCHES else
   if Name = 'LOC_AND_LIFE360_LOCATIONS'                   then Result := Array_Items_LOC_AND_LIFE360_LOCATIONS else
   if Name = 'LOC_IOS_AIRTAG_INFO'                         then Result := Array_Items_LOC_IOS_AIRTAG_INFO else
   if Name = 'LOC_IOS_APPLE_MAPS_HISTORY'                  then Result := Array_Items_LOC_IOS_APPLE_MAPS_HISTORY else
   if Name = 'LOC_IOS_APPLE_MAPS_SEARCHES'                 then Result := Array_Items_LOC_IOS_APPLE_MAPS_SEARCHES else
   if Name = 'LOC_IOS_APPLE_MAPS_TILES'                    then Result := Array_Items_LOC_IOS_APPLE_MAPS_TILES else
   if Name = 'LOC_IOS_APPLE_MAPS_TRIPS'                    then Result := Array_Items_LOC_IOS_APPLE_MAPS_TRIPS else
   if Name = 'LOC_IOS_CACHED_LOCATIONS'                    then Result := Array_Items_LOC_IOS_CACHED_LOCATIONS else
   if Name = 'LOC_IOS_CARPLAY'                             then Result := Array_Items_LOC_IOS_CARPLAY else
   if Name = 'LOC_IOS_CELLTOWER_LOCATIONS'                 then Result := Array_Items_LOC_IOS_CELLTOWER_LOCATIONS else
   if Name = 'LOC_IOS_FINDMYDEVICE'                        then Result := Array_Items_LOC_IOS_FINDMYDEVICE else
   if Name = 'LOC_IOS_FINDMYITEMS'                         then Result := Array_Items_LOC_IOS_FINDMYITEMS else
   if Name = 'LOC_IOS_GOOGLEMAPS_CARVE'                    then Result := Array_Items_LOC_IOS_GOOGLEMAPS_CARVE else
   if Name = 'LOC_IOS_GOOGLEMAPS_TILES_CARVE'              then Result := Array_Items_LOC_IOS_GOOGLEMAPS_TILES_CARVE else
   if Name = 'LOC_IOS_LYFT_USER'                           then Result := Array_Items_LOC_IOS_LYFT_USER else
   if Name = 'LOC_IOS_PARKED_CAR_LOCATIONS'                then Result := Array_Items_LOC_IOS_PARKED_CAR_LOCATIONS else
   if Name = 'LOC_IOS_SIGNIFICANT_LOCATIONS_CLOUDV2'       then Result := Array_Items_LOC_IOS_SIGNIFICANT_LOCATIONS_CLOUDV2 else
   if Name = 'LOC_IOS_SIGNIFICANT_LOCATIONS_LOCAL'         then Result := Array_Items_LOC_IOS_SIGNIFICANT_LOCATIONS_LOCAL else
   if Name = 'LOC_IOS_SIGNIFICANT_LOCATIONS_VISITS'        then Result := Array_Items_LOC_IOS_SIGNIFICANT_LOCATIONS_VISITS else
   if Name = 'LOC_IOS_WEATHER'                             then Result := Array_Items_LOC_IOS_WEATHER else
   if Name = 'LOC_IOS_WIFI_LOCATIONS'                      then Result := Array_Items_LOC_IOS_WIFI_LOCATIONS else
   if Name = 'LOC_WAZE_FAVORITE_LOCATIONS'                 then Result := Array_Items_LOC_WAZE_FAVORITE_LOCATIONS else
   if Name = 'LOC_WAZE_RECENT_LOCATIONS'                   then Result := Array_Items_LOC_WAZE_RECENT_LOCATIONS else
   if Name = 'LOC_WAZE_SEARCHED_LOCATIONS'                 then Result := Array_Items_LOC_WAZE_SEARCHED_LOCATIONS else
  begin
    Result := Array_Items_NULL;
    {$IF DEFINED (ISFEXGUI)}
    ShowMessage('Location' + ':' + #13#10 + #13#10 + 'Did not locate artifact column layout:' + #13#10 + #13#10 + Name);
    {$IFEND}
    Progress.Log(format('%-54s %-100s', ['Error: Did not locate artifact column layout:', Name]));
  end;
end;
end.
