﻿unit OS_MAC_Columns;

interface

uses
  {$IF DEFINED (ISFEXGUI)}
  GUI,
  {$IFEND}
  Columns, DataStorage, SysUtils;

function GetTable(const Name : string) : TSQL_Table_array;

implementation

function GetTable(const Name : string) : TSQL_Table_array;
const

Array_Items_DNT_ADDRESSBOOKME: TSQL_Table_array = ( // AddressBookMe - MAC - "The actual entry for the suspect gathered during the Apple registration of Leopard" Chapter9, 231
  (sql_col: 'DNT_FirstName';                 fex_col: 'First Name';              read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_LastName';                  fex_col: 'Last Name';               read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_ExistingEmailAddress';      fex_col: 'Existing Email Address';  read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_City';                      fex_col: 'City';                    read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_Company';                   fex_col: 'Company';                 read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_CountryName';               fex_col: 'Country Name';            read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_LocalPhoneNumber';          fex_col: 'Local Phone Number';      read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_StateProv';                 fex_col: 'State';                   read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_StreetAddr1';               fex_col: 'Street Address 1';        read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_StreetAddr2';               fex_col: 'Street Address 2';        read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_ZipPostal';                 fex_col: 'Zip Code';                read_as: ftString;  convert_as: '';   col_type: ftString;       show: True));

Array_Items_DNT_ATTACHEDIDEVICES: TSQL_Table_array = ( // Attached iDevices - MAC
  (sql_col: 'DNT_Device Class';              fex_col: 'Device Class';            read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_ID';                        fex_col: 'Device ID';               read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_Serial Number';             fex_col: 'Serial Number';           read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_IMEI';                      fex_col: 'IMEI';                    read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_Firmware Version String';   fex_col: 'Firmware Version String'; read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_Use Count';                 fex_col: 'Use Count';               read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_Connected';                 fex_col: 'Connected Date';          read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_Family ID';                 fex_col: 'Family ID';               read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_Firmware Version';          fex_col: 'Firmware Version';        read_as: ftString;  convert_as: '';   col_type: ftString;       show: True));

Array_Items_DNT_BLUETOOTH: TSQL_Table_array = ( // Bluetooth - MAC
  (sql_col: 'DNT_MAC Address';               fex_col: 'MAC Address';          read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_Name';                      fex_col: 'Bluetooth Name';       read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_ModelIdentifier';           fex_col: 'Model Identifier';     read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_Manufacturer';              fex_col: 'Manufacturer';         read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_LastServicesUpdate';        fex_col: 'Last Services Update'; read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_LastNameUpdate';            fex_col: 'Last Name Update';     read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_LastInquiryUpdate';         fex_col: 'Last Inquiry Update';  read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_ClockOffset';               fex_col: 'Clock Offset';         read_as: ftString;  convert_as: '';   col_type: ftString;       show: True));

Array_Items_DNT_MAC_DHCP: TSQL_Table_array = ( // DHCP - MAC
  (sql_col: 'DNT_LEASESTARTDATE';            fex_col: 'Lease Start Date';        read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_IPADDRESS';                 fex_col: 'IP Address';              read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_ROUTERHARDWAREADDRESS';     fex_col: 'Router Hardware Address'; read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_ROUTERIPADDRESS';           fex_col: 'Router IP Address';       read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_LEASELENGTH';               fex_col: 'Lease Length';            read_as: ftString;  convert_as: '';   col_type: ftString;       show: True));

Array_Items_DNT_DOCK: TSQL_Table_array = ( // Dock Items - MAC
  (sql_col: 'DNT__file-label';               fex_col: 'Dock Item';            read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT__CFURLString';              fex_col: 'Dock File';            read_as: ftString;  convert_as: '';   col_type: ftString;       show: True));

Array_Items_DNT_ICLOUD: TSQL_Table_array = ( // iCloud User Preferences - MAC
  (sql_col: 'DNT_DisplayName';               fex_col: 'Display Name';         read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_firstName';                 fex_col: 'First Name';           read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_lastName';                  fex_col: 'Last Name';            read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_AccountID';                 fex_col: 'Account ID';           read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_AccountUUID';               fex_col: 'Account UUID';         read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_AccountDescription';        fex_col: 'Account Description';  read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_IsPaidAccount';             fex_col: 'Is Paid Account';      read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_LoggedIn';                  fex_col: 'Logged In';            read_as: ftString;  convert_as: '';   col_type: ftString;       show: True));

Array_Items_DNT_IMESSAGE: TSQL_Table_array = ( // iMessage Accounts - MAC
  (sql_col: 'DNT_AuthID';                    fex_col: 'AuthID';               read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_LoginAs';                   fex_col: 'Login As';             read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_DisplayName';               fex_col: 'Display Name';         read_as: ftString;  convert_as: '';   col_type: ftString;       show: True));

Array_Items_DNT_INSTALLATIONDATE: TSQL_Table_array = ( // Installation Time - MAC ("Empty file. Its last modification time represent the date/time the OS was installed")
  (sql_col: 'DNT_InstallationTime';          fex_col: 'Installation Date';    read_as: ftString;  convert_as: '';   col_type: ftString;       show: True));

Array_Items_DNT_INSTALLEDPRINTERS: TSQL_Table_array = ( // Installed Printers - MAC
  (sql_col: 'DNT_InstalledPrinter';          fex_col: 'Printer';              read_as: ftString;  convert_as: '';   col_type: ftString;       show: True));

Array_Items_DNT_LASTSLEEP: TSQL_Table_array = ( // Last Sleep - MAC
  (sql_col: 'DNT_LastSleep';                 fex_col: 'Last Sleep';           read_as: ftString;  convert_as: '';   col_type: ftString;       show: True));

Array_Items_DNT_LOGINITEMS: TSQL_Table_array = ( // Login Items - MAC
  (sql_col: 'DNT_Name';                      fex_col: 'Item Name';            read_as: ftString;  convert_as: '';   col_type: ftString;       show: True));

Array_Items_DNT_LOGINWINDOW: TSQL_Table_array = ( // Login Window - MAC
  (sql_col: 'DNT_lastUser';                  fex_col: 'Last User';            read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_RetriesUntilHint';          fex_col: 'Retries Until Hint';   read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_lastUserName';              fex_col: 'Last User Name';       read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_autoLoginUser';             fex_col: 'Auto Login User';      read_as: ftString;  convert_as: '';   col_type: ftString;       show: True));

Array_Items_DNT_MAIL_BACKUPTOC: TSQL_Table_array = ( // Mail BackupTOC - MAC
  (sql_col: 'DNT_Type';                      fex_col: 'Type';                 read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_Path';                      fex_col: 'Path';                 read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_Account-ID';                fex_col: 'Account-ID';           read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_Display-Name';              fex_col: 'Display-Name';         read_as: ftString;  convert_as: '';   col_type: ftString;       show: True));

Array_Items_DNT_MAILFOLDER: TSQL_Table_array = ( // Mail Folder - MAC
  (sql_col: 'DNT_MailFolder';                fex_col: 'Mail Folder';          read_as: ftString;  convert_as: '';   col_type: ftString;       show: True));

Array_Items_DNT_KNOWNNETWORKS: TSQL_Table_array = ( // Networks - Known Networks
  (sql_col: 'DNT_SSID_STR';                  fex_col: 'SSID String';          read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_SecurityType';              fex_col: 'Security Type';        read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_Unique Password ID';        fex_col: 'Unique Password ID';   read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT__timeStamp';                fex_col: 'TimeStamp String';     read_as: ftString;  convert_as: '';   col_type: ftString;       show: True));

Array_Items_DNT_RECENTNETWORKS: TSQL_Table_array = ( // Networks - Recent Networks
  (sql_col: 'DNT_SSID_STR';                  fex_col: 'SSID String';          read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_SecurityType';              fex_col: 'Security Type';        read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_Unique Network ID';         fex_col: 'Unique Network ID';    read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_Unique Password ID';        fex_col: 'Unique Password ID';   read_as: ftString;  convert_as: '';   col_type: ftString;       show: True));

Array_Items_DNT_OSXUPDATE: TSQL_Table_array = ( // OSX Update - MAC
  (sql_col: 'DNT_LastSuccessfulDate';        fex_col: 'Last Successful Date'; read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_LastAttemptDate';           fex_col: 'Last Attempt Date';    read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_LastresultCode';            fex_col: 'Last Result Code';     read_as: ftString;  convert_as: '';   col_type: ftString;       show: True));

Array_Items_DNT_MAC_PREFERENCES: TSQL_Table_array = ( // Preferences - MAC
  (sql_col: 'DNT_CURRENTSET';                fex_col: 'Current Set';          read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_LOCALHOSTNAME';             fex_col: 'Local Host Name';      read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_COMPUTERNAME';              fex_col: 'Computer Name';        read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_MODEL';                     fex_col: 'Model';                read_as: ftString;  convert_as: '';   col_type: ftString;       show: True));

Array_Items_DNT_PRINTERS_CUPS: TSQL_Table_array = ( // Printers (CUPS) - MAC
  (sql_col: 'DNT_printer-name';              fex_col: 'Printer Name';         read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_printer-info';              fex_col: 'Printer Info';         read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_printer-make-and-model';    fex_col: 'Printer Make/Model';   read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_printer-location';          fex_col: 'Printer Location';     read_as: ftString;  convert_as: '';   col_type: ftString;       show: True));

Array_Items_DNT_PRINTERS_CUPS_CONTROL: TSQL_Table_array = ( // Printers (CUPS - Control) - MAC
  // Use sql_col to store the regex
  (sql_col: 'DNT_(?<!-)time-at-creation';      fex_col: 'Creation Time';            read_as: ftString;  convert_as: '';   col_type: ftDateTime;     show: True),
  (sql_col: 'DNT_job-name';                    fex_col: 'Job Name';                 read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_job-originating-user-name';   fex_col: 'Job Originating Username'; read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_PMJobOwner';                  fex_col: 'Job Owner';                read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_attributes-charset';          fex_col: 'CharSet';                  read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_natural-language';            fex_col: 'Natural Language';         read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_printer-uri';                 fex_col: 'Printer Uri';              read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_DestinationPrinterID';        fex_col: 'Destination Printer ID';   read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_job-printer-state-message';   fex_col: 'Job Status Message';       read_as: ftString;  convert_as: '';   col_type: ftString;       show: True));

Array_Items_DNT_RECENTITEMSAPPLICATIONS: TSQL_Table_array = ( // Recent Applications - MAC
  (sql_col: 'DNT_Name';                      fex_col: 'Application';          read_as: ftString;  convert_as: '';   col_type: ftString;       show: True));

Array_Items_DNT_RECENTITEMSDOCUMENTS: TSQL_Table_array = ( // Recent Documents - MAC
  (sql_col: 'DNT_Name';                      fex_col: 'Document Name';        read_as: ftString;  convert_as: '';   col_type: ftString;       show: True));

Array_Items_DNT_RECENTITEMSHOSTS: TSQL_Table_array = ( // Recent Hosts - MAC
  (sql_col: 'DNT_Url';                       fex_col: 'URL';                  read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_Name';                      fex_col: 'Hosts';                read_as: ftString;  convert_as: '';   col_type: ftString;       show: True));

Array_Items_DNT_RECENTIWORKNUMBERS: TSQL_Table_array = ( // Recent iWork Numbers - MAC
  (sql_col: 'DNT_Name';                      fex_col: 'Numbers Name';         read_as: ftString;  convert_as: '';   col_type: ftString;       show: True));

Array_Items_DNT_RECENTIWORKPAGES: TSQL_Table_array = ( // Recent iWork Pages - MAC
  (sql_col: 'DNT_Name';                      fex_col: 'Pages Name';           read_as: ftString;  convert_as: '';   col_type: ftString;       show: True));

Array_Items_DNT_PHOTOBOOTHRECENTS: TSQL_Table_array = ( // Recent Photo Booth - MAC
  (sql_col: 'DNT_FileName';                  fex_col: 'File Name';            read_as: ftString;  convert_as: '';   col_type: ftString;       show: True));

Array_Items_DNT_PREVIEWRECENTITEMS: TSQL_Table_array = ( // Recent Preview - MAC
  (sql_col: 'DNT_Name';                      fex_col: 'Preview Name';         read_as: ftString;  convert_as: '';   col_type: ftString;       show: True));

Array_Items_DNT_QUICKTIMERECENTITEMS: TSQL_Table_array = ( // Recent QuickTime - MAC
  (sql_col: 'DNT_Name';                      fex_col: 'QuickTime Name';       read_as: ftString;  convert_as: '';   col_type: ftString;       show: True));

Array_Items_DNT_TEXTEDITRECENTITEMS: TSQL_Table_array = ( // Recent TextEdit - MAC
  (sql_col: 'DNT_Name';                      fex_col: 'TextEdit Name';        read_as: ftString;  convert_as: '';   col_type: ftString;       show: True));

Array_Items_DNT_VIDEOLANRECENTITEMS: TSQL_Table_array = ( // Recent VLC - MAC
  (sql_col: 'DNT_Name';                      fex_col: 'VLC Name';             read_as: ftString;  convert_as: '';   col_type: ftString;       show: True));

Array_Items_DNT_SYSTEMVERSION: TSQL_Table_array = ( // System Version - MAC
  (sql_col: 'DNT_ProductBuildVersion';       fex_col: 'Product Build Version';read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_ProductCopyright';          fex_col: 'Product Copyright';    read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_ProductName';               fex_col: 'Product Name';         read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_ProductCopyright';          fex_col: 'Product Version';      read_as: ftString;  convert_as: '';   col_type: ftString;       show: True));

Array_Items_DNT_SAFARIPREFERENCES: TSQL_Table_array = ( // Safari - Preferences
  (sql_col: 'DNT_DownloadsPath';             fex_col: 'Downloads Path';       read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_HomePage';                  fex_col: 'Safari Home Page';     read_as: ftString;  convert_as: '';   col_type: ftString;       show: True));

Array_Items_DNT_RECENTSAFARIWEBSEARCHES: TSQL_Table_array = ( // Safari - Recent Web Searches
  (sql_col: 'DNT_SearchString';              fex_col: 'Search String';        read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_Date';                      fex_col: 'Search Date';          read_as: ftString;  convert_as: '';   col_type: ftString;       show: True));

Array_Items_DNT_TIMEZONE: TSQL_Table_array = ( // Timezone - MAC
  (sql_col: 'DNT_TimeZoneName';              fex_col: 'Time Zone Name';       read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_Name';                      fex_col: 'City Name';            read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_CountryCode';               fex_col: 'Country Code';         read_as: ftString;  convert_as: '';   col_type: ftString;       show: True));

Array_Items_DNT_LOCALTIME: TSQL_Table_array = ( // Timezone Local - MAC
  (sql_col: 'DNT_TimeZoneLocal';             fex_col: 'Time Zone Local';      read_as: ftString;  convert_as: '';   col_type: ftString;       show: True));

Array_Items_DNT_USER_ACCOUNTS_DELETED: TSQL_Table_array = ( // User Accounts Deleted - MAC
  (sql_col: 'DNT_date';                          fex_col: 'Date';             read_as: ftString;  convert_as: '';   col_type: ftDateTime;     show: True),
  (sql_col: 'DNT_dsAttrTypeStandard:RealName';   fex_col: 'RealName';         read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_dsAttrTypeStandard:UniqueID';   fex_col: 'UniqueID';         read_as: ftInteger; convert_as: '';   col_type: ftInteger;      show: True),
  (sql_col: 'DNT_name';                          fex_col: 'User Name';        read_as: ftString;  convert_as: '';   col_type: ftString;       show: True));

Array_Items_DNT_MAC_WIFI: TSQL_Table_array = ( // Wifi - MAC
  (sql_col: 'DNT_SSID_STR';                  fex_col: 'SSID_STR';             read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_BSSID';                     fex_col: 'BSSID';                read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_WEP';                       fex_col: 'WEP';                  read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_ADDED_AT';                  fex_col: 'Added At';             read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_ADDED_BY';                  fex_col: 'Added By';             read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
  (sql_col: 'DNT_ENABLED';                   fex_col: 'Enabled';              read_as: ftString;  convert_as: '';   col_type: ftString;       show: True));

Array_Items_NULL: TSQL_Table_array = (
  (sql_col: '';
  fex_col: '';
  read_as: ftString;
  convert_as: '';
  col_type: ftString;
  show: false));

begin
  if Name = 'DNT_ADDRESSBOOKME'           then Result := Array_Items_DNT_ADDRESSBOOKME else
  if Name = 'DNT_ATTACHEDIDEVICES'        then Result := Array_Items_DNT_ATTACHEDIDEVICES else
  if Name = 'DNT_BLUETOOTH'               then Result := Array_Items_DNT_BLUETOOTH else
  if Name = 'DNT_MAC_DHCP'                then Result := Array_Items_DNT_MAC_DHCP else
  if Name = 'DNT_DOCK'                    then Result := Array_Items_DNT_DOCK else
  if Name = 'DNT_ICLOUD'                  then Result := Array_Items_DNT_ICLOUD else
  if Name = 'DNT_IMESSAGE'                then Result := Array_Items_DNT_IMESSAGE else
  if Name = 'DNT_INSTALLATIONDATE'        then Result := Array_Items_DNT_INSTALLATIONDATE else
  if Name = 'DNT_INSTALLEDPRINTERS'       then Result := Array_Items_DNT_INSTALLEDPRINTERS else
  if Name = 'DNT_LASTSLEEP'               then Result := Array_Items_DNT_LASTSLEEP else
  if Name = 'DNT_LOGINITEMS'              then Result := Array_Items_DNT_LOGINITEMS else
  if Name = 'DNT_LOGINWINDOW'             then Result := Array_Items_DNT_LOGINWINDOW else
  if Name = 'DNT_MAIL_BACKUPTOC'          then Result := Array_Items_DNT_MAIL_BACKUPTOC else
  if Name = 'DNT_MAILFOLDER'              then Result := Array_Items_DNT_MAILFOLDER else
  if Name = 'DNT_KNOWNNETWORKS'           then Result := Array_Items_DNT_KNOWNNETWORKS else
  if Name = 'DNT_RECENTNETWORKS'          then Result := Array_Items_DNT_RECENTNETWORKS else
  if Name = 'DNT_OSXUPDATE'               then Result := Array_Items_DNT_OSXUPDATE else
  if Name = 'DNT_MAC_PREFERENCES'         then Result := Array_Items_DNT_MAC_PREFERENCES else
  if Name = 'DNT_PRINTERS_CUPS'           then Result := Array_Items_DNT_PRINTERS_CUPS else
  if Name = 'DNT_PRINTERS_CUPS_CONTROL'   then Result := Array_Items_DNT_PRINTERS_CUPS_CONTROL else
  if Name = 'DNT_RECENTITEMSAPPLICATIONS' then Result := Array_Items_DNT_RECENTITEMSAPPLICATIONS else
  if Name = 'DNT_RECENTITEMSDOCUMENTS'    then Result := Array_Items_DNT_RECENTITEMSDOCUMENTS else
  if Name = 'DNT_RECENTITEMSHOSTS'        then Result := Array_Items_DNT_RECENTITEMSHOSTS else
  if Name = 'DNT_RECENTIWORKNUMBERS'      then Result := Array_Items_DNT_RECENTIWORKNUMBERS else
  if Name = 'DNT_RECENTIWORKPAGES'        then Result := Array_Items_DNT_RECENTIWORKPAGES else
  if Name = 'DNT_PHOTOBOOTHRECENTS'       then Result := Array_Items_DNT_PHOTOBOOTHRECENTS else
  if Name = 'DNT_PREVIEWRECENTITEMS'      then Result := Array_Items_DNT_PREVIEWRECENTITEMS else
  if Name = 'DNT_QUICKTIMERECENTITEMS'    then Result := Array_Items_DNT_QUICKTIMERECENTITEMS else
  if Name = 'DNT_TEXTEDITRECENTITEMS'     then Result := Array_Items_DNT_TEXTEDITRECENTITEMS else
  if Name = 'DNT_VIDEOLANRECENTITEMS'     then Result := Array_Items_DNT_VIDEOLANRECENTITEMS else
  if Name = 'DNT_SYSTEMVERSION'           then Result := Array_Items_DNT_SYSTEMVERSION else
  if Name = 'DNT_SAFARIPREFERENCES'       then Result := Array_Items_DNT_SAFARIPREFERENCES else
  if Name = 'DNT_RECENTSAFARIWEBSEARCHES' then Result := Array_Items_DNT_RECENTSAFARIWEBSEARCHES else
  if Name = 'DNT_TIMEZONE'                then Result := Array_Items_DNT_TIMEZONE else
  if Name = 'DNT_LOCALTIME'               then Result := Array_Items_DNT_LOCALTIME else
  if Name = 'DNT_USER_ACCOUNTS_DELETED'   then Result := Array_Items_DNT_USER_ACCOUNTS_DELETED else
  if Name = 'DNT_MAC_WIFI'                then Result := Array_Items_DNT_MAC_WIFI else
  begin
    Result := Array_Items_NULL;
    {$IF DEFINED (ISFEXGUI)}
    ShowMessage('OS_MAC_Columns' + ':' + #13#10 + #13#10 + 'Did not locate artifact column layout:' + #13#10 + #13#10 + Name);
    {$IFEND}
    Progress.Log(format('%-54s %-100s', ['Error: Did not locate artifact column layout:', Name]));
  end;
end;
end.
