﻿unit SocialMedia_Columns;

interface

uses
  {$IF DEFINED (ISFEXGUI)}
  GUI,
  {$IFEND}
  Columns, DataStorage, SysUtils;

function GetTable(const Name : string) : TSQL_Table_array;

implementation

function GetTable(const Name : string) : TSQL_Table_array;
const

Array_Items_SME_AND_FACEBOOK_MESSENGER_FRIENDS: TSQL_Table_array = ( // Facebook Friends
 (sql_col: 'DNT_Uid';                         fex_col: 'Uid';                                        read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_Name';                        fex_col: 'Name Col';                                   read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_first_name';                  fex_col: 'First Name';                                 read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_middle_name';                 fex_col: 'Middle Name';                                read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_last_name';                   fex_col: 'Last Name';                                  read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_contact_email';               fex_col: 'Contact Email';                              read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_Phones';                      fex_col: 'Phones';                                     read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_profile_url';                 fex_col: 'Profile Url';                                read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_is_pushable';                 fex_col: 'Is Pushable';                                read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_has_messenger';               fex_col: 'Has Messenger';                              read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_communication_rank';          fex_col: 'Communication Rank';                         read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_birthday_date';               fex_col: 'Birthday Date';                              read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                                   read_as: ftString;      convert_as: '';         col_type: ftString;     show: True));

Array_Items_SME_AND_FACEBOOK_MESSENGER_FRIEND_REQUESTS: TSQL_Table_array = ( // Facebook Friend Requests
 (sql_col: 'DNT_uid_from';                    fex_col: 'Uid From';                                   read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_Time';                        fex_col: 'Time';                                       read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_Unread';                      fex_col: 'Unread';                                     read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_Name';                        fex_col: 'Name Col';                                   read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_affiliations_name';           fex_col: 'Affiliations Name';                          read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                                   read_as: ftString;      convert_as: '';         col_type: ftString;     show: True));

Array_Items_SME_AND_FACEBOOK_MESSENGER_MESSAGES: TSQL_Table_array = ( // Facebook Messages
 (sql_col: 'DNT_Id';                          fex_col: 'ID Col';                                     read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_thread_id';                   fex_col: 'Thread Id';                                  read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_Body';                        fex_col: 'Body';                                       read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_Sender';                      fex_col: 'Sender';                                     read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_Tags';                        fex_col: 'Tags';                                       read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_Timestamp';                   fex_col: 'Timestamp';                                  read_as: ftLargeInt;    convert_as: 'UNIX';     col_type: ftDateTime;   show: True),
 (sql_col: 'DNT_action_id';                   fex_col: 'Action Id';                                  read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_offline_id';                  fex_col: 'Offline Id';                                 read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_Coordinates';                 fex_col: 'Coordinates';                                read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_Attachments';                 fex_col: 'Attachments';                                read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_Shares';                      fex_col: 'Shares';                                     read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_Type';                        fex_col: 'Type';                                       read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_State';                       fex_col: 'State';                                      read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_send_timestamp';              fex_col: 'Send Timestamp';                             read_as: ftLargeInt;    convert_as: 'UNIX';     col_type: ftDateTime;   show: True),
 (sql_col: 'DNT_server_timestamp';            fex_col: 'Server Timestamp';                           read_as: ftLargeInt;    convert_as: 'UNIX';     col_type: ftDateTime;   show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                                   read_as: ftString;      convert_as: '';         col_type: ftString;     show: True));

Array_Items_SME_AND_FACEBOOK_MESSENGER_NOTIFICATIONS: TSQL_Table_array = ( // Facebook Notifications
 (sql_col: 'DNT_notification_id';             fex_col: 'Notification Id';                            read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_object_id';                   fex_col: 'Object Id';                                  read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_object_type';                 fex_col: 'Object Type';                                read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_sender_id';                   fex_col: 'Sender Id';                                  read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_title_text';                  fex_col: 'Title Text';                                 read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_title_html';                  fex_col: 'Title Html';                                 read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_icon_url';                    fex_col: 'Icon Url';                                   read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_Href';                        fex_col: 'Href';                                       read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_Unread';                      fex_col: 'Unread';                                     read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_updated_time';                fex_col: 'Updated Time';                               read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_created_time';                fex_col: 'FB Created Time';                            read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_join_data';                   fex_col: 'Join Data';                                  read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                                   read_as: ftString;      convert_as: '';         col_type: ftString;     show: True));

Array_Items_SME_AND_FACEBOOK_MESSENGER_STORIES: TSQL_Table_array = ( // Facebook Stories
 (sql_col: 'DNT_Id';                          fex_col: 'ID Col';                                     read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_Hidden';                      fex_col: 'Hidden';                                     read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_facebook_sub_type';           fex_col: 'Facebook Sub Type';                          read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_attached_story_id';           fex_col: 'Attached Story Id';                          read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_display_explanation';         fex_col: 'Display Explanation';                        read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_sponsored_data';              fex_col: 'Sponsored Data';                             read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_feedback_id';                 fex_col: 'Feedback Id';                                read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_cache_id';                    fex_col: 'Cache Id';                                   read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_can_viewer_delete';           fex_col: 'Can Viewer Delete';                          read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_can_viewer_edit';             fex_col: 'Can Viewer Edit';                            read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_creation_time';               fex_col: 'Creation Time';                              read_as: ftLargeInt;    convert_as: 'UNIX';     col_type: ftDateTime;   show: True),
 (sql_col: 'DNT_has_comprehensive_title';     fex_col: 'Has Comprehensive Title';                    read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_Url';                         fex_col: 'URL';                                        read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_hideable_token';              fex_col: 'Hideable Token';                             read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_Tracking';                    fex_col: 'Tracking';                                   read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_To';                          fex_col: 'To';                                         read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_Via';                         fex_col: 'Via';                                        read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_legacy_api_story_id';         fex_col: 'Legacy Api Story Id';                        read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_legacy_story_hideable_id';    fex_col: 'Legacy Story Hideable Id';                   read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_Message';                     fex_col: 'Message';                                    read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_explicit_place_id';           fex_col: 'Explicit Place Id';                          read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_implicit_place_id';           fex_col: 'Implicit Place Id';                          read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_privacy_scope';               fex_col: 'Privacy Scope';                              read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_report_info';                 fex_col: 'Report Info';                                read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_Shareable';                   fex_col: 'Shareable';                                  read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_Title';                       fex_col: 'Title';                                      read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_Subtitle';                    fex_col: 'Subtitle';                          read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_icon_image';                  fex_col: 'Icon Image';                        read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_digital_goods';               fex_col: 'Digital Goods';                     read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_Items';                       fex_col: 'Items';                             read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_edit_history';                fex_col: 'Edit History';                      read_as: ftString;      convert_as: '';         col_type: ftString;     show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                          read_as: ftString;      convert_as: '';         col_type: ftString;     show: True));

Array_Items_SME_AND_FACEBOOK_USER_ID: TSQL_Table_array = (
 (sql_col: 'FACEBOOK_USER_ID_ANDROID';        fex_col: 'User ID';                           read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_SME_AND_FACEBOOK_MESSENGER_CONTACTS: TSQL_Table_array = (
 (sql_col: 'DNT_ADDED_TIME_MS';               fex_col: 'Created';                           read_as: ftLargeInt;   convert_as: 'UNIX_MS';         col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_LAST_FETCH_TIME_MS';          fex_col: 'Last Fetch Time';                   read_as: ftLargeInt;   convert_as: 'UNIX_MS';         col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_DISPLAY_NAME';                fex_col: 'Display Name';                      read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_FBID';                        fex_col: 'Facebook ID';                       read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_BDAY_DAY';                    fex_col: 'Birthday Day';                      read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_BDAY_MONTH';                  fex_col: 'Birthday Month';                    read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_BIG_PICTURE_URL';             fex_col: 'Picture URL';                       read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_CONTACT_ID';                  fex_col: 'Contact ID';                        read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_DATA';                        fex_col: 'Data';                              read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_TYPE';                        fex_col: 'Type';                              read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_SME_AND_TWITTER_DIRECT_MESSAGES: TSQL_Table_array = (
 (sql_col: 'DNT_conversation_entries_created';  fex_col: 'Timestamp';                       read_as: ftLargeInt;   convert_as: 'UNIX_MS';         col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_conversation_entries_data';     fex_col: 'Text';                            read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_users_username';                fex_col: 'Sender Username';                 read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_users_name';                    fex_col: 'Sender Name';                     read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_conversation_entries_user_id';  fex_col: 'Sender ID';                       read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_conversation_entries_entry_id'; fex_col: 'Conversation ID';                 read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SQLLOCATION';                   fex_col: 'Location';                        read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_SME_AND_TWITTER_SEARCH_QUERIES: TSQL_Table_array = (
 (sql_col: 'DNT_TIME';                        fex_col: 'Timestamp';                         read_as: ftLargeInt;   convert_as: 'UNIX_MS';         col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_QUERY';                       fex_col: 'Query';                             read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_QUERY_ID';                    fex_col: 'Query ID';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_SME_AND_TWITTER_STATUSES: TSQL_Table_array = (
(sql_col: 'DNT_CREATED';                      fex_col: 'Created';                           read_as: ftLargeInt;      convert_as: 'UNIX_MS';      col_type: ftDateTime;  show: True),
(sql_col: 'DNT__ID';                          fex_col: '_ID';                               read_as: ftString;        convert_as: '';             col_type: ftString;    show: True),
(sql_col: 'DNT_AUTHOR_ID';                    fex_col: 'Author ID';                         read_as: ftString;        convert_as: '';             col_type: ftString;    show: True),
(sql_col: 'DNT_CONTENT';                      fex_col: 'Content';                           read_as: ftString;        convert_as: '';             col_type: ftString;    show: True),
(sql_col: 'DNT_STATUS_ID';                    fex_col: 'Status ID';                         read_as: ftString;        convert_as: '';             col_type: ftString;    show: True),
(sql_col: 'DNT_FAVORITED';                    fex_col: 'Favorited';                         read_as: ftString;        convert_as: '';             col_type: ftString;    show: True),
(sql_col: 'DNT_LATITUDE';                     fex_col: 'Latitude';                          read_as: ftString;        convert_as: '';             col_type: ftString;    show: True),
(sql_col: 'DNT_LONGITUDE';                    fex_col: 'Longitude';                         read_as: ftString;        convert_as: '';             col_type: ftString;    show: True),
(sql_col: 'DNT_RETWEET_COUNT';                fex_col: 'Retweet Count';                     read_as: ftString;        convert_as: '';             col_type: ftString;    show: True),
(sql_col: 'DNT_SQLLOCATION';                  fex_col: 'Location';                          read_as: ftString;        convert_as: '';             col_type: ftString;    show: True),
);

Array_Items_SME_IOS_FOLLOWEDBLOG: TSQL_Table_array = (
 (sql_col: 'DNT_ZNAME';                       fex_col: 'Blog Name';                         read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ZTITLE';                      fex_col: 'Title';                             read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_SME_IOS_REBLOG: TSQL_Table_array = (
 (sql_col: 'DNT_ZCONTENT';                    fex_col: 'Content';                           read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ZREBLOGID';                   fex_col: 'Reblog ID';                         read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ZREBLOGGEDFROMID';            fex_col: 'Reblogged From ID';                 read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_SME_IOS_REDDIT_ACCOUNTS: TSQL_Table_array = (
 (sql_col: 'DNT_CREATEDUTC';                  fex_col: 'Created';                           read_as: ftLargeInt;   convert_as: 'UNIX_MS';         col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_ACCOUNTID';                   fex_col: 'Account ID';                        read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_EMAIL';                       fex_col: 'Email';                             read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_NAME';                        fex_col: 'User ID';                           read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_SME_IOS_TWITTER_DIRECT_MESSAGES: TSQL_Table_array = (
 (sql_col: 'DNT_TIMESTAMP';                   fex_col: 'Timestamp';                         read_as: ftFloat;      convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_MESSAGE';                     fex_col: 'Message';                           read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_SME_IOS_USER: TSQL_Table_array = (
 (sql_col: 'DNT_ZNAME';                       fex_col: 'User Name';                         read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ZFOLLOWINGCOUNT';             fex_col: 'Followingcount';                    read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ZLIKESCOUNT';                 fex_col: 'Likescount';                        read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_NULL: TSQL_Table_array = (
 (sql_col: '';
 fex_col: '';
 read_as: ftString;
 convert_as: '';
 col_type: ftString;
 show: false));
 
begin
   if Name = 'SME_AND_FACEBOOK_MESSENGER_FRIENDS'          then Result := Array_Items_SME_AND_FACEBOOK_MESSENGER_FRIENDS else
   if Name = 'SME_AND_FACEBOOK_MESSENGER_FRIEND_REQUESTS'  then Result := Array_Items_SME_AND_FACEBOOK_MESSENGER_FRIEND_REQUESTS else
   if Name = 'SME_AND_FACEBOOK_MESSENGER_MESSAGES'         then Result := Array_Items_SME_AND_FACEBOOK_MESSENGER_MESSAGES else
   if Name = 'SME_AND_FACEBOOK_MESSENGER_NOTIFICATIONS'    then Result := Array_Items_SME_AND_FACEBOOK_MESSENGER_NOTIFICATIONS else
   if Name = 'SME_AND_FACEBOOK_MESSENGER_STORIES'          then Result := Array_Items_SME_AND_FACEBOOK_MESSENGER_STORIES else
   if Name = 'SME_AND_FACEBOOK_USER_ID'                    then Result := Array_Items_SME_AND_FACEBOOK_USER_ID else
   if Name = 'SME_AND_FACEBOOK_MESSENGER_CONTACTS'         then Result := Array_Items_SME_AND_FACEBOOK_MESSENGER_CONTACTS else
   if Name = 'SME_AND_TWITTER_DIRECT_MESSAGES'             then Result := Array_Items_SME_AND_TWITTER_DIRECT_MESSAGES else
   if Name = 'SME_AND_TWITTER_SEARCH_QUERIES'              then Result := Array_Items_SME_AND_TWITTER_SEARCH_QUERIES else
   if Name = 'SME_AND_TWITTER_STATUSES'                    then Result := Array_Items_SME_AND_TWITTER_STATUSES else
   if Name = 'SME_IOS_FOLLOWEDBLOG'                        then Result := Array_Items_SME_IOS_FOLLOWEDBLOG else
   if Name = 'SME_IOS_REBLOG'                              then Result := Array_Items_SME_IOS_REBLOG else         
   if Name = 'SME_IOS_REDDIT_ACCOUNTS'                     then Result := Array_Items_SME_IOS_REDDIT_ACCOUNTS else
   if Name = 'SME_IOS_TWITTER_DIRECT_MESSAGES'             then Result := Array_Items_SME_IOS_TWITTER_DIRECT_MESSAGES else
   if Name = 'SME_IOS_USER'                                then Result := Array_Items_SME_IOS_USER else           
  begin
    Result := Array_Items_NULL;
    {$IF DEFINED (ISFEXGUI)}
    ShowMessage('Social Media' + ':' + #13#10 + #13#10 + 'Did not locate artifact column layout:' + #13#10 + #13#10 + Name);
    {$IFEND}
    Progress.Log(format('%-54s %-100s', ['Error: Did not locate artifact column layout:', Name]));
  end;
end;
end.
