﻿program Determine_OS;

uses
  //GUI,
  Classes, Common, DataEntry, DataStorage, Graphics, Math, SysUtils;

const
  CHAR_LENGTH = 80;
  RPAD_VALUE = 35;
  SCRIPT_NAME = 'Determine OS';
  SPACE = ' ';

// -----------------------------------------------------------------------------
// Function: GetDevice List
// -----------------------------------------------------------------------------
Procedure GetDeviceList(dTList: TList);
var
  DataStore_EV: TDatastore;
  dEntry: TEntry;
begin
  dTList.clear;
  DataStore_EV := GetDataStore(DATASTORE_EVIDENCE);
  if DataStore_EV = nil then
    Exit;
  try
    if not assigned(DataStore_EV) then
      Exit;
    dEntry := DataStore_EV.First;
    while assigned(dEntry) and (Progress.isRunning) do
    begin
      if dEntry.IsDevice then
        dTList.Add(dEntry);
      dEntry := DataStore_EV.Next;
    end;
  finally
    DataStore_EV.free;
  end;
end;

// -----------------------------------------------------------------------------
// Start of Script
// -----------------------------------------------------------------------------
var
  DataStore_FS: TDatastore;
  dEntry: TEntry;
  gDevice_TList: TList;
  i: integer;
  Return_Str: string;

begin
  DataStore_FS := GetDataStore(DATASTORE_FILESYSTEM);
  try
    gDevice_TList := TList.Create;
    try
      GetDeviceList(gDevice_TList);
      Progress.Log(StringOfChar('-', CHAR_LENGTH));
      Progress.Log('Device Count:' + SPACE + inttostr(gDevice_TList.Count));
      Progress.Log(StringOfChar('-', CHAR_LENGTH));

      for i := 0 to gDevice_TList.Count - 1 do
      begin
        if not Progress.isRunning then
          Exit;
        dEntry := TEntry(gDevice_TList[i]);
        Return_Str := DetermineOS(dEntry);
        Progress.Log(format('%-4s %-45s %-20s', [inttostr(i) + '.', dEntry.EntryName, Return_Str]));
      end;

    finally
      gDevice_TList.free;
    end;

  finally
    DataStore_FS.free;
  end;
  Progress.Log(StringOfChar('-', CHAR_LENGTH));
  Progress.Log('Script finished.');

end.
