﻿unit RunTask_AcquireMemory;

interface

uses
  Classes, Common, DataEntry, DataStorage, Graphics, Math, SysUtils;

implementation
const
  ATRY_EXCEPT_STR = 'TryExcept: '; //noslz
  CHAR_LENGTH = 80;
  RPAD_VALUE = 30;
  RUNNING = '...';
  SPACE = ' ';

// Function: Right pad text ----------------------------------------------------
function RPad(const AString: string; AChars: integer): string;
begin
  AChars := AChars - Length(AString);
  if AChars > 0 then
    Result := AString + StringOfChar(' ', AChars)
  else
    Result := AString;
end;

// Function: Get Size as String -----------------------------------------------
function GetSizeStr(Bytes: Int64): string;
const
  Description: Array [0 .. 8] of string = ('bytes', 'kb', 'mb', 'gb', 'tb', 'pb', 'eb', 'zb', 'yb');
var
  i: Integer;
begin
  i := 0;
  while Bytes > Power(1024, i + 1) do
    Inc(i);
  Result := FormatFloat('###0.##', Bytes / Power(1024, i)) + #32 + Description[i];
end;

// Function: List files in folder ----------------------------------------------
function ListFilesInFolder(path: string): string;
var
  Attr: integer;
  i: integer;
  MyFile_StringList: TStringList;
  Result_stringList: TStringList;
begin
  Attr := $00000080; //faNormal;
  Attr := faDirectory;
  MyFile_StringList := TStringList.Create;
  Result_stringList := TStringList.Create;
  try
    MyFile_StringList := GetFileList(path + 'memory*.raw', Attr);
    for i := 0 to MyFile_StringList.Count - 1 do
    begin
      Result_StringList.Add(path + MyFile_StringList[i]);
    end;
    Result := Result_stringList.Text;
  finally
    MyFile_StringList.free;
    Result_stringList.free;
  end;
end;

//------------------------------------------------------------------------------
// Function: Create PDF
//------------------------------------------------------------------------------
procedure CreatePDF(aStringList: TStringList; FileSaveName_str: string; font_size: integer);
var
  CurrentCaseDir: string;
  SaveDir: string;
begin
  Progress.Log(Stringofchar('-', CHAR_LENGTH));
  CurrentCaseDir := GetCurrentCaseDir;
  SaveDir := CurrentCaseDir + 'Reports\Run Time Reports\';
  if assigned(aStringList) and (aStringList.Count > 0) then
  begin
    if ForceDirectories(IncludeTrailingPathDelimiter(SaveDir)) and DirectoryExists(SaveDir) then
    begin
      if GeneratePDF(SaveDir + FileSaveName_str, aStringList, font_size) then
        Progress.Log('Saved: ' + SaveDir + FileSaveName_str)
      else
        Progress.Log('Failed to save: ' + SaveDir + FileSaveName_str);
    end
    else
      Progress.Log('Could not find folder: ' + SaveDir);
  end;
end;

// Function: Get File Size -----------------------------------------------------
function ReturnFileSize(aFilename: string): int64;
var
  tempStream: TFileStream;
begin
  Result := 0;
  if FileExists(aFilename) then
  begin
     try
       tempStream := TFileStream.create(aFilename, fmOpenRead or fmShareDenyNone);
       Result := tempStream.size;
     finally
       tempstream.free;
     end;
  end;
end;

//------------------------------------------------------------------------------
// Start of Script
//------------------------------------------------------------------------------
var
  i: integer;
  PDFOutput_StringList: TStringList;
  RAWFiles_StringList: TStringList;
  TaskProgress: TPac;
  filesize_int64: int64;
begin
  Progress.Log('Acquire Memory' + RUNNING);
  TaskProgress := Progress.NewChild;
  RunTask('TCommandTask_AcquireMemory', '', nil, TaskProgress, []); // Writes to Case Export folder as 'memory_yyyy_mmm_dd_hhmmss.raw'
  while (TaskProgress.isRunning) and (Progress.isRunning) do
    Sleep(500); // Do not proceed until TCommandTask is complete
  if not (Progress.isRunning) then
    TaskProgress.Cancel;
  Sleep(5000);

  PDFOutput_StringList := TStringList.Create;
  RAWFiles_StringList := TStringList.Create;
  try
    RAWFiles_StringList.Text := trim(ListFilesInFolder(GetExportedDir));
    if assigned(RAWFiles_StringList) and (RAWFiles_StringList.Count > 0) then
    begin
      PDFOutput_StringList.Add('Memory (RAM) was acquired to the following file:');
      PDFOutput_StringList.Add(' ');
      for i := 0 to RAWFiles_StringList.Count - 1 do
      begin
        if FileExists(RAWFiles_StringList[i]) then
        begin
          filesize_int64 := 0;
          filesize_int64 := ReturnFileSize(trim(RAWFiles_StringList[i]));
          PDFOutput_StringList.Add(RAWFiles_StringList[i] + SPACE + 'File Size: ' +
          IntToStr(filesize_int64) + SPACE + 'bytes' + SPACE + '(' + GetSizeStr(filesize_int64) + ')');
        end
        else
          Progress.Log('Could not locate file: ' + RAWFiles_StringList[i]);
      end;
    end
    else
    begin
      PDFOutput_StringList.Add('Error: Memory (RAM) was not acquired.');
    end;

    CreatePDF(PDFOutput_StringList, 'Memory Acquisition.pdf', 10);

  finally
    PDFOutput_StringList.free;
    RAWFiles_StringList.free;
  end;
  Progress.Log('Finished.');
end.