﻿unit cli_regex_filename_search;

interface

uses
  //GUI, Modules,
  Classes, Clipbrd, Contnrs, Common, DataEntry, DataStorage, DateUtils, DIRegEx, Graphics,
  Math, PropertyList, RegEx, SysUtils;

const
  BM_SCRIPT_OUTPUT_FLDR = 'FEX-Triage';
  BOOKMARK_FILES = True;
  BS = '\';
  CHAR_LENGTH = 80;
  FORMAT_STRING = '%-15s %-15s %-6s %-30s %-50s %-50s';
  MAXIMUM_HITS = 30;
  OPEN_LOG_FILE = True;
  REGEX_KEYWORDS_FILENAME = 'regex_keywords1.txt';
  RPAD_VALUE = 30;
  RUNNING = '...';
  SCRIPT_NAME = 'Folder and File Name Search';
  SHOW_PASS_FAIL_GRAPHIC = False;
  SIG_RAR = 'Rar'; //noslz
  SIG_ZIP = 'Zip'; //noslz
  SPACE = ' ';
  ZIP_IGNORE_REGEX_STR = '(accdt|apk|bau|bbfw|dat|eftx|glox|ipa|ipsw|jar|odb|odg|odp|otp|ots|ott|oxt|rbf|skin|sob|stw|thmx|thmx|ui|wmz|xpi|wmf)';

var
  FileName_Counter: array[0..2000] of integer;
  FS_File_Found_Count: integer;
  gBookmarkHits_TList: TList;
  gchbArchiveFileNames: boolean;
  gColFilenameSearch: TDataStoreField;
  gExportDate: string;
  gExportDateTime: string;
  gExportTime: string;
  gOneBigRegex_str: string;
  gregex_sigmatch_str: string;
  gSearch_StringList: TStringList;
  //MatchText: string;
  MaxHits_int: integer;
  gScriptFolder_str: string;
  gScriptPath_str: string;

implementation

function ShellExecute(hWnd: cardinal; lpOperation: Pchar; lpFile: Pchar; lpParameter: Pchar; lpDirectory: Pchar; nShowCmd: Integer): Thandle; stdcall; external 'Shell32.Dll' name 'ShellExecuteW';

//------------------------------------------------------------------------------
// Function: Right Pad v2
//------------------------------------------------------------------------------
function RPad(const AString: string; AChars: integer): string;
begin
 AChars := AChars - Length(AString);
 if AChars > 0 then
   Result := AString + StringOfChar(' ', AChars)
 else
   Result := AString;
end;

//------------------------------------------------------------------------------
// Function: File Name RegEx Search Index
//------------------------------------------------------------------------------
function FileNameRegExSearchIndex(anEntry: TEntry): boolean;
var
  deleted_status_str: string;
  DeterminedFileDriverInfo: TFileTypeInformation;
  DeviceEntry: TEntry;
  DeviceName_str: string;
  file_signature_str: string;
  FullPathNoComma: string;
  i: integer;
begin
  Result := False;
  for i := 0 to gSearch_StringList.Count -1 do
  begin
   if (RegexMatch(anEntry.EntryName, gSearch_StringList[i], False)) or
   (RegexMatch(anEntry.FullPathName, gSearch_StringList[i], False))
   then
    begin
      DeviceName_str := '';
      DeviceEntry := GetDeviceEntry(anEntry);
      if assigned(DeviceEntry) then
        DeviceName_str := DeviceEntry.EntryName;
      DetermineFileType(anEntry);
      DeterminedFileDriverInfo := anEntry.DeterminedFileDriverInfo;
      file_signature_str := '';
      file_signature_str := DeterminedFileDriverInfo.ShortDisplayName;
      begin
        FileName_Counter[i] := FileName_Counter[i] + 1;
        FullPathNoComma := StringReplace(anEntry.FullPathName,',','_',[rfReplaceAll]);
        if anEntry.isDeleted then deleted_status_str := 'Y' else deleted_status_str := '';
        Progress.Log(anEntry.FullPathName);
        //Progress.Log((format(FORMAT_STRING,[IntToStr(anEntry.ID), file_signature_str, deleted_status_str, DeviceName_str, gSearch_StringList[i], anEntry.FullPathName])));
        //Progress.Log(IntToStr(anEntry.ID) + ',' + file_signature_str + ',' + deleted_status_str + ',' + DeviceName_str + ',' + gSearch_StringList[i] + ',' + FullPathNoComma);
        Result := True;
      end;
    end;
  end;
end;

//------------------------------------------------------------------------------
// Function: File Name RegEx Search - Quick Concatenate Regex Method
//------------------------------------------------------------------------------
function FileNameRegExSearch(anEntry: TEntry): boolean;
var
  aName : string;
begin
  Result := False;
  aName := anEntry.EntryName;
  if (RegexMatch(aName, gOneBigRegex_str, False)) then
    Result := FileNameRegExSearchIndex(anEntry);
  // Also match full path if selected
  //if (not Result) then
  //begin
  //  aName := anEntry.FullPathName;
  //  if (RegexMatch(aName, gOneBigRegex_str, False)) then
  //    Result := FileNameRegExSearchIndex(anEntry);
  //end;
end;

//------------------------------------------------------------------------------
// Function: Test Valid Regex
//------------------------------------------------------------------------------
function IsValidRegEx(aStr : string) : boolean;
var
  aRegEx: TRegEx;
begin
  Result := False;
  aRegEx := TRegEx.Create;
  try
    aRegEx.SearchTerm := aStr;
    Result := aRegEx.LastError = 0;
  finally
    aRegEx.free;
  end;
end;

procedure SignatureAnalysis(SigThis_TList: TList);
var
  TaskProgress: TPAC;
  signature_tick_count: uint64;
  gbl_Continue: boolean;
begin
  if not Progress.isRunning then Exit;
  signature_tick_count := GetTickCount64;
  if not assigned(SigThis_TList) then
  begin
    Progress.Log(RPad('Not assigned Signature TList.', RPAD_VALUE) + 'Signature Analysis not run.');
    Exit;
  end;
  if assigned(SigThis_TList) and (SigThis_TList.Count > 0) then
  begin
    if Progress.isRunning then
    begin
      TaskProgress := NewProgress(False);
      RunTask('TCommandTask_FileTypeAnalysis', DATASTORE_FILESYSTEM, SigThis_TList, TaskProgress);
      while (TaskProgress.isRunning) and (Progress.isRunning) do
        Sleep(500); // Do not proceed until TCommandTask_FileTypeAnalysis is complete
      if not (Progress.isRunning) then
        TaskProgress.Cancel;
      gbl_Continue := (TaskProgress.CompleteState = pcsSuccess);
    end;
  end;
end;

//------------------------------------------------------------------------------
// Procedure: Bookmark Files
//------------------------------------------------------------------------------
procedure BookmarkHits;
var
  bmCreate: Boolean;
  bmFolder: TEntry;
  bmPath: string;
begin
  if (assigned(gBookmarkHits_TList) and (gBookmarkHits_TList.Count > 0)) then
  begin
    bmPath := BM_SCRIPT_OUTPUT_FLDR + BS + 'Folder and File Name Search' + BS + gExportDateTime;
    bmCreate := True;
    bmFolder := FindBookmarkByName(bmPath, bmCreate);
    if assigned(bmFolder) then
    begin
      AddItemsToBookmark(bmFolder, DATASTORE_FILESYSTEM, gBookmarkHits_TList, '');
    end;
  end;
end;

// String FileName RegEx Search Index ------------------------------------------
function StringFileNameRegExSearchIndex(anEntry: TEntry; aString: string): boolean;
var
  i : integer;
  DeterminedFileDriverInfo: TFileTypeInformation;
  file_signature_str: string;
  DeviceEntry: TEntry;
  DeviceName_str: string;
  FullPathNoComma: string;
  deleted_status_str: string;
begin
  Result := False;
  for i := 0 to gSearch_StringList.Count -1 do
  begin
   if not Progress.isRunning then break;
   if (RegexMatch(aString, gSearch_StringList[i], False)) then
    begin
      DeviceName_str := '';
      DeviceEntry := GetDeviceEntry(anEntry);
      if assigned(DeviceEntry) then
        DeviceName_str := DeviceEntry.EntryName;
      DetermineFileType(anEntry);
      DeterminedFileDriverInfo := anEntry.DeterminedFileDriverInfo;
      file_signature_str := '';
      file_signature_str := DeterminedFileDriverInfo.ShortDisplayName;
      if file_signature_str = '' then file_signature_str := 'Unknown';
      begin
        FileName_Counter[i] := FileName_Counter[i] + 1;
        FullPathNoComma := StringReplace(anEntry.FullPathName,',','_',[rfReplaceAll]);
        if anEntry.isDeleted then deleted_status_str := 'Y' else deleted_status_str := '';
        //Progress.Log((format(FORMAT_STRING,[IntToStr(anEntry.ID), file_signature_str, deleted_status_str, DeviceName_str, gSearch_StringList[i], anEntry.FullPathName + ' (* File name in archive file)'])));
        //Progress.Log(IntToStr(anEntry.ID) + ',' + file_signature_str + ',' + deleted_status_str + ',' + DeviceName_str + ',' + gSearch_StringList[i] + ',' + FullPathNoComma);
        Result := True;
      end;
    end;
  end;
end;

// String Regex Search ---------------------------------------------------------
function StringRegExSearch(aString: String; aEntry: TEntry): boolean;
begin
  Result := False;
  if (RegexMatch(aString, gOneBigRegex_str, False)) then
    Result := StringFileNameRegExSearchIndex(aEntry, aString);
end;

//------------------------------------------------------------------------------
// Process Zip internal filenames
//------------------------------------------------------------------------------
procedure ProcessarchiveEntry(baseEntry: TEntry; archiveEntry: TEntry; archive_depth_count: integer);
var
  anExpandedFileList: TList;
  aParentNode: TPropertyNode;
  aPropertyTree: TPropertyParent;
  aReader: TEntryReader;
  aRootProperty: TPropertyNode;
  DeterminedFileDriverInfo: TFileTypeInformation;
  encrypted_str: string;
  Extract_Progress: TPAC;
  h, x, y, z: integer;
  Node1: TPropertyNode;
  Node2: TPropertyNode;
  Node3: TPropertyNode;
  NodeList1: TObjectList;
  NodeList2: TObjectList;
  NumberOfNodes: integer;
  prop_compressed_size_str: string;
  prop_CRC32_str: string;
  prop_Filedate_str: string;
  prop_Filename_str: string;
  prop_uncompressed_size_str: string;

begin
  if RegexMatch(archiveEntry.FileDriverInfo.ShortDisplayName, gregex_sigmatch_str, False) then
  begin
    //Progress.Log(RPad('ProcessarchiveEntry:', RPAD_VALUE) + archiveEntry.EntryName);
    DetermineFileType(archiveEntry);
    DeterminedFileDriverInfo := archiveEntry.DeterminedFileDriverInfo;
    if RegexMatch(archiveEntry.FileDriverInfo.ShortDisplayName, gregex_sigmatch_str, False) then
    begin
      aReader := TEntryReader.Create;
      try
        if aReader.OpenData(archiveEntry) then
        begin
          //--------------------------------------------------------------------
          //  NODES - .PropName, .PropDisplayValue, .PropValue, .PropDataType
          //--------------------------------------------------------------------
          aPropertyTree := nil;
          try
            if ProcessMetadataProperties(archiveEntry, aPropertyTree, aReader) then
            begin
              aRootProperty := aPropertyTree;
              if assigned(aRootProperty) and RegexMatch(archiveEntry.FileDriverInfo.ShortDisplayName, gregex_sigmatch_str, False) and assigned(aRootProperty.PropChildList) and (aRootProperty.PropChildList.Count >= 1) then
              begin
                aParentNode := TPropertyNode(aPropertyTree.GetFirstNodeByName('Encrypted')); //noslz
                for x := 0 to aRootProperty.PropChildList.Count - 1 do
                begin
                  if not Progress.isRunning then break;
                  Node1 := TPropertyNode(aRootProperty.PropChildList.items[x]);
                  if assigned(Node1) then
                  begin
                    NodeList1 := Node1.PropChildList;
                    if assigned(NodeList1) and (NodeList1.Count >= 1) then
                    begin
                      NumberOfNodes := NodeList1.Count;
                      // Initialize
                      prop_FileDate_str := '';
                      prop_CRC32_str := '';
                      prop_uncompressed_size_str := '';
                      prop_compressed_size_str := '';
                      encrypted_str := '';
                      for y := 0 to NumberOfNodes - 1 do
                      begin
                        if not Progress.isRunning then break;
                        prop_Filename_str := '';
                        Node2 := TPropertyNode(NodeList1.items[y]);
                        if assigned(Node2) then
                        begin
                          if Node2.PropName = 'Filename' then //noslz
                          begin
                            prop_Filename_str := Node2.PropDisplayValue;
                          end;

                          // Test the internal zip/rar file name to see if it matches the regex
                          if StringRegExSearch(prop_Filename_str, archiveEntry) then
                          begin
                            //BookmarkFiles_TList.Add(archiveEntry);
                            if {gchbAddMatchColumn and} assigned(gColFilenameSearch) then
                            begin
                              gColFilenameSearch.AsString[baseEntry] := 'GRAHAM'; //MatchText;
                            end;
                            FS_File_Found_Count := FS_File_Found_Count + 1;
                            Progress.DisplayMessages := ('Searching File System - Found: ' + IntToStr(FS_File_Found_Count) + RUNNING);
                            if FS_File_Found_Count >= MaxHits_int then
                            begin
                              //MessageBox('Maximum hits reached: ' + IntToStr(MaxHits_int), SCRIPT_NAME, (MB_OK or MB_ICONINFORMATION or MB_SETFOREGROUND or MB_TOPMOST));
                              Progress.Log('MAXIMUM MATCHES REACHED: ' + IntToStr(MaxHits_int));
                              Break;
                            end;
                          end
                          else
                          begin
                            Continue;
                          end;

                          if Node2.PropName = 'File Date' then prop_FileDate_str := Node2.PropDisplayValue; //noslz
                          if Node2.PropName = 'CRC 32' then prop_CRC32_str := Node2.PropValue; //noslz
                          if Node2.PropName = 'Uncompressed Size' then prop_uncompressed_size_str := Node2.PropValue; //noslz
                          if Node2.PropName = 'Compressed Size' then prop_compressed_size_str := Node2.PropValue; //noslz
                          if Node2.PropName = 'General Flag' then //noslz
                          begin
                            NodeList2 := Node2.PropChildList;
                            if assigned(NodeList2) and (NodeList2.Count >= 1) then
                            begin
                              for z := 0 to NodeList2.Count - 1 do
                              begin
                                if not Progress.isRunning then break;
                                Node3 := TPropertyNode(NodeList2.items[z]);
                                if Node3.PropName = 'Encrypted' then //noslz
                                begin
                                  if Node3.PropValue = 'True' then //noslz
                                    encrypted_str := 'Y'
                                  else
                                    encrypted_str := 'N';
                                end;
                              end;
                            end
                            else
                              encrypted_str := 'N';
                          end;
                          Progress.Log('Internal Archive Filename:' + SPACE + baseEntry.Entryname + ' > ' + prop_Filename_str);
                        end;
                      end;
                    end;
                  end;
                end;
              end;
            end;
          finally
            if assigned(aPropertyTree) then
            begin
              aPropertyTree.free;
              aPropertyTree := nil;
            end;
          end;
        end;
      finally
        aReader.free;
      end;
    end;
  end;

  anExpandedFileList := TList.Create;
  try
    Extract_Progress := NewProgress(False);
    try
      ExtractCompoundFile(archiveEntry, anExpandedFileList, Extract_Progress);
    except
      Progress.Log('ExtractCompoundFile: Could not process - ' + archiveEntry.Entryname);
    end;
    if assigned(anExpandedFileList) and (anExpandedFileList.Count > 0) then
    begin
      SignatureAnalysis(anExpandedFileList);
      archive_depth_count := archive_depth_count + 1;
      for h := 0 to anExpandedFileList.Count - 1 do
      begin
        if not Progress.isRunning then break;
        if archive_depth_count > 10 then
        begin
          Progress.Log(RPad('Reached MAX Archive Depth: ' + IntToStr(archive_depth_count), RPAD_VALUE) + archiveEntry.EntryName + SPACE + 'Bates:' + SPACE + IntToStr(archiveEntry.ID));
          break; // Set the maximum archive level depth
        end;
        archiveEntry := TEntry(anExpandedFileList.items[h]);
        DeterminedFileDriverInfo := archiveEntry.DeterminedFileDriverInfo;
        if RegexMatch(archiveEntry.FileDriverInfo.ShortDisplayName, gregex_sigmatch_str, False) then
        begin
          //Progress.Log('Depth: ' + IntToStr(archive_depth_count));
          ProcessarchiveEntry(baseEntry, archiveEntry, archive_depth_count);
        end;
      end;
    end;
  finally
    anExpandedFileList.free;
  end;
end;

//------------------------------------------------------------------------------
// Procedure: Zippy
//------------------------------------------------------------------------------
procedure Zippy(ArchiveFile_TList: TList);
var
  i: integer;
  archiveEntry: TEntry;
  baseEntry: TEntry;
  aDeterminedFileDriverInfo: TFileTypeInformation;
  archive_list_total_str: string;

begin
  if assigned(ArchiveFile_TList) and (ArchiveFile_TList.Count > 0) then
  begin
    archive_list_total_str := IntToStr(ArchiveFile_TList.Count);

    SignatureAnalysis(ArchiveFile_TList);
    Progress.Initialize(ArchiveFile_TList.Count, 'Searching Zip/Rar internal file names' + RUNNING);
    for i := 0 to ArchiveFile_TList.Count - 1 do
    begin
      if not Progress.isRunning then break;
      archiveEntry := TEntry(ArchiveFile_TList[i]);
      aDeterminedFileDriverInfo := archiveEntry.DeterminedFileDriverInfo;
      if (dtArchive in archiveEntry.DeterminedFileDriverInfo.DriverType) and (not archiveEntry.IsExpanded) then
      begin
        baseEntry := archiveEntry;
        ProcessarchiveEntry(baseEntry, archiveEntry, 0); // Depth count
        Progress.IncCurrentProgress;
      end;
      Progress.DisplayMessages := 'Searching Zip/Rar internal file names' + SPACE + '(' + IntToStr(i) + ' of ' + archive_list_total_str + ')' + RUNNING;
    Progress.IncCurrentProgress;
    end;
  end;
end;

//==============================================================================
// Start of the Script
//==============================================================================
var
  anEntry: TEntry;
  ArchiveFile_TList: TList;
  Archive_TListUnique: TUniqueListOfEntries;
  CommentString: string;
  DataStore_FS: TDataStore;
  Enum: TEntryEnumerator;
  ExportFolder_str: string;
  i: integer;
//  image_path_pass: string;
//  image_path_fail: string;
  KeywordsPath_str: string;
  Regex_Words_StringList: TStringList;

begin
  Progress.Log('Starting script' + RUNNING);
  gregex_sigmatch_str := '(' + SIG_ZIP + '|' + SIG_RAR + ')';
  MaxHits_int := 2000;

  // Locate the regex keywords file
  gScriptPath_str := CmdLine.Path;
  gScriptFolder_str := ExtractFilePath(gScriptPath_str);
  KeywordsPath_str := gScriptFolder_str + 'regex_keywords' + BS + 'regex_keywords1.txt';
  if FileExists(KeywordsPath_str) then
  begin
    Progress.Log(RPad('Found keywords file:', RPAD_VALUE) + KeywordsPath_str);
  end
  else
  begin
    Progress.Log('Cannot locate keywords file: ' + KeywordsPath_str + '. The script will terminate.');
    Exit;
  end;

  ArchiveFile_TList := TList.Create;
  Archive_TListUnique := TUniqueListOfEntries.Create;
  gBookmarkHits_TList := TList.Create;
  try
    // Read the regex keywords file
    Regex_Words_StringList := TStringList.Create;
    Regex_Words_StringList.Delimiter := '|';
    Regex_Words_StringList.StrictDelimiter := True;
    try
      Regex_Words_StringList.LoadFromFile(KeywordsPath_str);

      // Remove any comment strings
      for i := Regex_Words_StringList.Count - 1 downto 0 do
      begin
        CommentString := copy(Regex_Words_StringList[i], 1, 1);
        if CommentString = '#' then
          Regex_Words_StringList.Delete(i);
      end;

      // Convert the keywords into one big regex statement
      gOneBigRegex_str := Regex_Words_StringList.DelimitedText;
      if IsValidRegEx(gOneBigRegex_str) then
      begin
        Progress.Log(RPad('Valid regex:', RPAD_VALUE) + gOneBigRegex_str);
      end
      else
      begin
        Progress.Log('Invalid regex. The script will terminate:' + #13#10 + gOneBigRegex_str);
        Regex_Words_StringList.free;
        Exit;
      end;

      // Logging
      Progress.Log(RPad('Maximum Hits:', RPAD_VALUE) + IntToStr(MAXIMUM_HITS));

      if BOOKMARK_FILES then
        Progress.Log(RPad('Bookmark Files:', RPAD_VALUE) + 'True')
      else
        Progress.Log(RPad('Bookmark Files:', RPAD_VALUE) + 'False');

      if SHOW_PASS_FAIL_GRAPHIC then
        Progress.Log(RPad('Show pass/fail graphic:', RPAD_VALUE) + 'True')
      else
        Progress.Log(RPad('Show pass/fail graphic:', RPAD_VALUE) + 'False');

      Progress.Log(Stringofchar('-', CHAR_LENGTH));

      // Initialize
      FS_File_Found_Count := 0;
      gExportDate := formatdatetime('yyyy-mm-dd', now);
      gExportTime := formatdatetime('hh-nn-ss', now);
      gExportDateTime := (gExportDate + '-' + gExportTime);
      ExportFolder_str := 'Export - ' + gExportDateTime;
      gColFilenameSearch := AddMetaDataField('HIT', ftString);

      // Loop File System and search for regex hits ----------------------------
      DataStore_FS := GetDataStore(DATASTORE_FILESYSTEM);
      if DataStore_FS = nil then
        Exit;
      try
        gSearch_StringList := TStringList.Create;
        try
          gSearch_StringList.Text := gOneBigRegex_str;
          anEntry := DataStore_FS.First;
          Progress.Max := DataStore_FS.Count;
          Progress.CurrentPosition := 0;

          while assigned(anEntry) and (Progress.isRunning) do
          begin

            // Collect zip and rar files during the loop.
            if RegexMatch(anEntry.FileDriverInfo.ShortDisplayName, gregex_sigmatch_str, False) then //noslz
            begin
              if not regexmatch(anEntry.Extension, ZIP_IGNORE_REGEX_STR, False) then
              begin
                if assigned(Archive_TListUnique) then
                begin
                  Archive_TListUnique.Add(anEntry);
                end
                else
                  Progress.Log('Not assigned: Archive_TListUnique');
              end;
            end;

            if FileNameRegExSearch(anEntry) then
            begin
              if BOOKMARK_FILES and (FS_File_Found_Count < MAXIMUM_HITS) then
                gBookmarkHits_TList.Add(anEntry);

              if assigned(gColFilenameSearch) then
                gColFilenameSearch.AsString[anEntry] := 'HIT';

              FS_File_Found_Count := FS_File_Found_Count + 1;
              Progress.DisplayMessages := ('Searching File System - Found: ' + IntToStr(FS_File_Found_Count) + RUNNING);

              if FS_File_Found_Count >= MAXIMUM_HITS then
              begin
                Progress.Log('MAXIMUM MATCHES REACHED: ' + IntToStr(MAXIMUM_HITS));
                Break;
              end;

            end;
            Progress.IncCurrentProgress;
            anEntry := DataStore_FS.Next;
          end;

          // Move the Archive_TListUnique list into ArchiveFile_TList
          if assigned(Archive_TListUnique) and (Archive_TListUnique.Count > 0) then
          begin
            Enum := Archive_TListUnique.GetEnumerator;
            while Enum.MoveNext do
            begin
              anEntry := Enum.Current;
              ArchiveFile_TList.Add(anEntry);
            end;
          end;

          // Process Zip/Rar Internal File Names
          gchbArchiveFileNames := True;
          if gchbArchiveFileNames and assigned(ArchiveFile_TList) and (ArchiveFile_TList.Count > 0) then
          begin
            Zippy(ArchiveFile_TList);
          end;

        finally
          gSearch_StringList.free;
        end;
      finally
        DataStore_FS.free;
      end;
    finally
      Regex_Words_StringList.free;
    end;

    if BOOKMARK_FILES and (assigned(gBookmarkHits_TList)) and (gBookmarkHits_TList.Count > 0) then
      BookmarkHits;
  finally
    ArchiveFile_TList.free;
    Archive_TListUnique.free;
    gBookmarkHits_TList.free;
  end;

  Progress.Log(Stringofchar('-', CHAR_LENGTH));
  if FS_File_Found_Count > 0 then
    Progress.Log(IntToStr(FS_File_Found_Count) + ' files found.')
  else
    Progress.Log('No files found.');

  if OPEN_LOG_FILE then
    ShellExecute(0,nil,'explorer.exe',pchar(Progress.LogFilename),nil,1);

//  if SHOW_PASS_FAIL_GRAPHIC then
//  begin
//    image_path_fail := gscriptFolder_str + 'graphics' + BS + 'fail.png';
//    image_path_pass := gscriptFolder_str + 'graphics' + BS + 'pass.png';
//    if (FS_File_Found_Count > 0) and FileExists(image_path_fail) then
//      ShellExecute(0,nil,'explorer.exe',pchar(image_path_fail),nil,1)
//    else if (FS_File_Found_Count = 0) and FileExists(image_path_pass) then
//      ShellExecute(0,nil,'explorer.exe',pchar(image_path_pass),nil,1);
//  end;
end.